/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.common.NodeRef;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.transformation.api.LayerPointReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.builder.EvaluationDAGBuilder;
import org.apache.iotdb.db.queryengine.transformation.dag.input.QueryDataSetInputLayer;
import org.apache.iotdb.db.queryengine.transformation.dag.input.TsBlockInputDataSet;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFContext;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class TransformOperator
implements ProcessOperator {
    protected final float udfReaderMemoryBudgetInMB = IoTDBDescriptor.getInstance().getConfig().getUdfReaderMemoryBudgetInMB();
    protected final float udfTransformerMemoryBudgetInMB = IoTDBDescriptor.getInstance().getConfig().getUdfTransformerMemoryBudgetInMB();
    protected final float udfCollectorMemoryBudgetInMB = IoTDBDescriptor.getInstance().getConfig().getUdfCollectorMemoryBudgetInMB();
    protected final OperatorContext operatorContext;
    protected final Operator inputOperator;
    protected final boolean keepNull;
    protected QueryDataSetInputLayer inputLayer;
    protected UDTFContext udtfContext;
    protected LayerPointReader[] transformers;
    protected List<TSDataType> outputDataTypes;
    protected TimeSelector timeHeap;
    protected boolean[] shouldIterateReadersToNextValid;
    private final String udtfQueryId;

    public TransformOperator(OperatorContext operatorContext, Operator inputOperator, List<TSDataType> inputDataTypes, Map<String, List<InputLocation>> inputLocations, Expression[] outputExpressions, boolean keepNull, ZoneId zoneId, Map<NodeRef<Expression>, TSDataType> expressionTypes, boolean isAscending) throws QueryProcessException {
        this.operatorContext = operatorContext;
        this.inputOperator = inputOperator;
        this.keepNull = keepNull;
        this.udtfQueryId = operatorContext.getDriverContext().getDriverTaskID().getFullId();
        this.initInputLayer(inputDataTypes);
        this.initUdtfContext(outputExpressions, zoneId);
        this.initTransformers(inputLocations, outputExpressions, expressionTypes);
        this.timeHeap = new TimeSelector(this.transformers.length << 1, isAscending);
        this.shouldIterateReadersToNextValid = new boolean[outputExpressions.length];
        Arrays.fill(this.shouldIterateReadersToNextValid, true);
    }

    private void initInputLayer(List<TSDataType> inputDataTypes) throws QueryProcessException {
        this.inputLayer = new QueryDataSetInputLayer(this.udtfQueryId, this.udfReaderMemoryBudgetInMB, new TsBlockInputDataSet(this.inputOperator, inputDataTypes));
    }

    private void initUdtfContext(Expression[] outputExpressions, ZoneId zoneId) {
        this.udtfContext = new UDTFContext(zoneId);
        this.udtfContext.constructUdfExecutors(outputExpressions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTransformers(Map<String, List<InputLocation>> inputLocations, Expression[] outputExpressions, Map<NodeRef<Expression>, TSDataType> expressionTypes) {
        UDFManagementService.getInstance().acquireLock();
        try {
            UDFClassLoaderManager.getInstance().initializeUDFQuery(this.udtfQueryId);
            this.transformers = new EvaluationDAGBuilder(this.udtfQueryId, this.inputLayer, inputLocations, outputExpressions, expressionTypes, this.udtfContext, this.udfTransformerMemoryBudgetInMB + this.udfCollectorMemoryBudgetInMB).buildLayerMemoryAssigner().bindInputLayerColumnIndexWithExpression().buildResultColumnPointReaders().getOutputPointReaders();
        }
        finally {
            UDFManagementService.getInstance().releaseLock();
        }
    }

    protected YieldableState iterateAllColumnsToNextValid() throws Exception {
        int n = this.shouldIterateReadersToNextValid.length;
        for (int i = 0; i < n; ++i) {
            if (!this.shouldIterateReadersToNextValid[i]) continue;
            YieldableState yieldableState = this.iterateReaderToNextValid(this.transformers[i]);
            if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
            }
            this.shouldIterateReadersToNextValid[i] = false;
        }
        return YieldableState.YIELDABLE;
    }

    protected YieldableState iterateReaderToNextValid(LayerPointReader reader) throws Exception {
        YieldableState yieldableState;
        while ((yieldableState = reader.yield()) == YieldableState.YIELDABLE) {
            if (reader.isCurrentNull() && !this.keepNull) {
                reader.readyForNext();
                continue;
            }
            this.timeHeap.add(reader.currentTime());
            break;
        }
        return yieldableState;
    }

    @Override
    public final boolean hasNext() throws Exception {
        if (!this.timeHeap.isEmpty()) {
            return true;
        }
        try {
            if (this.iterateAllColumnsToNextValid() == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return !this.timeHeap.isEmpty();
    }

    @Override
    public TsBlock next() throws Exception {
        try {
            YieldableState yieldableState = this.iterateAllColumnsToNextValid();
            if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                return null;
            }
            TsBlockBuilder tsBlockBuilder = TsBlockBuilder.createWithOnlyTimeColumn();
            this.prepareTsBlockBuilder(tsBlockBuilder);
            TimeColumnBuilder timeBuilder = tsBlockBuilder.getTimeColumnBuilder();
            ColumnBuilder[] columnBuilders = tsBlockBuilder.getValueColumnBuilders();
            int columnCount = columnBuilders.length;
            int rowCount = 0;
            while (!this.timeHeap.isEmpty()) {
                long currentTime = this.timeHeap.pollFirst();
                timeBuilder.writeLong(currentTime);
                for (int i = 0; i < columnCount; ++i) {
                    yieldableState = this.collectDataPoint(this.transformers[i], columnBuilders[i], currentTime, i);
                    if (yieldableState != YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) continue;
                    for (int j = 0; j <= i; ++j) {
                        this.shouldIterateReadersToNextValid[j] = false;
                    }
                    this.timeHeap.add(currentTime);
                    tsBlockBuilder.declarePositions(rowCount);
                    return tsBlockBuilder.build();
                }
                this.prepareEachColumn(columnCount);
                ++rowCount;
                yieldableState = this.iterateAllColumnsToNextValid();
                if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                    tsBlockBuilder.declarePositions(rowCount);
                    return tsBlockBuilder.build();
                }
                this.inputLayer.updateRowRecordListEvictionUpperBound();
            }
            tsBlockBuilder.declarePositions(rowCount);
            return tsBlockBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void prepareTsBlockBuilder(TsBlockBuilder tsBlockBuilder) {
        if (this.outputDataTypes == null) {
            this.outputDataTypes = new ArrayList<TSDataType>();
            for (LayerPointReader reader : this.transformers) {
                this.outputDataTypes.add(reader.getDataType());
            }
        }
        tsBlockBuilder.buildValueColumnBuilders(this.outputDataTypes);
    }

    private void prepareEachColumn(int columnCount) {
        for (int i = 0; i < columnCount; ++i) {
            if (!this.shouldIterateReadersToNextValid[i]) continue;
            this.transformers[i].readyForNext();
        }
    }

    protected boolean collectReaderAppendIsNull(LayerPointReader reader, long currentTime) throws Exception {
        YieldableState yieldableState = reader.yield();
        if (yieldableState == YieldableState.NOT_YIELDABLE_NO_MORE_DATA) {
            return true;
        }
        if (yieldableState != YieldableState.YIELDABLE) {
            return false;
        }
        if (reader.currentTime() != currentTime) {
            return true;
        }
        return reader.isCurrentNull();
    }

    protected YieldableState collectDataPoint(LayerPointReader reader, ColumnBuilder writer, long currentTime, int readerIndex) throws Exception {
        YieldableState yieldableState = reader.yield();
        if (yieldableState == YieldableState.NOT_YIELDABLE_NO_MORE_DATA) {
            writer.appendNull();
            return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
        }
        if (yieldableState != YieldableState.YIELDABLE) {
            return yieldableState;
        }
        if (reader.currentTime() != currentTime) {
            writer.appendNull();
            return YieldableState.YIELDABLE;
        }
        if (reader.isCurrentNull()) {
            writer.appendNull();
        } else {
            TSDataType type = reader.getDataType();
            switch (type) {
                case INT32: {
                    writer.writeInt(reader.currentInt());
                    break;
                }
                case INT64: {
                    writer.writeLong(reader.currentLong());
                    break;
                }
                case FLOAT: {
                    writer.writeFloat(reader.currentFloat());
                    break;
                }
                case DOUBLE: {
                    writer.writeDouble(reader.currentDouble());
                    break;
                }
                case BOOLEAN: {
                    writer.writeBoolean(reader.currentBoolean());
                    break;
                }
                case TEXT: {
                    writer.writeBinary(reader.currentBinary());
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                }
            }
        }
        this.shouldIterateReadersToNextValid[readerIndex] = true;
        return YieldableState.YIELDABLE;
    }

    @Override
    public void close() throws Exception {
        this.udtfContext.finalizeUDFExecutors(this.udtfQueryId);
        this.inputOperator.close();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.inputOperator.isBlocked();
    }

    @Override
    public boolean isFinished() throws Exception {
        boolean flag = !this.hasNextWithTimer();
        return this.timeHeap.isEmpty() && (flag || this.inputOperator.isFinished());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return (long)(this.udfCollectorMemoryBudgetInMB + this.udfTransformerMemoryBudgetInMB + (float)this.inputOperator.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return (long)(1 + this.transformers.length) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return (long)((float)this.inputOperator.calculateRetainedSizeAfterCallingNext() + this.udfCollectorMemoryBudgetInMB);
    }

    public LayerPointReader[] getTransformers() {
        return this.transformers;
    }
}

