/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.sink;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelIndex;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISinkHandle;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class ShuffleHelperOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Operator> children;
    private final DownStreamChannelIndex downStreamChannelIndex;
    private final ISinkHandle sinkHandle;
    private final Set<Integer> unfinishedChildren;
    private boolean needToReturnNull = false;

    public ShuffleHelperOperator(OperatorContext operatorContext, List<Operator> children, DownStreamChannelIndex downStreamChannelIndex, ISinkHandle sinkHandle) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.downStreamChannelIndex = downStreamChannelIndex;
        this.sinkHandle = sinkHandle;
        this.unfinishedChildren = new HashSet<Integer>(children.size());
        for (int i = 0; i < children.size(); ++i) {
            this.unfinishedChildren.add(i);
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        int currentIndex = this.downStreamChannelIndex.getCurrentIndex();
        boolean currentChannelClosed = this.sinkHandle.isChannelClosed(currentIndex);
        if (!currentChannelClosed && this.children.get(currentIndex).hasNext()) {
            return true;
        }
        if (currentChannelClosed) {
            this.closeCurrentChild(currentIndex);
        } else {
            this.closeCurrentChild(currentIndex);
            this.sinkHandle.setNoMoreTsBlocksOfOneChannel(currentIndex);
        }
        this.unfinishedChildren.remove(currentIndex);
        currentIndex = (currentIndex + 1) % this.children.size();
        this.downStreamChannelIndex.setCurrentIndex(currentIndex);
        this.needToReturnNull = true;
        this.sinkHandle.tryOpenChannel(currentIndex);
        return true;
    }

    private void closeCurrentChild(int index) throws Exception {
        this.children.get(index).close();
        this.children.set(index, null);
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.needToReturnNull) {
            this.needToReturnNull = false;
            return null;
        }
        return this.children.get(this.downStreamChannelIndex.getCurrentIndex()).next();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        int currentIndex = this.downStreamChannelIndex.getCurrentIndex();
        for (int steps = 0; this.children.get(currentIndex) == null && steps < this.children.size(); ++steps) {
            currentIndex = (currentIndex + 1) % this.children.size();
        }
        this.downStreamChannelIndex.setCurrentIndex(currentIndex);
        Operator child = this.children.get(currentIndex);
        return child == null ? NOT_BLOCKED : child.isBlocked();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.unfinishedChildren.isEmpty() || this.sinkHandle.isClosed();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            if (child == null) continue;
            child.close();
        }
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        for (Operator child : this.children) {
            maxPeekMemory = Math.max(maxPeekMemory, child.calculateMaxPeekMemoryWithCounter());
        }
        return maxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long maxReturnSize = 0L;
        for (Operator child : this.children) {
            maxReturnSize = Math.max(maxReturnSize, child.calculateMaxReturnSize());
        }
        return maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }
}

