/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class TemplatedInfo {
    private final List<String> measurementList;
    private final List<IMeasurementSchema> schemaList;
    private final List<TSDataType> dataTypes;
    private final Ordering scanOrder;
    private final boolean queryAllSensors;
    private final List<String> selectMeasurements;
    private final List<Integer> deviceToMeasurementIndexes;
    private final long offsetValue;
    private final long limitValue;
    private final Expression predicate;
    private boolean keepNull;
    private Map<String, IMeasurementSchema> schemaMap;
    private Map<String, List<InputLocation>> layoutMap;
    private int maxTsBlockLineNum = -1;
    private Expression pushDownPredicate;

    public TemplatedInfo(List<String> measurementList, List<IMeasurementSchema> schemaList, List<TSDataType> dataTypes, Ordering scanOrder, boolean queryAllSensors, List<String> selectMeasurements, List<Integer> deviceToMeasurementIndexes, long offsetValue, long limitValue, Expression predicate, boolean keepNull, Map<String, IMeasurementSchema> schemaMap, Map<String, List<InputLocation>> layoutMap, Expression pushDownPredicate) {
        this.measurementList = measurementList;
        this.schemaList = schemaList;
        this.dataTypes = dataTypes;
        this.scanOrder = scanOrder;
        this.queryAllSensors = queryAllSensors;
        this.selectMeasurements = selectMeasurements;
        this.deviceToMeasurementIndexes = deviceToMeasurementIndexes;
        this.offsetValue = offsetValue;
        this.limitValue = limitValue;
        this.predicate = predicate;
        if (predicate != null) {
            this.keepNull = keepNull;
            this.schemaMap = schemaMap;
            this.layoutMap = layoutMap;
        }
        this.pushDownPredicate = pushDownPredicate;
    }

    public List<String> getMeasurementList() {
        return this.measurementList;
    }

    public List<IMeasurementSchema> getSchemaList() {
        return this.schemaList;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    public boolean isQueryAllSensors() {
        return this.queryAllSensors;
    }

    public List<String> getSelectMeasurements() {
        return this.selectMeasurements;
    }

    public long getOffsetValue() {
        return this.offsetValue;
    }

    public long getLimitValue() {
        return this.limitValue;
    }

    public List<Integer> getDeviceToMeasurementIndexes() {
        return this.deviceToMeasurementIndexes;
    }

    public Expression getPredicate() {
        return this.predicate;
    }

    public boolean isKeepNull() {
        return this.keepNull;
    }

    public Map<String, IMeasurementSchema> getSchemaMap() {
        return this.schemaMap;
    }

    public Map<String, List<InputLocation>> getLayoutMap() {
        return this.layoutMap;
    }

    public Expression getPushDownPredicate() {
        return this.pushDownPredicate;
    }

    public void setPushDownPredicate(Expression pushDownPredicate) {
        this.pushDownPredicate = pushDownPredicate;
    }

    public boolean hasPushDownPredicate() {
        return this.pushDownPredicate != null;
    }

    public Expression[] getProjectExpressions() {
        Expression[] projectExpressions = new Expression[this.measurementList.size()];
        for (int i = 0; i < this.measurementList.size(); ++i) {
            projectExpressions[i] = new TimeSeriesOperand((PartialPath)new MeasurementPath(new PartialPath(new String[]{this.measurementList.get(i)}), this.schemaList.get(i)));
        }
        return projectExpressions;
    }

    public static Map<String, List<InputLocation>> makeLayout(List<String> measurementList) {
        LinkedHashMap<String, List<InputLocation>> outputMappings = new LinkedHashMap<String, List<InputLocation>>();
        int tsBlockIndex = 0;
        outputMappings.computeIfAbsent("Time", key -> new ArrayList()).add(new InputLocation(tsBlockIndex, -1));
        int valueColumnIndex = 0;
        for (String columnName : measurementList) {
            outputMappings.computeIfAbsent(columnName, key -> new ArrayList()).add(new InputLocation(tsBlockIndex, valueColumnIndex));
            ++valueColumnIndex;
        }
        return outputMappings;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.measurementList.size(), (ByteBuffer)byteBuffer);
        for (String measurement : this.measurementList) {
            ReadWriteIOUtils.write((String)measurement, (ByteBuffer)byteBuffer);
        }
        for (IMeasurementSchema schema : this.schemaList) {
            schema.serializeTo(byteBuffer);
        }
        for (TSDataType dataType : this.dataTypes) {
            ReadWriteIOUtils.write((TSDataType)dataType, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.queryAllSensors, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.selectMeasurements.size(), (ByteBuffer)byteBuffer);
        for (String selectMeasurement : this.selectMeasurements) {
            ReadWriteIOUtils.write((String)selectMeasurement, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.deviceToMeasurementIndexes.size(), (ByteBuffer)byteBuffer);
        Iterator<Object> iterator = this.deviceToMeasurementIndexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            ReadWriteIOUtils.write((int)index, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((long)this.offsetValue, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.limitValue, (ByteBuffer)byteBuffer);
        if (this.predicate != null) {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            Expression.serialize(this.predicate, byteBuffer);
            ReadWriteIOUtils.write((Boolean)this.keepNull, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        }
        if (this.pushDownPredicate != null) {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            Expression.serialize(this.pushDownPredicate, byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.measurementList.size(), (OutputStream)stream);
        for (String measurement : this.measurementList) {
            ReadWriteIOUtils.write((String)measurement, (OutputStream)stream);
        }
        for (IMeasurementSchema schema : this.schemaList) {
            schema.serializeTo((OutputStream)stream);
        }
        for (TSDataType dataType : this.dataTypes) {
            ReadWriteIOUtils.write((TSDataType)dataType, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.queryAllSensors, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.selectMeasurements.size(), (OutputStream)stream);
        for (String selectMeasurement : this.selectMeasurements) {
            ReadWriteIOUtils.write((String)selectMeasurement, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.deviceToMeasurementIndexes.size(), (OutputStream)stream);
        Iterator<Object> iterator = this.deviceToMeasurementIndexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            ReadWriteIOUtils.write((int)index, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((long)this.offsetValue, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.limitValue, (OutputStream)stream);
        if (this.predicate != null) {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            Expression.serialize(this.predicate, stream);
            ReadWriteIOUtils.write((Boolean)this.keepNull, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        }
        if (this.pushDownPredicate != null) {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            Expression.serialize(this.pushDownPredicate, stream);
        } else {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        }
    }

    public static TemplatedInfo deserialize(ByteBuffer byteBuffer) {
        int measurementSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<String> measurementList = new ArrayList<String>();
        int cnt = measurementSize;
        while (cnt-- > 0) {
            measurementList.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        cnt = measurementSize;
        ArrayList<IMeasurementSchema> measurementSchemaList = new ArrayList<IMeasurementSchema>();
        while (cnt-- > 0) {
            measurementSchemaList.add((IMeasurementSchema)MeasurementSchema.deserializeFrom((ByteBuffer)byteBuffer));
        }
        cnt = measurementSize;
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>();
        while (cnt-- > 0) {
            dataTypeList.add(ReadWriteIOUtils.readDataType((ByteBuffer)byteBuffer));
        }
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        boolean queryAllSensors = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        int listSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<String> selectMeasurements = new ArrayList<String>(listSize);
        while (listSize-- > 0) {
            selectMeasurements.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        listSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Integer> deviceToMeasurementIndexes = new ArrayList<Integer>(listSize);
        while (listSize-- > 0) {
            deviceToMeasurementIndexes.add(ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        }
        long offsetValue = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long limitValue = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        Expression predicate = null;
        byte hasFilter = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        HashMap<String, IMeasurementSchema> currentSchemaMap = null;
        Map<String, List<InputLocation>> layoutMap = null;
        boolean keepNull = false;
        if (hasFilter == 1) {
            predicate = Expression.deserialize(byteBuffer);
            keepNull = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
            currentSchemaMap = new HashMap<String, IMeasurementSchema>();
            for (IMeasurementSchema measurementSchema : measurementSchemaList) {
                currentSchemaMap.put(measurementSchema.getMeasurementId(), measurementSchema);
            }
            layoutMap = TemplatedInfo.makeLayout(measurementList);
        }
        Expression pushDownPredicate = null;
        byte hasPushDownFilter = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        if (hasPushDownFilter == 1) {
            pushDownPredicate = Expression.deserialize(byteBuffer);
        }
        return new TemplatedInfo(measurementList, measurementSchemaList, dataTypeList, scanOrder, queryAllSensors, selectMeasurements, deviceToMeasurementIndexes, offsetValue, limitValue, predicate, keepNull, currentSchemaMap, layoutMap, pushDownPredicate);
    }
}

