/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.utils.columngenerator.parameter.ColumnGeneratorParameter;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ColumnInjectNode
extends SingleChildProcessNode {
    private final int targetIndex;
    private final ColumnGeneratorParameter columnGeneratorParameter;

    public ColumnInjectNode(PlanNodeId id, int targetIndex, ColumnGeneratorParameter columnGeneratorParameter) {
        super(id);
        this.targetIndex = targetIndex;
        this.columnGeneratorParameter = columnGeneratorParameter;
    }

    public ColumnInjectNode(PlanNodeId id, PlanNode child, int targetIndex, ColumnGeneratorParameter columnGeneratorParameter) {
        super(id, child);
        this.targetIndex = targetIndex;
        this.columnGeneratorParameter = columnGeneratorParameter;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitColumnInject(this, context);
    }

    public List<TSDataType> getGeneratedColumnTypes() {
        return this.columnGeneratorParameter.getColumnTypes();
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public ColumnGeneratorParameter getColumnGeneratorParameter() {
        return this.columnGeneratorParameter;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.COLUMN_INJECT;
    }

    @Override
    public PlanNode clone() {
        return new ColumnInjectNode(this.getPlanNodeId(), this.targetIndex, this.columnGeneratorParameter);
    }

    @Override
    public List<String> getOutputColumnNames() {
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        List<String> childOutputColumnNames = this.child.getOutputColumnNames();
        if (this.targetIndex == childOutputColumnNames.size()) {
            outputColumnNames.addAll(childOutputColumnNames);
            outputColumnNames.addAll(this.columnGeneratorParameter.getColumnNames());
            return outputColumnNames;
        }
        for (int i = 0; i < childOutputColumnNames.size(); ++i) {
            if (i == this.targetIndex) {
                outputColumnNames.addAll(this.columnGeneratorParameter.getColumnNames());
            }
            outputColumnNames.add(childOutputColumnNames.get(i));
        }
        return outputColumnNames;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.COLUMN_INJECT.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.targetIndex, (ByteBuffer)byteBuffer);
        this.columnGeneratorParameter.serialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.COLUMN_INJECT.serialize(stream);
        ReadWriteIOUtils.write((int)this.targetIndex, (OutputStream)stream);
        this.columnGeneratorParameter.serialize(stream);
    }

    public static ColumnInjectNode deserialize(ByteBuffer byteBuffer) {
        int targetIndex = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ColumnGeneratorParameter columnGeneratorParameter = ColumnGeneratorParameter.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new ColumnInjectNode(planNodeId, targetIndex, columnGeneratorParameter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ColumnInjectNode that = (ColumnInjectNode)o;
        return this.targetIndex == that.targetIndex && this.columnGeneratorParameter.equals(that.columnGeneratorParameter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetIndex, this.columnGeneratorParameter);
    }
}

