/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class OffsetNode
extends SingleChildProcessNode {
    private final long offset;

    public OffsetNode(PlanNodeId id, long offset) {
        super(id);
        this.offset = offset;
    }

    public OffsetNode(PlanNodeId id, PlanNode child, long offset) {
        super(id, child);
        this.offset = offset;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.OFFSET;
    }

    @Override
    public PlanNode clone() {
        return new OffsetNode(this.getPlanNodeId(), this.offset);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitOffset(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.OFFSET.serialize(byteBuffer);
        ReadWriteIOUtils.write((long)this.offset, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.OFFSET.serialize(stream);
        ReadWriteIOUtils.write((long)this.offset, (OutputStream)stream);
    }

    public static OffsetNode deserialize(ByteBuffer byteBuffer) {
        long offset = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new OffsetNode(planNodeId, offset);
    }

    public long getOffset() {
        return this.offset;
    }

    public String toString() {
        return "OffsetNode-" + this.getPlanNodeId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetNode that = (OffsetNode)o;
        return this.offset == that.offset;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.offset);
    }
}

