/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.LastSeriesSourceNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.eclipse.jetty.util.StringUtil;

public class LastQueryScanNode
extends LastSeriesSourceNode {
    public static final List<String> LAST_QUERY_HEADER_COLUMNS = ImmutableList.of((Object)"Timeseries", (Object)"Value", (Object)"DataType");
    private final MeasurementPath seriesPath;
    private final String outputViewPath;
    private TRegionReplicaSet regionReplicaSet;

    public LastQueryScanNode(PlanNodeId id, MeasurementPath seriesPath, String outputViewPath) {
        super(id, new AtomicInteger(1));
        this.seriesPath = seriesPath;
        this.outputViewPath = outputViewPath;
    }

    public LastQueryScanNode(PlanNodeId id, MeasurementPath seriesPath, AtomicInteger dataNodeSeriesScanNum, String outputViewPath) {
        super(id, dataNodeSeriesScanNum);
        this.seriesPath = seriesPath;
        this.outputViewPath = outputViewPath;
    }

    public LastQueryScanNode(PlanNodeId id, MeasurementPath seriesPath, AtomicInteger dataNodeSeriesScanNum, String outputViewPath, TRegionReplicaSet regionReplicaSet) {
        super(id, dataNodeSeriesScanNum);
        this.seriesPath = seriesPath;
        this.outputViewPath = outputViewPath;
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    public MeasurementPath getSeriesPath() {
        return this.seriesPath;
    }

    public String getOutputViewPath() {
        return this.outputViewPath;
    }

    public String getOutputSymbolForSort() {
        if (this.outputViewPath != null) {
            return this.outputViewPath;
        }
        return this.seriesPath.getFullPath();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("no child is allowed for SeriesScanNode");
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.LAST_QUERY_SCAN;
    }

    @Override
    public PlanNode clone() {
        return new LastQueryScanNode(this.getPlanNodeId(), this.seriesPath, this.getDataNodeSeriesScanNum(), this.outputViewPath, this.regionReplicaSet);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return LAST_QUERY_HEADER_COLUMNS;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLastQueryScan(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LastQueryScanNode that = (LastQueryScanNode)o;
        return Objects.equals(this.seriesPath, that.seriesPath) && Objects.equals(this.outputViewPath, that.outputViewPath) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.seriesPath, this.outputViewPath, this.regionReplicaSet);
    }

    public String toString() {
        if (StringUtil.isNotBlank((String)this.outputViewPath)) {
            return String.format("LastQueryScanNode-%s:[SeriesPath: %s, ViewPath: %s, DataRegion: %s]", this.getPlanNodeId(), this.getSeriesPath(), this.getOutputViewPath(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
        }
        return String.format("LastQueryScanNode-%s:[SeriesPath: %s, DataRegion: %s]", this.getPlanNodeId(), this.getSeriesPath(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LAST_QUERY_SCAN.serialize(byteBuffer);
        this.seriesPath.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.getDataNodeSeriesScanNum().get(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)(this.outputViewPath == null ? 1 : 0), (ByteBuffer)byteBuffer);
        if (this.outputViewPath != null) {
            ReadWriteIOUtils.write((String)this.outputViewPath, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LAST_QUERY_SCAN.serialize(stream);
        this.seriesPath.serialize((OutputStream)stream);
        ReadWriteIOUtils.write((int)this.getDataNodeSeriesScanNum().get(), (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)(this.outputViewPath == null ? 1 : 0), (OutputStream)stream);
        if (this.outputViewPath != null) {
            ReadWriteIOUtils.write((String)this.outputViewPath, (OutputStream)stream);
        }
    }

    public static LastQueryScanNode deserialize(ByteBuffer byteBuffer) {
        MeasurementPath partialPath = (MeasurementPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        int dataNodeSeriesScanNum = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        boolean isNull = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        String outputPathSymbol = isNull ? null : ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LastQueryScanNode(planNodeId, partialPath, new AtomicInteger(dataNodeSeriesScanNum), outputPathSymbol);
    }

    @Override
    public PartialPath getPartitionPath() {
        return this.getSeriesPath();
    }

    public String outputPathSymbol() {
        if (this.outputViewPath == null) {
            return this.seriesPath.getFullPath();
        }
        return this.outputViewPath;
    }
}

