/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.scheduler.load;

import io.airlift.units.Duration;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.ExecutorType;
import org.apache.iotdb.commons.partition.StorageExecutor;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.exception.LoadReadOnlyException;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceDispatchException;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.execution.QueryStateMachine;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInfo;
import org.apache.iotdb.db.queryengine.execution.load.ChunkData;
import org.apache.iotdb.db.queryengine.execution.load.TsFileData;
import org.apache.iotdb.db.queryengine.execution.load.TsFileSplitter;
import org.apache.iotdb.db.queryengine.load.LoadTsFileDataCacheMemoryBlock;
import org.apache.iotdb.db.queryengine.load.LoadTsFileMemoryManager;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadSingleTsFileNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadTsFilePieceNode;
import org.apache.iotdb.db.queryengine.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.db.queryengine.plan.scheduler.IScheduler;
import org.apache.iotdb.db.queryengine.plan.scheduler.load.LoadTsFileDispatcherImpl;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.flush.MemTableFlushTask;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.mpp.rpc.thrift.TLoadCommandReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileScheduler
implements IScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileScheduler.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final long SINGLE_SCHEDULER_MAX_MEMORY_SIZE = IoTDBDescriptor.getInstance().getConfig().getThriftMaxFrameSize() >> 2;
    private static final int TRANSMIT_LIMIT = CommonDescriptor.getInstance().getConfig().getTTimePartitionSlotTransmitLimit();
    private static final Set<String> LOADING_FILE_SET = new HashSet<String>();
    private final MPPQueryContext queryContext;
    private final QueryStateMachine stateMachine;
    private final LoadTsFileDispatcherImpl dispatcher;
    private final DataPartitionBatchFetcher partitionFetcher;
    private final List<LoadSingleTsFileNode> tsFileNodeList;
    private final PlanFragmentId fragmentId;
    private final Set<TRegionReplicaSet> allReplicaSets;
    private final boolean isGeneratedByPipe;
    private final LoadTsFileDataCacheMemoryBlock block;

    public LoadTsFileScheduler(DistributedQueryPlan distributedQueryPlan, MPPQueryContext queryContext, QueryStateMachine stateMachine, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager, IPartitionFetcher partitionFetcher, boolean isGeneratedByPipe) {
        this.queryContext = queryContext;
        this.stateMachine = stateMachine;
        this.tsFileNodeList = new ArrayList<LoadSingleTsFileNode>();
        this.fragmentId = distributedQueryPlan.getRootSubPlan().getPlanFragment().getId();
        this.dispatcher = new LoadTsFileDispatcherImpl(internalServiceClientManager, isGeneratedByPipe);
        this.partitionFetcher = new DataPartitionBatchFetcher(partitionFetcher);
        this.allReplicaSets = new HashSet<TRegionReplicaSet>();
        this.isGeneratedByPipe = isGeneratedByPipe;
        this.block = LoadTsFileMemoryManager.getInstance().allocateDataCacheMemoryBlock();
        for (FragmentInstance fragmentInstance : distributedQueryPlan.getInstances()) {
            this.tsFileNodeList.add((LoadSingleTsFileNode)fragmentInstance.getFragment().getPlanNodeTree());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try {
            this.stateMachine.transitionToRunning();
            int tsFileNodeListSize = this.tsFileNodeList.size();
            boolean isLoadSuccess = true;
            for (int i = 0; i < tsFileNodeListSize; ++i) {
                Set<String> set;
                LoadSingleTsFileNode node = this.tsFileNodeList.get(i);
                String filePath = node.getTsFileResource().getTsFilePath();
                boolean isLoadSingleTsFileSuccess = true;
                boolean shouldRemoveFileFromLoadingSet = false;
                try {
                    set = LOADING_FILE_SET;
                    synchronized (set) {
                        if (LOADING_FILE_SET.contains(filePath)) {
                            throw new LoadFileException(String.format("TsFile %s is loading by another scheduler.", filePath));
                        }
                        LOADING_FILE_SET.add(filePath);
                    }
                    shouldRemoveFileFromLoadingSet = true;
                    if (node.isTsFileEmpty()) {
                        LOGGER.info("Load skip TsFile {}, because it has no data.", (Object)filePath);
                    } else if (!node.needDecodeTsFile(slotList -> this.partitionFetcher.queryDataPartition((List<Pair<IDeviceID, TTimePartitionSlot>>)slotList, this.queryContext.getSession().getUserName()))) {
                        isLoadSingleTsFileSuccess = this.loadLocally(node);
                        node.clean();
                    } else {
                        String uuid = UUID.randomUUID().toString();
                        this.dispatcher.setUuid(uuid);
                        this.allReplicaSets.clear();
                        boolean isFirstPhaseSuccess = this.firstPhase(node);
                        boolean isSecondPhaseSuccess = this.secondPhase(isFirstPhaseSuccess, uuid, node.getTsFileResource());
                        node.clean();
                        if (!isFirstPhaseSuccess || !isSecondPhaseSuccess) {
                            isLoadSingleTsFileSuccess = false;
                        }
                    }
                    if (isLoadSingleTsFileSuccess) {
                        LOGGER.info("Load TsFile {} Successfully, load process [{}/{}]", new Object[]{filePath, i + 1, tsFileNodeListSize});
                        continue;
                    }
                    isLoadSuccess = false;
                    LOGGER.warn("Can not Load TsFile {}, load process [{}/{}]", new Object[]{filePath, i + 1, tsFileNodeListSize});
                    continue;
                }
                catch (Exception e) {
                    isLoadSuccess = false;
                    this.stateMachine.transitionToFailed(e);
                    LOGGER.warn("LoadTsFileScheduler loads TsFile {} error", (Object)filePath, (Object)e);
                    continue;
                }
                finally {
                    if (shouldRemoveFileFromLoadingSet) {
                        set = LOADING_FILE_SET;
                        synchronized (set) {
                            LOADING_FILE_SET.remove(filePath);
                        }
                    }
                }
            }
            if (isLoadSuccess) {
                this.stateMachine.transitionToFinished();
            }
        }
        finally {
            LoadTsFileMemoryManager.getInstance().releaseDataCacheMemoryBlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean firstPhase(LoadSingleTsFileNode node) {
        TsFileDataManager tsFileDataManager = new TsFileDataManager(this, node, this.block);
        try {
            new TsFileSplitter(node.getTsFileResource().getTsFile(), x$0 -> tsFileDataManager.addOrSendTsFileData(x$0)).splitTsFileByDataPartition();
            if (!tsFileDataManager.sendAllTsFileData()) {
                this.stateMachine.transitionToFailed(new TSStatus(TSStatusCode.LOAD_FILE_ERROR.getStatusCode()));
                boolean bl = false;
                return bl;
            }
        }
        catch (IllegalStateException e) {
            this.stateMachine.transitionToFailed(e);
            LOGGER.warn(String.format("Dispatch TsFileData error when parsing TsFile %s.", node.getTsFileResource().getTsFile()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.stateMachine.transitionToFailed(e);
            LOGGER.warn(String.format("Parse or send TsFile %s error.", node.getTsFileResource().getTsFile()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            tsFileDataManager.clear();
        }
        return true;
    }

    private boolean dispatchOnePieceNode(LoadTsFilePieceNode pieceNode, TRegionReplicaSet replicaSet) {
        this.allReplicaSets.add(replicaSet);
        FragmentInstance instance = new FragmentInstance(new PlanFragment(this.fragmentId, pieceNode), this.fragmentId.genFragmentInstanceId(), null, this.queryContext.getQueryType(), this.queryContext.getTimeOut(), this.queryContext.getSession());
        instance.setExecutorAndHost((ExecutorType)new StorageExecutor(replicaSet));
        Future<FragInstanceDispatchResult> dispatchResultFuture = this.dispatcher.dispatch(Collections.singletonList(instance));
        try {
            FragInstanceDispatchResult result = dispatchResultFuture.get(CONFIG.getLoadCleanupTaskExecutionDelayTimeSeconds(), TimeUnit.SECONDS);
            if (!result.isSuccessful()) {
                LOGGER.warn("Dispatch one piece to ReplicaSet {} error. Result status code {}. Result status message {}. Dispatch piece node error:%n{}", new Object[]{replicaSet, TSStatusCode.representOf((int)result.getFailureStatus().getCode()).name(), result.getFailureStatus().getMessage(), pieceNode});
                if (result.getFailureStatus().getSubStatus() != null) {
                    for (TSStatus status : result.getFailureStatus().getSubStatus()) {
                        LOGGER.warn("Sub status code {}. Sub status message {}.", (Object)TSStatusCode.representOf((int)status.getCode()).name(), (Object)status.getMessage());
                    }
                }
                TSStatus status = result.getFailureStatus();
                status.setMessage(String.format("Load %s piece error in 1st phase. Because ", pieceNode.getTsFile()) + status.getMessage());
                this.stateMachine.transitionToFailed(status);
                return false;
            }
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOGGER.warn("Interrupt or Execution error.", (Throwable)e);
            this.stateMachine.transitionToFailed(e);
            return false;
        }
        catch (TimeoutException e) {
            dispatchResultFuture.cancel(true);
            LOGGER.warn(String.format("Wait for loading %s time out.", LoadTsFilePieceNode.class.getName()), (Throwable)e);
            this.stateMachine.transitionToFailed(e);
            return false;
        }
        return true;
    }

    private boolean secondPhase(boolean isFirstPhaseSuccess, String uuid, TsFileResource tsFileResource) {
        LOGGER.info("Start dispatching Load command for uuid {}", (Object)uuid);
        File tsFile = tsFileResource.getTsFile();
        TLoadCommandReq loadCommandReq = new TLoadCommandReq((isFirstPhaseSuccess ? LoadCommand.EXECUTE : LoadCommand.ROLLBACK).ordinal(), uuid);
        try {
            loadCommandReq.setIsGeneratedByPipe(this.isGeneratedByPipe);
            loadCommandReq.setProgressIndex(this.assignProgressIndex(tsFileResource));
            Future<FragInstanceDispatchResult> dispatchResultFuture = this.dispatcher.dispatchCommand(loadCommandReq, this.allReplicaSets);
            FragInstanceDispatchResult result = dispatchResultFuture.get();
            if (!result.isSuccessful()) {
                LOGGER.warn("Dispatch load command {} of TsFile {} error to replicaSets {} error. Result status code {}. Result status message {}.", new Object[]{loadCommandReq, tsFile, this.allReplicaSets, TSStatusCode.representOf((int)result.getFailureStatus().getCode()).name(), result.getFailureStatus().getMessage()});
                TSStatus status = result.getFailureStatus();
                status.setMessage(String.format("Load %s error in 2nd phase. Because ", tsFile) + status.getMessage());
                this.stateMachine.transitionToFailed(status);
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Serialize Progress Index error, isFirstPhaseSuccess: {}, uuid: {}, tsFile: {}", new Object[]{isFirstPhaseSuccess, uuid, tsFile.getAbsolutePath()});
            this.stateMachine.transitionToFailed(e);
            return false;
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOGGER.warn("Interrupt or Execution error.", (Throwable)e);
            this.stateMachine.transitionToFailed(e);
            return false;
        }
        return true;
    }

    private ByteBuffer assignProgressIndex(TsFileResource tsFileResource) throws IOException {
        PipeAgent.runtime().assignProgressIndexForTsFileLoad(tsFileResource);
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                tsFileResource.getMaxProgressIndex().serialize((OutputStream)dataOutputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
    }

    private boolean loadLocally(LoadSingleTsFileNode node) throws IoTDBException {
        LOGGER.info("Start load TsFile {} locally.", (Object)node.getTsFileResource().getTsFile().getPath());
        if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new LoadReadOnlyException();
        }
        try {
            FragmentInstance instance = new FragmentInstance(new PlanFragment(this.fragmentId, node), this.fragmentId.genFragmentInstanceId(), null, this.queryContext.getQueryType(), this.queryContext.getTimeOut(), this.queryContext.getSession());
            instance.setExecutorAndHost((ExecutorType)new StorageExecutor(node.getLocalRegionReplicaSet()));
            this.dispatcher.dispatchLocally(instance);
        }
        catch (FragmentInstanceDispatchException e) {
            LOGGER.warn(String.format("Dispatch tsFile %s error to local error. Result status code %s. Result status message %s.", node.getTsFileResource().getTsFile(), TSStatusCode.representOf((int)e.getFailureStatus().getCode()).name(), e.getFailureStatus().getMessage()));
            this.stateMachine.transitionToFailed(e.getFailureStatus());
            return false;
        }
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion((DataRegionId)ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)node.getLocalRegionReplicaSet().getRegionId()));
        dataRegion.getNonSystemDatabaseName().ifPresent(databaseName -> {
            MemTableFlushTask.recordFlushPointsMetricInternal(node.getWritePointCount(), databaseName, dataRegion.getDataRegionId());
            MetricService.getInstance().count(node.getWritePointCount(), Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), Metric.POINTS_IN.toString(), Tag.DATABASE.toString(), databaseName, Tag.REGION.toString(), dataRegion.getDataRegionId()});
        });
        return true;
    }

    @Override
    public void stop(Throwable t) {
    }

    @Override
    public Duration getTotalCpuTime() {
        return null;
    }

    @Override
    public FragmentInfo getFragmentInfo() {
        return null;
    }

    private static class DataPartitionBatchFetcher {
        private final IPartitionFetcher fetcher;

        public DataPartitionBatchFetcher(IPartitionFetcher fetcher) {
            this.fetcher = fetcher;
        }

        public List<TRegionReplicaSet> queryDataPartition(List<Pair<IDeviceID, TTimePartitionSlot>> slotList, String userName) {
            ArrayList<TRegionReplicaSet> replicaSets = new ArrayList<TRegionReplicaSet>();
            int size = slotList.size();
            for (int i = 0; i < size; i += TRANSMIT_LIMIT) {
                List<Pair<IDeviceID, TTimePartitionSlot>> subSlotList = slotList.subList(i, Math.min(size, i + TRANSMIT_LIMIT));
                DataPartition dataPartition = this.fetcher.getOrCreateDataPartition(this.toQueryParam(subSlotList), userName);
                replicaSets.addAll(subSlotList.stream().map(pair -> dataPartition.getDataRegionReplicaSetForWriting(((PlainDeviceID)pair.left).toStringID(), (TTimePartitionSlot)pair.right)).collect(Collectors.toList()));
            }
            return replicaSets;
        }

        private List<DataPartitionQueryParam> toQueryParam(List<Pair<IDeviceID, TTimePartitionSlot>> slots) {
            return slots.stream().collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toSet()))).entrySet().stream().map(entry -> new DataPartitionQueryParam(((PlainDeviceID)entry.getKey()).toStringID(), new ArrayList((Collection)entry.getValue()))).collect(Collectors.toList());
        }
    }

    private static class TsFileDataManager {
        private final LoadTsFileScheduler scheduler;
        private final LoadSingleTsFileNode singleTsFileNode;
        private long dataSize;
        private final Map<TRegionReplicaSet, LoadTsFilePieceNode> replicaSet2Piece;
        private final List<ChunkData> nonDirectionalChunkData;
        private final LoadTsFileDataCacheMemoryBlock block;

        public TsFileDataManager(LoadTsFileScheduler scheduler, LoadSingleTsFileNode singleTsFileNode, LoadTsFileDataCacheMemoryBlock block) {
            this.scheduler = scheduler;
            this.singleTsFileNode = singleTsFileNode;
            this.dataSize = 0L;
            this.replicaSet2Piece = new HashMap<TRegionReplicaSet, LoadTsFilePieceNode>();
            this.nonDirectionalChunkData = new ArrayList<ChunkData>();
            this.block = block;
        }

        private boolean addOrSendTsFileData(TsFileData tsFileData) {
            return tsFileData.isModification() ? this.addOrSendDeletionData(tsFileData) : this.addOrSendChunkData((ChunkData)tsFileData);
        }

        private boolean isMemoryEnough() {
            return this.dataSize <= SINGLE_SCHEDULER_MAX_MEMORY_SIZE && this.block.hasEnoughMemory();
        }

        private boolean addOrSendChunkData(ChunkData chunkData) {
            this.nonDirectionalChunkData.add(chunkData);
            this.dataSize += chunkData.getDataSize();
            this.block.addMemoryUsage(chunkData.getDataSize());
            if (!this.isMemoryEnough()) {
                TRegionReplicaSet sortedReplicaSet;
                LoadTsFilePieceNode pieceNode;
                this.routeChunkData();
                List sortedReplicaSets = this.replicaSet2Piece.keySet().stream().sorted(Comparator.comparingLong(o -> this.replicaSet2Piece.get(o).getDataSize()).reversed()).collect(Collectors.toList());
                Iterator iterator = sortedReplicaSets.iterator();
                while (iterator.hasNext() && (pieceNode = this.replicaSet2Piece.get(sortedReplicaSet = (TRegionReplicaSet)iterator.next())).getDataSize() != 0L) {
                    if (!this.scheduler.dispatchOnePieceNode(pieceNode, sortedReplicaSet)) {
                        return false;
                    }
                    this.dataSize -= pieceNode.getDataSize();
                    this.block.reduceMemoryUsage(pieceNode.getDataSize());
                    this.replicaSet2Piece.put(sortedReplicaSet, new LoadTsFilePieceNode(this.singleTsFileNode.getPlanNodeId(), this.singleTsFileNode.getTsFileResource().getTsFile()));
                    if (!this.isMemoryEnough()) continue;
                    break;
                }
            }
            return true;
        }

        private void routeChunkData() {
            if (this.nonDirectionalChunkData.isEmpty()) {
                return;
            }
            List<TRegionReplicaSet> replicaSets = this.scheduler.partitionFetcher.queryDataPartition(this.nonDirectionalChunkData.stream().map(data -> new Pair((Object)new PlainDeviceID(data.getDevice()), (Object)data.getTimePartitionSlot())).collect(Collectors.toList()), this.scheduler.queryContext.getSession().getUserName());
            IntStream.range(0, this.nonDirectionalChunkData.size()).forEach(i -> this.replicaSet2Piece.computeIfAbsent((TRegionReplicaSet)replicaSets.get(i), o -> new LoadTsFilePieceNode(this.singleTsFileNode.getPlanNodeId(), this.singleTsFileNode.getTsFileResource().getTsFile())).addTsFileData(this.nonDirectionalChunkData.get(i)));
            this.nonDirectionalChunkData.clear();
        }

        private boolean addOrSendDeletionData(TsFileData deletionData) {
            this.routeChunkData();
            for (Map.Entry<TRegionReplicaSet, LoadTsFilePieceNode> entry : this.replicaSet2Piece.entrySet()) {
                this.dataSize += deletionData.getDataSize();
                this.block.addMemoryUsage(deletionData.getDataSize());
                entry.getValue().addTsFileData(deletionData);
            }
            return true;
        }

        private boolean sendAllTsFileData() {
            this.routeChunkData();
            for (Map.Entry<TRegionReplicaSet, LoadTsFilePieceNode> entry : this.replicaSet2Piece.entrySet()) {
                this.block.reduceMemoryUsage(entry.getValue().getDataSize());
                if (this.scheduler.dispatchOnePieceNode(entry.getValue(), entry.getKey())) continue;
                LOGGER.warn("Dispatch piece node {} of TsFile {} error.", (Object)entry.getValue(), (Object)this.singleTsFileNode.getTsFileResource().getTsFile());
                return false;
            }
            return true;
        }

        private void clear() {
            this.replicaSet2Piece.clear();
        }
    }

    public static enum LoadCommand {
        EXECUTE,
        ROLLBACK;

    }
}

