/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class CreateAlignedTimeSeriesStatement
extends Statement {
    private PartialPath devicePath;
    private List<String> measurements = new ArrayList<String>();
    private List<TSDataType> dataTypes = new ArrayList<TSDataType>();
    private List<TSEncoding> encodings = new ArrayList<TSEncoding>();
    private List<CompressionType> compressors = new ArrayList<CompressionType>();
    private List<String> aliasList = new ArrayList<String>();
    private List<Map<String, String>> tagsList = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> attributesList = new ArrayList<Map<String, String>>();

    public CreateAlignedTimeSeriesStatement() {
        this.statementType = StatementType.CREATE_ALIGNED_TIME_SERIES;
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        for (String measurement : this.measurements) {
            paths.add(this.devicePath.concatNode(measurement));
        }
        return paths;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List<PartialPath> checkedPaths = this.getPaths();
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathListPermission(userName, checkedPaths, PrivilegeType.WRITE_SCHEMA.ordinal()), checkedPaths, PrivilegeType.WRITE_SCHEMA);
    }

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(PartialPath devicePath) {
        this.devicePath = devicePath;
    }

    public List<String> getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(List<String> measurements) {
        this.measurements = measurements;
    }

    public void addMeasurement(String measurement) {
        this.measurements.add(measurement);
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public void addDataType(TSDataType dataType) {
        this.dataTypes.add(dataType);
    }

    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    public void setEncodings(List<TSEncoding> encodings) {
        this.encodings = encodings;
    }

    public void addEncoding(TSEncoding encoding) {
        this.encodings.add(encoding);
    }

    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    public void setCompressors(List<CompressionType> compressors) {
        this.compressors = compressors;
    }

    public void addCompressor(CompressionType compression) {
        this.compressors.add(compression);
    }

    public List<String> getAliasList() {
        return this.aliasList;
    }

    public void setAliasList(List<String> aliasList) {
        this.aliasList = aliasList;
    }

    public void addAliasList(String alias) {
        this.aliasList.add(alias);
    }

    public List<Map<String, String>> getTagsList() {
        return this.tagsList;
    }

    public void setTagsList(List<Map<String, String>> tagsList) {
        this.tagsList = tagsList;
    }

    public void addTagsList(Map<String, String> tags) {
        this.tagsList.add(tags);
    }

    public List<Map<String, String>> getAttributesList() {
        return this.attributesList;
    }

    public void setAttributesList(List<Map<String, String>> attributesList) {
        this.attributesList = attributesList;
    }

    public void addAttributesList(Map<String, String> attributes) {
        this.attributesList.add(attributes);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreateAlignedTimeseries(this, context);
    }
}

