/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushStatus;
import org.apache.iotdb.db.storageengine.dataregion.flush.NotifyFlushMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.WritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public abstract class AbstractMemTable
implements IMemTable {
    public static final AtomicLong memTableIdCounter = new AtomicLong(-1L);
    private static final int FIXED_SERIALIZED_SIZE = 57;
    private final Map<IDeviceID, IWritableMemChunkGroup> memTableMap;
    private static final DeviceIDFactory deviceIDFactory = DeviceIDFactory.getInstance();
    private boolean shouldFlush = false;
    private volatile FlushStatus flushStatus = FlushStatus.WORKING;
    private final int avgSeriesPointNumThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
    private long memSize = 0L;
    private long tvListRamCost = 0L;
    private int seriesNumber = 0;
    private long totalPointsNum = 0L;
    private long totalPointsNumThreshold = 0L;
    private long maxPlanIndex = Long.MIN_VALUE;
    private long minPlanIndex = Long.MAX_VALUE;
    private final long memTableId = memTableIdCounter.incrementAndGet();
    private final long createdTime;
    private long updateTime = this.createdTime = System.currentTimeMillis();
    private long lastTotalPointsNum = this.totalPointsNum;
    private String database;
    private String dataRegionId;
    private static final String METRIC_POINT_IN = Metric.POINTS_IN.toString();
    private final AtomicBoolean isTotallyGeneratedByPipe = new AtomicBoolean(true);

    protected AbstractMemTable() {
        this.database = null;
        this.dataRegionId = null;
        this.memTableMap = new HashMap<IDeviceID, IWritableMemChunkGroup>();
    }

    protected AbstractMemTable(String database, String dataRegionId) {
        this.database = database;
        this.dataRegionId = dataRegionId;
        this.memTableMap = new HashMap<IDeviceID, IWritableMemChunkGroup>();
    }

    protected AbstractMemTable(String database, String dataRegionId, Map<IDeviceID, IWritableMemChunkGroup> memTableMap) {
        this.database = database;
        this.dataRegionId = dataRegionId;
        this.memTableMap = memTableMap;
    }

    @Override
    public Map<IDeviceID, IWritableMemChunkGroup> getMemTableMap() {
        return this.memTableMap;
    }

    private IWritableMemChunkGroup createMemChunkGroupIfNotExistAndGet(IDeviceID deviceId, List<IMeasurementSchema> schemaList) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.computeIfAbsent(deviceId, k -> new WritableMemChunkGroup());
        for (IMeasurementSchema schema : schemaList) {
            if (schema == null || memChunkGroup.contains(schema.getMeasurementId())) continue;
            ++this.seriesNumber;
            this.totalPointsNumThreshold += (long)this.avgSeriesPointNumThreshold;
        }
        return memChunkGroup;
    }

    private IWritableMemChunkGroup createAlignedMemChunkGroupIfNotExistAndGet(IDeviceID deviceId, List<IMeasurementSchema> schemaList) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.computeIfAbsent(deviceId, k -> {
            this.seriesNumber += schemaList.size();
            this.totalPointsNumThreshold += (long)this.avgSeriesPointNumThreshold * (long)schemaList.size();
            return new AlignedWritableMemChunkGroup(schemaList.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        });
        for (IMeasurementSchema schema : schemaList) {
            if (schema == null || memChunkGroup.contains(schema.getMeasurementId())) continue;
            ++this.seriesNumber;
            this.totalPointsNumThreshold += (long)this.avgSeriesPointNumThreshold;
        }
        return memChunkGroup;
    }

    @Override
    public void insert(InsertRowNode insertRowNode) {
        String[] measurements = insertRowNode.getMeasurements();
        Object[] values = insertRowNode.getValues();
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        int nullPointsNumber = 0;
        for (int i = 0; i < insertRowNode.getMeasurements().length; ++i) {
            if (measurements[i] == null || values[i] == null) {
                if (values[i] == null) {
                    ++nullPointsNumber;
                }
                schemaList.add(null);
                continue;
            }
            MeasurementSchema schema = insertRowNode.getMeasurementSchemas()[i];
            schemaList.add((IMeasurementSchema)schema);
            dataTypes.add(schema.getType());
        }
        this.memSize += MemUtils.getRowRecordSize(dataTypes, values);
        this.write(insertRowNode.getDeviceID(), schemaList, insertRowNode.getTime(), values);
        int pointsInserted = insertRowNode.getMeasurements().length - insertRowNode.getFailedMeasurementNumber() - nullPointsNumber;
        this.totalPointsNum += (long)pointsInserted;
        MetricService.getInstance().count((long)pointsInserted, Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId});
    }

    @Override
    public void insertAlignedRow(InsertRowNode insertRowNode) {
        String[] measurements = insertRowNode.getMeasurements();
        Object[] values = insertRowNode.getValues();
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < insertRowNode.getMeasurements().length; ++i) {
            if (measurements[i] == null || values[i] == null) {
                schemaList.add(null);
                continue;
            }
            MeasurementSchema schema = insertRowNode.getMeasurementSchemas()[i];
            schemaList.add((IMeasurementSchema)schema);
            dataTypes.add(schema.getType());
        }
        if (schemaList.isEmpty()) {
            return;
        }
        this.memSize += MemUtils.getAlignedRowRecordSize(dataTypes, values);
        this.writeAlignedRow(insertRowNode.getDeviceID(), schemaList, insertRowNode.getTime(), values);
        int pointsInserted = insertRowNode.getMeasurements().length - insertRowNode.getFailedMeasurementNumber();
        this.totalPointsNum += (long)pointsInserted;
        MetricService.getInstance().count((long)pointsInserted, Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId});
    }

    @Override
    public void insertTablet(InsertTabletNode insertTabletNode, int start, int end) throws WriteProcessException {
        try {
            this.writeTabletNode(insertTabletNode, start, end);
            this.memSize += MemUtils.getTabletSize(insertTabletNode, start, end);
            int pointsInserted = (insertTabletNode.getDataTypes().length - insertTabletNode.getFailedMeasurementNumber()) * (end - start);
            this.totalPointsNum += (long)pointsInserted;
            MetricService.getInstance().count((long)pointsInserted, Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId});
        }
        catch (RuntimeException e) {
            throw new WriteProcessException(e);
        }
    }

    @Override
    public void insertAlignedTablet(InsertTabletNode insertTabletNode, int start, int end) throws WriteProcessException {
        try {
            this.writeAlignedTablet(insertTabletNode, start, end);
            this.memSize += MemUtils.getAlignedTabletSize(insertTabletNode, start, end);
            int pointsInserted = (insertTabletNode.getDataTypes().length - insertTabletNode.getFailedMeasurementNumber()) * (end - start);
            this.totalPointsNum += (long)pointsInserted;
            MetricService.getInstance().count((long)pointsInserted, Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId});
        }
        catch (RuntimeException e) {
            throw new WriteProcessException(e);
        }
    }

    @Override
    public void write(IDeviceID deviceId, List<IMeasurementSchema> schemaList, long insertTime, Object[] objectValue) {
        IWritableMemChunkGroup memChunkGroup = this.createMemChunkGroupIfNotExistAndGet(deviceId, schemaList);
        if (memChunkGroup.writeWithFlushCheck(insertTime, objectValue, schemaList)) {
            this.shouldFlush = true;
        }
    }

    @Override
    public void writeAlignedRow(IDeviceID deviceId, List<IMeasurementSchema> schemaList, long insertTime, Object[] objectValue) {
        IWritableMemChunkGroup memChunkGroup = this.createAlignedMemChunkGroupIfNotExistAndGet(deviceId, schemaList);
        if (memChunkGroup.writeWithFlushCheck(insertTime, objectValue, schemaList)) {
            this.shouldFlush = true;
        }
    }

    public void writeTabletNode(InsertTabletNode insertTabletNode, int start, int end) {
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        for (int i = 0; i < insertTabletNode.getMeasurementSchemas().length; ++i) {
            if (insertTabletNode.getColumns()[i] == null) {
                schemaList.add(null);
                continue;
            }
            schemaList.add((IMeasurementSchema)insertTabletNode.getMeasurementSchemas()[i]);
        }
        IWritableMemChunkGroup memChunkGroup = this.createMemChunkGroupIfNotExistAndGet(insertTabletNode.getDeviceID(), schemaList);
        if (memChunkGroup.writeValuesWithFlushCheck(insertTabletNode.getTimes(), insertTabletNode.getColumns(), insertTabletNode.getBitMaps(), schemaList, start, end)) {
            this.shouldFlush = true;
        }
    }

    public void writeAlignedTablet(InsertTabletNode insertTabletNode, int start, int end) {
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        for (int i = 0; i < insertTabletNode.getMeasurementSchemas().length; ++i) {
            if (insertTabletNode.getColumns()[i] == null) {
                schemaList.add(null);
                continue;
            }
            schemaList.add((IMeasurementSchema)insertTabletNode.getMeasurementSchemas()[i]);
        }
        if (schemaList.isEmpty()) {
            return;
        }
        IWritableMemChunkGroup memChunkGroup = this.createAlignedMemChunkGroupIfNotExistAndGet(insertTabletNode.getDeviceID(), schemaList);
        if (memChunkGroup.writeValuesWithFlushCheck(insertTabletNode.getTimes(), insertTabletNode.getColumns(), insertTabletNode.getBitMaps(), schemaList, start, end)) {
            this.shouldFlush = true;
        }
    }

    @Override
    public boolean checkIfChunkDoesNotExist(IDeviceID deviceId, String measurement) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.get(deviceId);
        if (null == memChunkGroup) {
            return true;
        }
        return !memChunkGroup.contains(measurement);
    }

    @Override
    public long getCurrentTVListSize(IDeviceID deviceId, String measurement) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.get(deviceId);
        if (null == memChunkGroup) {
            return 0L;
        }
        return memChunkGroup.getCurrentTVListSize(measurement);
    }

    @Override
    public int getSeriesNumber() {
        return this.seriesNumber;
    }

    @Override
    public long getTotalPointsNum() {
        return this.totalPointsNum;
    }

    @Override
    public long size() {
        long sum = 0L;
        for (IWritableMemChunkGroup writableMemChunkGroup : this.memTableMap.values()) {
            sum += writableMemChunkGroup.count();
        }
        return sum;
    }

    @Override
    public long memSize() {
        return this.memSize;
    }

    @Override
    public boolean reachTotalPointNumThreshold() {
        if (this.totalPointsNum == 0L) {
            return false;
        }
        return this.totalPointsNum >= this.totalPointsNumThreshold;
    }

    @Override
    public void clear() {
        this.memTableMap.clear();
        this.memSize = 0L;
        this.seriesNumber = 0;
        this.totalPointsNum = 0L;
        this.totalPointsNumThreshold = 0L;
        this.tvListRamCost = 0L;
        this.maxPlanIndex = 0L;
        this.minPlanIndex = 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.memTableMap.isEmpty();
    }

    @Override
    public ReadOnlyMemChunk query(QueryContext context, PartialPath fullPath, long ttlLowerBound, List<Pair<Modification, IMemTable>> modsToMemtable) throws IOException, QueryProcessException {
        return ResourceByPathUtils.getResourceInstance(fullPath).getReadOnlyMemChunkFromMemTable(context, this, modsToMemtable, ttlLowerBound);
    }

    @Override
    public void delete(PartialPath originalPath, PartialPath devicePath, long startTimestamp, long endTimestamp) {
        if (devicePath.hasWildcard()) {
            ArrayList<Pair> targetDeviceList = new ArrayList<Pair>();
            for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
                try {
                    PartialPath devicePathInMemTable = new PartialPath(entry.getKey());
                    if (!devicePath.matchFullPath(devicePathInMemTable)) continue;
                    targetDeviceList.add(new Pair((Object)devicePathInMemTable, (Object)entry.getValue()));
                }
                catch (IllegalPathException illegalPathException) {}
            }
            for (Pair targetDevice : targetDeviceList) {
                this.deleteDataInChunkGroup((IWritableMemChunkGroup)targetDevice.right, originalPath, (PartialPath)targetDevice.left, startTimestamp, endTimestamp);
            }
        } else {
            IWritableMemChunkGroup memChunkGroup = this.memTableMap.get(deviceIDFactory.getDeviceID(devicePath));
            if (memChunkGroup == null) {
                return;
            }
            this.deleteDataInChunkGroup(memChunkGroup, originalPath, devicePath, startTimestamp, endTimestamp);
        }
    }

    private void deleteDataInChunkGroup(IWritableMemChunkGroup memChunkGroup, PartialPath originalPath, PartialPath devicePath, long startTimestamp, long endTimestamp) {
        this.totalPointsNum -= (long)memChunkGroup.delete(originalPath, devicePath, startTimestamp, endTimestamp);
        if (memChunkGroup.getMemChunkMap().isEmpty()) {
            this.memTableMap.remove(deviceIDFactory.getDeviceID(devicePath));
        }
    }

    @Override
    public void addTVListRamCost(long cost) {
        this.tvListRamCost += cost;
    }

    @Override
    public void releaseTVListRamCost(long cost) {
        this.tvListRamCost -= cost;
    }

    @Override
    public long getTVListsRamCost() {
        return this.tvListRamCost;
    }

    @Override
    public void addTextDataSize(long textDataSize) {
        this.memSize += textDataSize;
    }

    @Override
    public void releaseTextDataSize(long textDataSize) {
        this.memSize -= textDataSize;
    }

    @Override
    public void setShouldFlush() {
        this.shouldFlush = true;
    }

    @Override
    public boolean shouldFlush() {
        return this.shouldFlush;
    }

    @Override
    public void release() {
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            entry.getValue().release();
        }
    }

    @Override
    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    @Override
    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    @Override
    public long getMemTableId() {
        return this.memTableId;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public long getUpdateTime() {
        if (this.lastTotalPointsNum != this.totalPointsNum) {
            this.lastTotalPointsNum = this.totalPointsNum;
            this.updateTime = System.currentTimeMillis();
        }
        return this.updateTime;
    }

    @Override
    public FlushStatus getFlushStatus() {
        return this.flushStatus;
    }

    @Override
    public void setFlushStatus(FlushStatus flushStatus) {
        this.flushStatus = flushStatus;
    }

    @Override
    public int serializedSize() {
        if (this.isSignalMemTable()) {
            return 1;
        }
        int size = 57;
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            size += ReadWriteIOUtils.sizeToWrite((String)((PlainDeviceID)entry.getKey()).toStringID());
            ++size;
            size += entry.getValue().serializedSize();
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        WALWriteUtils.write(this.isSignalMemTable(), buffer);
        if (this.isSignalMemTable()) {
            return;
        }
        buffer.putInt(this.seriesNumber);
        buffer.putLong(this.memSize);
        buffer.putLong(this.tvListRamCost);
        buffer.putLong(this.totalPointsNum);
        buffer.putLong(this.totalPointsNumThreshold);
        buffer.putLong(this.maxPlanIndex);
        buffer.putLong(this.minPlanIndex);
        buffer.putInt(this.memTableMap.size());
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            WALWriteUtils.write(((PlainDeviceID)entry.getKey()).toStringID(), buffer);
            IWritableMemChunkGroup memChunkGroup = entry.getValue();
            WALWriteUtils.write(memChunkGroup instanceof AlignedWritableMemChunkGroup, buffer);
            memChunkGroup.serializeToWAL(buffer);
        }
    }

    public void deserialize(DataInputStream stream) throws IOException {
        this.seriesNumber = stream.readInt();
        this.memSize = stream.readLong();
        this.tvListRamCost = stream.readLong();
        this.totalPointsNum = stream.readLong();
        this.totalPointsNumThreshold = stream.readLong();
        this.maxPlanIndex = stream.readLong();
        this.minPlanIndex = stream.readLong();
        int memTableMapSize = stream.readInt();
        for (int i = 0; i < memTableMapSize; ++i) {
            IDeviceID deviceID = deviceIDFactory.getDeviceID(ReadWriteIOUtils.readString((InputStream)stream));
            boolean isAligned = ReadWriteIOUtils.readBool((InputStream)stream);
            IWritableMemChunkGroup memChunkGroup = isAligned ? AlignedWritableMemChunkGroup.deserialize(stream) : WritableMemChunkGroup.deserialize(stream);
            this.memTableMap.put(deviceID, memChunkGroup);
        }
    }

    @Override
    public Map<IDeviceID, Long> getMaxTime() {
        HashMap<IDeviceID, Long> latestTimeForEachDevice = new HashMap<IDeviceID, Long>();
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            long maxTime = entry.getValue().getMaxTime();
            if (maxTime == Long.MIN_VALUE) continue;
            latestTimeForEachDevice.put(entry.getKey(), maxTime);
        }
        return latestTimeForEachDevice;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getDataRegionId() {
        return this.dataRegionId;
    }

    @Override
    public void setDatabaseAndDataRegionId(String database, String dataRegionId) {
        this.database = database;
        this.dataRegionId = dataRegionId;
    }

    @Override
    public void markAsNotGeneratedByPipe() {
        this.isTotallyGeneratedByPipe.set(false);
    }

    @Override
    public boolean isTotallyGeneratedByPipe() {
        return this.isTotallyGeneratedByPipe.get();
    }

    public static class Factory {
        private Factory() {
        }

        public static IMemTable create(DataInputStream stream) throws IOException {
            AbstractMemTable memTable;
            boolean isSignal = ReadWriteIOUtils.readBool((InputStream)stream);
            if (isSignal) {
                memTable = new NotifyFlushMemTable();
            } else {
                PrimitiveMemTable primitiveMemTable = new PrimitiveMemTable();
                primitiveMemTable.deserialize(stream);
                memTable = primitiveMemTable;
            }
            return memTable;
        }
    }
}

