/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.node;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.common.request.IoTConsensusRequest;
import org.apache.iotdb.consensus.iot.log.ConsensusReqReader;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.service.metrics.WritingMetrics;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushStatus;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALBuffer;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryType;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALInfoEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALSignalEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.Checkpoint;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.CheckpointManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.CheckpointType;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.MemTablePinException;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALByteBufReader;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.IWALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALFileStatus;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALFileUtils;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALFlushListener;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.utils.TsFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALNode
implements IWALNode {
    private static final Logger logger = LoggerFactory.getLogger(WALNode.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    public static final long DEFAULT_SAFELY_DELETED_SEARCH_INDEX = Long.MAX_VALUE;
    private static final long WAIT_FOR_NEXT_WAL_ENTRY_TIMEOUT_IN_SEC = 30L;
    private static final WritingMetrics WRITING_METRICS = WritingMetrics.getInstance();
    private final String identifier;
    private final File logDirectory;
    private final WALBuffer buffer;
    private final CheckpointManager checkpointManager;
    private final Map<Long, Integer> memTableSnapshotCount = new ConcurrentHashMap<Long, Integer>();
    private volatile long safelyDeletedSearchIndex = Long.MAX_VALUE;

    public WALNode(String identifier, String logDirectory) throws FileNotFoundException {
        this(identifier, logDirectory, 0L, 0L);
    }

    public WALNode(String identifier, String logDirectory, long startFileVersion, long startSearchIndex) throws FileNotFoundException {
        this.identifier = identifier;
        this.logDirectory = SystemFileFactory.INSTANCE.getFile(logDirectory);
        if (!this.logDirectory.exists() && this.logDirectory.mkdirs()) {
            logger.info("create folder {} for wal node-{}.", (Object)logDirectory, (Object)identifier);
        }
        this.checkpointManager = new CheckpointManager(identifier, logDirectory);
        this.buffer = new WALBuffer(identifier, logDirectory, this.checkpointManager, startFileVersion, startSearchIndex);
    }

    @Override
    public WALFlushListener log(long memTableId, InsertRowNode insertRowNode) {
        WALInfoEntry walEntry = new WALInfoEntry(memTableId, insertRowNode);
        return this.log(walEntry);
    }

    @Override
    public WALFlushListener log(long memTableId, InsertRowsNode insertRowsNode) {
        WALInfoEntry walEntry = new WALInfoEntry(memTableId, insertRowsNode);
        return this.log(walEntry);
    }

    @Override
    public WALFlushListener log(long memTableId, InsertTabletNode insertTabletNode, int start, int end) {
        WALInfoEntry walEntry = new WALInfoEntry(memTableId, insertTabletNode, start, end);
        return this.log(walEntry);
    }

    @Override
    public WALFlushListener log(long memTableId, DeleteDataNode deleteDataNode) {
        WALInfoEntry walEntry = new WALInfoEntry(memTableId, deleteDataNode);
        return this.log(walEntry);
    }

    private WALFlushListener log(WALEntry walEntry) {
        this.buffer.write(walEntry);
        walEntry.getWalFlushListener().getWalEntryHandler().setWalNode(this, walEntry.getMemTableId());
        return walEntry.getWalFlushListener();
    }

    @Override
    public void onMemTableFlushStarted(IMemTable memTable) {
    }

    @Override
    public void onMemTableFlushed(IMemTable memTable) {
        if (memTable.isSignalMemTable()) {
            return;
        }
        MemTableInfo memTableInfo = new MemTableInfo(memTable, null, -1L);
        Checkpoint checkpoint = new Checkpoint(CheckpointType.FLUSH_MEMORY_TABLE, Collections.singletonList(memTableInfo));
        this.buffer.write(new WALInfoEntry(memTable.getMemTableId(), checkpoint));
        this.memTableSnapshotCount.remove(memTable.getMemTableId());
    }

    @Override
    public void onMemTableCreated(IMemTable memTable, String targetTsFile) {
        if (memTable.isSignalMemTable()) {
            return;
        }
        long firstFileVersionId = this.buffer.getCurrentWALFileVersion();
        MemTableInfo memTableInfo = new MemTableInfo(memTable, targetTsFile, firstFileVersionId);
        this.checkpointManager.makeCreateMemTableCPInMemory(memTableInfo);
        Checkpoint checkpoint = new Checkpoint(CheckpointType.CREATE_MEMORY_TABLE, Collections.singletonList(memTableInfo));
        this.buffer.write(new WALInfoEntry(memTable.getMemTableId(), checkpoint));
    }

    public void pinMemTable(long memTableId) throws MemTablePinException {
        this.checkpointManager.pinMemTable(memTableId);
    }

    public void unpinMemTable(long memTableId) throws MemTablePinException {
        this.checkpointManager.unpinMemTable(memTableId);
    }

    public void deleteOutdatedFiles() {
        try {
            new DeleteOutdatedFileTask().run();
        }
        catch (Exception e) {
            logger.error("Fail to delete wal node-{}'s outdated files.", (Object)this.identifier, (Object)e);
        }
    }

    public void setSafelyDeletedSearchIndex(long safelyDeletedSearchIndex) {
        this.safelyDeletedSearchIndex = safelyDeletedSearchIndex;
    }

    public ConsensusReqReader.ReqIterator getReqIterator(long startIndex) {
        return new PlanNodeIterator(startIndex);
    }

    public long getCurrentSearchIndex() {
        return this.buffer.getCurrentSearchIndex();
    }

    public long getCurrentWALFileVersion() {
        return this.buffer.getCurrentWALFileVersion();
    }

    public long getTotalSize() {
        return WALManager.getInstance().getTotalDiskUsage();
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public File getWALFile(long versionId) throws FileNotFoundException {
        return WALFileUtils.getWALFile(this.logDirectory, versionId);
    }

    public boolean isAllWALEntriesConsumed() {
        return this.buffer.isAllWALEntriesConsumed();
    }

    public void rollWALFile() {
        WALSignalEntry rollWALFileSignal = new WALSignalEntry(WALEntryType.ROLL_WAL_LOG_WRITER_SIGNAL, true);
        WALFlushListener walFlushListener = this.log(rollWALFileSignal);
        if (walFlushListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
            logger.error("Fail to trigger rolling wal node-{}'s wal file log writer.", (Object)this.identifier, (Object)walFlushListener.getCause());
        }
    }

    public long getDiskUsage() {
        return this.buffer.getDiskUsage();
    }

    public long getFileNum() {
        return this.buffer.getFileNum();
    }

    public int getRegionId(long memtableId) {
        return this.checkpointManager.getRegionId(memtableId);
    }

    long getCurrentLogVersion() {
        return this.buffer.getCurrentWALFileVersion();
    }

    CheckpointManager getCheckpointManager() {
        return this.checkpointManager;
    }

    public void setBufferSize(int size) {
        this.buffer.setBufferSize(size);
    }

    public WALBuffer getWALBuffer() {
        return this.buffer;
    }

    private class PlanNodeIterator
    implements ConsensusReqReader.ReqIterator {
        private long nextSearchIndex;
        private File[] filesToSearch = null;
        private int currentFileIndex = -1;
        private boolean needUpdatingFilesToSearch = true;
        private final LinkedList<IndexedConsensusRequest> insertNodes = new LinkedList();
        private ListIterator<IndexedConsensusRequest> itr = null;
        private long brokenFileId = -1L;

        public PlanNodeIterator(long startIndex) {
            this.nextSearchIndex = startIndex;
        }

        public boolean hasNext() {
            long targetIndex;
            List<Object> tmpNodes;
            block39: {
                if (this.itr != null && this.itr.hasNext()) {
                    return true;
                }
                this.insertNodes.clear();
                this.itr = null;
                if (this.filesToSearch == null || this.currentFileIndex >= this.filesToSearch.length - 1) {
                    this.needUpdatingFilesToSearch = true;
                }
                if (this.needUpdatingFilesToSearch) {
                    this.updateFilesToSearch();
                    if (this.needUpdatingFilesToSearch) {
                        logger.debug("update file to search failed, the next search index is {}", (Object)this.nextSearchIndex);
                        return false;
                    }
                }
                while (WALFileUtils.parseStatusCode(this.filesToSearch[this.currentFileIndex].getName()) == WALFileStatus.CONTAINS_NONE_SEARCH_INDEX) {
                    ++this.currentFileIndex;
                    if (this.currentFileIndex < this.filesToSearch.length - 1) continue;
                    this.needUpdatingFilesToSearch = true;
                    return false;
                }
                tmpNodes = new ArrayList<IoTConsensusRequest>();
                targetIndex = this.nextSearchIndex;
                try (WALByteBufReader walByteBufReader = new WALByteBufReader(this.filesToSearch[this.currentFileIndex]);){
                    while (walByteBufReader.hasNext()) {
                        ByteBuffer buffer = walByteBufReader.next();
                        WALEntryType type = WALEntryType.valueOf(buffer.get());
                        if (type.needSearch()) {
                            buffer.position(11);
                            long currentIndex = buffer.getLong();
                            buffer.clear();
                            if (currentIndex == targetIndex) {
                                tmpNodes.add(new IoTConsensusRequest(buffer));
                                continue;
                            }
                            if (!tmpNodes.isEmpty()) {
                                this.insertNodes.add(new IndexedConsensusRequest(targetIndex, tmpNodes));
                                tmpNodes = new ArrayList();
                            }
                            if (currentIndex <= targetIndex) continue;
                            tmpNodes.add(new IoTConsensusRequest(buffer));
                            targetIndex = currentIndex;
                            continue;
                        }
                        if (tmpNodes.isEmpty()) continue;
                        this.insertNodes.add(new IndexedConsensusRequest(targetIndex, tmpNodes));
                        ++targetIndex;
                        tmpNodes = new ArrayList();
                    }
                }
                catch (FileNotFoundException e) {
                    logger.debug("WAL file {} has been deleted, try to find next {} again.", (Object)WALNode.this.identifier, (Object)this.nextSearchIndex);
                    this.reset();
                    return this.hasNext();
                }
                catch (Exception e) {
                    this.brokenFileId = WALFileUtils.parseVersionId(this.filesToSearch[this.currentFileIndex].getName());
                    logger.error("Fail to read wal from wal file {}, skip this file.", (Object)this.filesToSearch[this.currentFileIndex], (Object)e);
                    if (!this.insertNodes.isEmpty() || !tmpNodes.isEmpty()) break block39;
                    ++this.currentFileIndex;
                    return this.hasNext();
                }
            }
            if (tmpNodes.isEmpty()) {
                ++this.currentFileIndex;
            } else {
                int fileIndex = this.currentFileIndex + 1;
                while (!tmpNodes.isEmpty() && fileIndex < this.filesToSearch.length - 1) {
                    if (WALFileUtils.parseStatusCode(this.filesToSearch[fileIndex].getName()) == WALFileStatus.CONTAINS_NONE_SEARCH_INDEX) {
                        this.insertNodes.add(new IndexedConsensusRequest(targetIndex, tmpNodes));
                        tmpNodes = Collections.emptyList();
                        break;
                    }
                    try (WALByteBufReader walByteBufReader = new WALByteBufReader(this.filesToSearch[fileIndex]);){
                        if (walByteBufReader.getFirstSearchIndex() != targetIndex) {
                            this.insertNodes.add(new IndexedConsensusRequest(targetIndex, tmpNodes));
                            tmpNodes = Collections.emptyList();
                            break;
                        }
                        while (walByteBufReader.hasNext()) {
                            ByteBuffer buffer = walByteBufReader.next();
                            WALEntryType type = WALEntryType.valueOf(buffer.get());
                            if (type.needSearch()) {
                                buffer.position(11);
                                long currentIndex = buffer.getLong();
                                buffer.clear();
                                if (currentIndex == targetIndex) {
                                    tmpNodes.add(new IoTConsensusRequest(buffer));
                                    continue;
                                }
                                this.insertNodes.add(new IndexedConsensusRequest(targetIndex, tmpNodes));
                                tmpNodes = Collections.emptyList();
                            } else {
                                this.insertNodes.add(new IndexedConsensusRequest(targetIndex, tmpNodes));
                                tmpNodes = Collections.emptyList();
                            }
                            break;
                        }
                    }
                    catch (FileNotFoundException e) {
                        logger.debug("WAL file {} has been deleted, try to find next {} again.", (Object)WALNode.this.identifier, (Object)this.nextSearchIndex);
                        this.reset();
                        return this.hasNext();
                    }
                    catch (Exception e) {
                        this.brokenFileId = WALFileUtils.parseVersionId(this.filesToSearch[fileIndex].getName());
                        logger.error("Fail to read wal from wal file {}, skip this file.", (Object)this.filesToSearch[fileIndex], (Object)e);
                    }
                    if (tmpNodes.isEmpty()) continue;
                    ++fileIndex;
                }
                if (tmpNodes.isEmpty()) {
                    this.currentFileIndex = fileIndex;
                } else {
                    this.needUpdatingFilesToSearch = true;
                }
            }
            if (this.currentFileIndex >= this.filesToSearch.length - 1) {
                this.needUpdatingFilesToSearch = true;
            }
            if (!this.insertNodes.isEmpty()) {
                this.itr = this.insertNodes.listIterator();
                return true;
            }
            return false;
        }

        public IndexedConsensusRequest next() {
            if (this.itr == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            IndexedConsensusRequest request = this.itr.next();
            this.nextSearchIndex = request.getSearchIndex() + 1L;
            return request;
        }

        public void waitForNextReady() throws InterruptedException {
            boolean walFileRolled = false;
            while (!this.hasNext()) {
                if (!walFileRolled) {
                    boolean timeout = !WALNode.this.buffer.waitForFlush(30L, TimeUnit.SECONDS);
                    if (!timeout) continue;
                    logger.info("timeout when waiting for next WAL entry ready, execute rollWALFile. Current search index in wal buffer is {}, and next target index is {}", (Object)WALNode.this.buffer.getCurrentSearchIndex(), (Object)this.nextSearchIndex);
                    WALNode.this.rollWALFile();
                    walFileRolled = true;
                    continue;
                }
                WALNode.this.buffer.waitForFlush();
            }
        }

        public void waitForNextReady(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            if (!this.hasNext()) {
                boolean timeout;
                boolean bl = timeout = !WALNode.this.buffer.waitForFlush(time, unit);
                if (timeout || !this.hasNext()) {
                    throw new TimeoutException();
                }
            }
        }

        public void skipTo(long targetIndex) {
            if (targetIndex < this.nextSearchIndex) {
                logger.warn("Skip from {} to {}, it's a dangerous operation because insert plan {} may have been lost.", new Object[]{this.nextSearchIndex, targetIndex, targetIndex});
            }
            if (this.itr != null && this.itr.hasNext() && this.insertNodes.get(this.itr.nextIndex()).getSearchIndex() <= targetIndex && targetIndex <= this.insertNodes.getLast().getSearchIndex()) {
                while (this.itr.hasNext()) {
                    IndexedConsensusRequest request = this.itr.next();
                    if (targetIndex != request.getSearchIndex()) continue;
                    this.itr.previous();
                    this.nextSearchIndex = targetIndex;
                    return;
                }
            }
            this.reset();
            this.nextSearchIndex = targetIndex;
        }

        private void reset() {
            this.insertNodes.clear();
            this.itr = null;
            this.filesToSearch = null;
            this.currentFileIndex = -1;
            this.brokenFileId = -1L;
            this.needUpdatingFilesToSearch = true;
        }

        private void updateFilesToSearch() {
            File[] filesToSearch = WALFileUtils.listAllWALFiles(WALNode.this.logDirectory);
            WALFileUtils.ascSortByVersionId(filesToSearch);
            int fileIndex = WALFileUtils.binarySearchFileBySearchIndex(filesToSearch, this.nextSearchIndex);
            logger.debug("searchIndex: {}, result: {}, files: {}, ", new Object[]{this.nextSearchIndex, fileIndex, filesToSearch});
            if (fileIndex == -1) {
                fileIndex = 0;
            }
            while (fileIndex < filesToSearch.length - 1 && WALFileUtils.parseVersionId(filesToSearch[fileIndex].getName()) <= this.brokenFileId) {
                ++fileIndex;
            }
            if (filesToSearch != null && fileIndex >= 0 && fileIndex < filesToSearch.length - 1) {
                this.filesToSearch = filesToSearch;
                this.currentFileIndex = fileIndex;
                this.needUpdatingFilesToSearch = false;
            } else {
                this.filesToSearch = null;
                this.currentFileIndex = -1;
                this.needUpdatingFilesToSearch = true;
            }
        }
    }

    private class DeleteOutdatedFileTask
    implements Runnable {
        private File[] sortedWalFilesExcludingLast;
        private List<MemTableInfo> activeOrPinnedMemTables;
        private static final int MAX_RECURSION_TIME = 5;
        private double effectiveInfoRatio = 1.0;
        private List<Long> pinnedMemTableIds;
        private int fileIndexAfterFilterSafelyDeleteIndex = Integer.MAX_VALUE;
        private List<Long> successfullyDeleted;
        private long deleteFileSize;
        private int recursionTime = 0;

        private boolean initAndCheckIfNeedContinue() {
            this.rollWalFileIfHaveNoActiveMemTable();
            File[] allWalFilesOfOneNode = WALFileUtils.listAllWALFiles(WALNode.this.logDirectory);
            if (allWalFilesOfOneNode == null || allWalFilesOfOneNode.length <= 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("wal node-{}:no wal file or wal file number less than or equal to one was found", (Object)WALNode.this.identifier);
                }
                return false;
            }
            WALFileUtils.ascSortByVersionId(allWalFilesOfOneNode);
            this.sortedWalFilesExcludingLast = Arrays.copyOfRange(allWalFilesOfOneNode, 0, allWalFilesOfOneNode.length - 1);
            this.activeOrPinnedMemTables = WALNode.this.checkpointManager.activeOrPinnedMemTables();
            this.pinnedMemTableIds = this.initPinnedMemTableIds();
            this.fileIndexAfterFilterSafelyDeleteIndex = this.initFileIndexAfterFilterSafelyDeleteIndex();
            this.successfullyDeleted = new ArrayList<Long>();
            this.deleteFileSize = 0L;
            return true;
        }

        public void rollWalFileIfHaveNoActiveMemTable() {
            long firstVersionId = WALNode.this.checkpointManager.getFirstValidWALVersionId();
            if (firstVersionId == Long.MIN_VALUE && WALNode.this.buffer.getCurrentWALFileSize() > 0L) {
                WALNode.this.rollWALFile();
            }
        }

        private List<Long> initPinnedMemTableIds() {
            List<MemTableInfo> memTableInfos = WALNode.this.checkpointManager.activeOrPinnedMemTables();
            if (memTableInfos.isEmpty()) {
                return new ArrayList<Long>();
            }
            ArrayList<Long> pinnedIds = new ArrayList<Long>();
            for (MemTableInfo memTableInfo : memTableInfos) {
                if (!memTableInfo.isFlushed() || !memTableInfo.isPinned()) continue;
                pinnedIds.add(memTableInfo.getMemTableId());
            }
            return pinnedIds;
        }

        @Override
        public void run() {
            while (this.recursionTime < 5 && this.initAndCheckIfNeedContinue()) {
                this.deleteOutdatedFilesAndUpdateMetric();
                this.summarizeExecuteResult();
                this.updateEffectiveInfoRationAndUpdateMetric();
                if (this.trySnapshotOrFlushMemTable() && WALNode.this.safelyDeletedSearchIndex != Long.MAX_VALUE) {
                    return;
                }
                ++this.recursionTime;
            }
        }

        private void updateEffectiveInfoRationAndUpdateMetric() {
            long totalCost;
            long costOfActiveMemTables = WALNode.this.checkpointManager.getTotalCostOfActiveMemTables();
            MemTableInfo oldestUnpinnedMemTableInfo = WALNode.this.checkpointManager.getOldestUnpinnedMemTableInfo();
            long avgFileSize = WALNode.this.getFileNum() != 0L ? WALNode.this.getDiskUsage() / WALNode.this.getFileNum() : config.getWalFileSizeThresholdInByte();
            long l = totalCost = oldestUnpinnedMemTableInfo == null ? costOfActiveMemTables : (WALNode.this.getCurrentWALFileVersion() - oldestUnpinnedMemTableInfo.getFirstFileVersionId()) * avgFileSize;
            if (costOfActiveMemTables == 0L || totalCost == 0L) {
                this.effectiveInfoRatio = 1.0;
                return;
            }
            this.effectiveInfoRatio = (double)costOfActiveMemTables / (double)totalCost;
            logger.debug("Effective information ratio is {}, active memTables cost is {}, total cost is {}", new Object[]{this.effectiveInfoRatio, costOfActiveMemTables, totalCost});
            WRITING_METRICS.recordWALNodeEffectiveInfoRatio(WALNode.this.identifier, this.effectiveInfoRatio);
        }

        private void summarizeExecuteResult() {
            if (!this.pinnedMemTableIds.isEmpty() || this.fileIndexAfterFilterSafelyDeleteIndex < this.sortedWalFilesExcludingLast.length) {
                if (logger.isDebugEnabled()) {
                    StringBuilder summary = new StringBuilder(String.format("wal node-%s delete outdated files summary:the range is: [%d,%d], delete successful is [%s], safely delete file index is: [%s].The following reasons influenced the result: %s", WALNode.this.identifier, WALFileUtils.parseVersionId(this.sortedWalFilesExcludingLast[0].getName()), WALFileUtils.parseVersionId(this.sortedWalFilesExcludingLast[this.sortedWalFilesExcludingLast.length - 1].getName()), StringUtils.join(this.successfullyDeleted, (String)","), this.fileIndexAfterFilterSafelyDeleteIndex, System.getProperty("line.separator")));
                    if (!this.pinnedMemTableIds.isEmpty()) {
                        summary.append("- MemTable has been flushed but pinned by PIPE, the MemTableId list is : ").append(StringUtils.join(this.pinnedMemTableIds, (String)",")).append(".").append(System.getProperty("line.separator"));
                    }
                    if (this.fileIndexAfterFilterSafelyDeleteIndex < this.sortedWalFilesExcludingLast.length) {
                        summary.append(String.format("- The data in the wal file was not consumed by the consensus group,current search index is %d, safely delete index is %d", WALNode.this.getCurrentSearchIndex(), WALNode.this.safelyDeletedSearchIndex));
                    }
                    String summaryLog = summary.toString();
                    logger.debug(summaryLog);
                }
            } else {
                logger.debug("Successfully delete {} outdated wal files for wal node-{}", (Object)this.successfullyDeleted.size(), (Object)WALNode.this.identifier);
            }
        }

        private void deleteOutdatedFilesAndUpdateMetric() {
            for (int fileArrIdx = 0; fileArrIdx < this.sortedWalFilesExcludingLast.length; ++fileArrIdx) {
                long versionId;
                File currentWal = this.sortedWalFilesExcludingLast[fileArrIdx];
                WALFileStatus walFileStatus = WALFileUtils.parseStatusCode(currentWal.getName());
                if (!this.canDeleteFile(fileArrIdx, walFileStatus, versionId = WALFileUtils.parseVersionId(currentWal.getName()))) continue;
                long fileSize = currentWal.length();
                if (currentWal.delete()) {
                    this.deleteFileSize += fileSize;
                    WALNode.this.buffer.removeMemTableIdsOfWal(versionId);
                    this.successfullyDeleted.add(versionId);
                    continue;
                }
                logger.info("Fail to delete outdated wal file {} of wal node-{}.", (Object)currentWal, (Object)WALNode.this.identifier);
            }
            WALNode.this.buffer.subtractDiskUsage(this.deleteFileSize);
            WALNode.this.buffer.subtractFileNum(this.successfullyDeleted.size());
        }

        private int initFileIndexAfterFilterSafelyDeleteIndex() {
            return WALNode.this.safelyDeletedSearchIndex == Long.MAX_VALUE ? this.sortedWalFilesExcludingLast.length : WALFileUtils.binarySearchFileBySearchIndex(this.sortedWalFilesExcludingLast, WALNode.this.safelyDeletedSearchIndex + 1L);
        }

        private boolean shouldSnapshotOrFlush() {
            return this.effectiveInfoRatio < config.getWalMinEffectiveInfoRatio() || WALManager.getInstance().shouldThrottle();
        }

        private boolean trySnapshotOrFlushMemTable() {
            DataRegion dataRegion;
            if (!this.shouldSnapshotOrFlush()) {
                return false;
            }
            MemTableInfo oldestMemTableInfo = WALNode.this.checkpointManager.getOldestUnpinnedMemTableInfo();
            if (oldestMemTableInfo == null) {
                return false;
            }
            if (oldestMemTableInfo.isPinned()) {
                logger.warn("Pipe: Effective information ratio {} of wal node-{} is below wal min effective info ratio {}. But fail to delete memTable-{}'s wal files because they are pinned by the Pipe module. Pin count: {}.", new Object[]{this.effectiveInfoRatio, WALNode.this.identifier, config.getWalMinEffectiveInfoRatio(), oldestMemTableInfo.getMemTableId(), oldestMemTableInfo.getPinCount()});
                return false;
            }
            IMemTable oldestMemTable = oldestMemTableInfo.getMemTable();
            if (oldestMemTable == null) {
                return false;
            }
            File oldestTsFile = FSFactoryProducer.getFSFactory().getFile(oldestMemTableInfo.getTsFilePath());
            try {
                dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(TsFileUtils.getDataRegionId((File)oldestTsFile)));
            }
            catch (Exception e) {
                logger.error("Fail to get data region processor for {}", (Object)oldestTsFile, (Object)e);
                return false;
            }
            if (dataRegion == null) {
                return false;
            }
            int snapshotCount = WALNode.this.memTableSnapshotCount.getOrDefault(oldestMemTable.getMemTableId(), 0);
            long oldestMemTableTVListsRamCost = oldestMemTable.getTVListsRamCost();
            if (TsFileUtils.getTimePartition((File)new File(oldestMemTableInfo.getTsFilePath())) < dataRegion.getLatestTimePartition() || snapshotCount >= config.getMaxWalMemTableSnapshotNum() || oldestMemTableTVListsRamCost > config.getWalMemTableSnapshotThreshold()) {
                this.flushMemTable(dataRegion, oldestTsFile, oldestMemTable);
                WRITING_METRICS.recordWalFlushMemTableCount(dataRegion.getDataRegionId(), 1);
                WRITING_METRICS.recordMemTableRamWhenCauseFlush(WALNode.this.identifier, oldestMemTableTVListsRamCost);
            } else {
                this.snapshotMemTable(dataRegion, oldestTsFile, oldestMemTableInfo);
            }
            return true;
        }

        private void flushMemTable(DataRegion dataRegion, File tsFile, IMemTable memTable) {
            boolean submitted = true;
            if (memTable.getFlushStatus() == FlushStatus.WORKING) {
                submitted = dataRegion.submitAFlushTask(TsFileUtils.getTimePartition((File)tsFile), TsFileUtils.isSequence((File)tsFile), memTable);
                logger.info("WAL node-{} flushes memTable-{} to TsFile {} because Effective information ratio {} is below wal min effective info ratio {}, memTable size is {}.", new Object[]{WALNode.this.identifier, memTable.getMemTableId(), tsFile, String.format("%.4f", this.effectiveInfoRatio), config.getWalMinEffectiveInfoRatio(), memTable.getTVListsRamCost()});
            }
            if (submitted || memTable.getFlushStatus() == FlushStatus.FLUSHING) {
                long sleepTime = 0L;
                while (memTable.getFlushStatus() != FlushStatus.FLUSHED) {
                    try {
                        Thread.sleep(1000L);
                        if ((sleepTime += 1000L) <= 10000L) continue;
                        logger.warn("Waiting too long for memTable flush to be done.");
                        break;
                    }
                    catch (InterruptedException e) {
                        logger.warn("Interrupted when waiting for memTable flush to be done.");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void snapshotMemTable(DataRegion dataRegion, File tsFile, MemTableInfo memTableInfo) {
            IMemTable memTable = memTableInfo.getMemTable();
            dataRegion.writeLock("CheckpointManager$DeleteOutdatedFileTask.snapshotOrFlushOldestMemTable");
            MemTableInfo memTableInfo2 = memTableInfo;
            synchronized (memTableInfo2) {
                if (memTable == null || memTable.getFlushStatus() != FlushStatus.WORKING) {
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 11] lbl7 : MonitorExitStatement: MONITOREXIT : var5_5
                    dataRegion.writeUnlock();
                    return;
                }
                WALNode.this.memTableSnapshotCount.compute(memTable.getMemTableId(), (k, v) -> v == null ? 1 : v + 1);
            }
            {
                WALSignalEntry rollWALFileSignal = new WALSignalEntry(WALEntryType.ROLL_WAL_LOG_WRITER_SIGNAL, true);
                WALFlushListener fileRolledListener = WALNode.this.log(rollWALFileSignal);
                if (fileRolledListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
                    logger.error("Fail to roll wal log writer.", (Throwable)fileRolledListener.getCause());
                    // MONITOREXIT @DISABLED, blocks:[6, 10] lbl16 : MonitorExitStatement: MONITOREXIT : var5_5
                    dataRegion.writeUnlock();
                    return;
                }
                memTableInfo.setFirstFileVersionId(WALNode.this.buffer.getCurrentWALFileVersion());
                WALInfoEntry walEntry = new WALInfoEntry(memTable.getMemTableId(), memTable, true);
                WALFlushListener flushListener = WALNode.this.log(walEntry);
                if (flushListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
                    logger.error("Fail to snapshot memTable of {}", (Object)tsFile, (Object)flushListener.getCause());
                    // MONITOREXIT @DISABLED, blocks:[6, 9] lbl24 : MonitorExitStatement: MONITOREXIT : var5_5
                    dataRegion.writeUnlock();
                    return;
                }
                try {
                    logger.info("WAL node-{} snapshots memTable-{} to wal files because Effective information ratio {} is below wal min effective info ratio {}, memTable size is {}.", new Object[]{WALNode.this.identifier, memTable.getMemTableId(), String.format("%.4f", this.effectiveInfoRatio), config.getWalMinEffectiveInfoRatio(), memTable.getTVListsRamCost()});
                    WRITING_METRICS.recordMemTableRamWhenCauseSnapshot(WALNode.this.identifier, memTable.getTVListsRamCost());
                    return;
                }
                finally {
                    dataRegion.writeUnlock();
                }
            }
        }

        public boolean isContainsActiveOrPinnedMemTable(Long versionId) {
            Set<Long> memTableIdsOfCurrentWal = WALNode.this.buffer.getMemTableIds(versionId);
            if (memTableIdsOfCurrentWal == null) {
                return true;
            }
            return !Collections.disjoint(this.activeOrPinnedMemTables.stream().map(MemTableInfo::getMemTableId).collect(Collectors.toSet()), memTableIdsOfCurrentWal);
        }

        private boolean canDeleteFile(long fileArrIdx, WALFileStatus walFileStatus, long versionId) {
            return (fileArrIdx < (long)this.fileIndexAfterFilterSafelyDeleteIndex || walFileStatus == WALFileStatus.CONTAINS_NONE_SEARCH_INDEX) && !this.isContainsActiveOrPinnedMemTable(versionId);
        }
    }
}

