/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.recover;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AbstractMemTable;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryType;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALByteBufReader;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALMetaData;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALReader;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.CheckpointRecoverUtils;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.WALRecoverManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.WALRecoverWriter;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.file.UnsealedTsFileRecoverPerformer;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.CheckpointFileUtils;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALFileStatus;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALNodeRecoverTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WALNodeRecoverTask.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final WALRecoverManager walRecoverManger = WALRecoverManager.getInstance();
    private final File logDirectory;
    private final CountDownLatch allNodesRecoveredLatch;
    private long firstValidVersionId = Long.MAX_VALUE;
    private Map<Long, MemTableInfo> memTableId2Info;
    private Map<Long, UnsealedTsFileRecoverPerformer> memTableId2RecoverPerformer;

    public WALNodeRecoverTask(File logDirectory, CountDownLatch allNodesRecoveredLatch) {
        this.logDirectory = logDirectory;
        this.allNodesRecoveredLatch = allNodesRecoveredLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Start recovering WAL node in the directory {}", (Object)this.logDirectory);
        long[] indexInfo = this.recoverLastFile();
        long lastVersionId = indexInfo[0];
        long lastSearchIndex = indexInfo[1];
        try {
            this.recoverInfoFromCheckpoints();
            this.recoverTsFiles();
        }
        catch (Exception e) {
            for (UnsealedTsFileRecoverPerformer recoverPerformer : this.memTableId2RecoverPerformer.values()) {
                recoverPerformer.getRecoverListener().fail(e);
            }
        }
        finally {
            for (UnsealedTsFileRecoverPerformer unsealedTsFileRecoverPerformer : this.memTableId2RecoverPerformer.values()) {
                try {
                    if (unsealedTsFileRecoverPerformer.canWrite()) continue;
                    unsealedTsFileRecoverPerformer.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            if (!config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus")) {
                FileUtils.deleteFileOrDirectory((File)this.logDirectory);
                logger.info("Successfully recover WAL node in the directory {}, so delete these wal files.", (Object)this.logDirectory);
            } else {
                File[] checkpointFiles;
                for (File checkpointFile : checkpointFiles = CheckpointFileUtils.listAllCheckpointFiles(this.logDirectory)) {
                    try {
                        Files.delete(checkpointFile.toPath());
                    }
                    catch (IOException e) {
                        logger.error("error when delete checkpoint file. {}", (Object)checkpointFile, (Object)e);
                    }
                }
                WALManager.getInstance().registerWALNode(this.logDirectory.getName(), this.logDirectory.getAbsolutePath(), lastVersionId + 1L, lastSearchIndex);
                logger.info("Successfully recover WAL node in the directory {}, add this node to WALManger.", (Object)this.logDirectory);
            }
        }
        finally {
            this.allNodesRecoveredLatch.countDown();
        }
    }

    private long[] recoverLastFile() {
        String targetName;
        File[] walFiles = WALFileUtils.listAllWALFiles(this.logDirectory);
        if (walFiles == null || walFiles.length == 0) {
            return new long[]{0L, 0L};
        }
        WALFileUtils.ascSortByVersionId(walFiles);
        File lastWALFile = walFiles[walFiles.length - 1];
        long lastVersionId = WALFileUtils.parseVersionId(lastWALFile.getName());
        long lastSearchIndex = WALFileUtils.parseStartSearchIndex(lastWALFile.getName());
        WALMetaData metaData = new WALMetaData(lastSearchIndex, new ArrayList<Integer>(), new HashSet<Long>());
        WALFileStatus fileStatus = WALFileStatus.CONTAINS_NONE_SEARCH_INDEX;
        try (WALReader walReader = new WALReader(lastWALFile, true);){
            while (walReader.hasNext()) {
                WALEntry walEntry = walReader.next();
                long searchIndex = -1L;
                if (walEntry.getType().needSearch()) {
                    if (walEntry.getType() != WALEntryType.DELETE_DATA_NODE) {
                        InsertNode insertNode = (InsertNode)((Object)walEntry.getValue());
                        if (insertNode.getSearchIndex() != -1L) {
                            searchIndex = insertNode.getSearchIndex();
                            lastSearchIndex = Math.max(lastSearchIndex, insertNode.getSearchIndex());
                            fileStatus = WALFileStatus.CONTAINS_SEARCH_INDEX;
                        }
                    } else {
                        DeleteDataNode deleteNode = (DeleteDataNode)walEntry.getValue();
                        if (deleteNode.getSearchIndex() != -1L) {
                            searchIndex = deleteNode.getSearchIndex();
                            lastSearchIndex = Math.max(lastSearchIndex, deleteNode.getSearchIndex());
                            fileStatus = WALFileStatus.CONTAINS_SEARCH_INDEX;
                        }
                    }
                }
                metaData.add(walEntry.serializedSize(), searchIndex, walEntry.getMemTableId());
            }
        }
        catch (Exception e) {
            logger.warn("Fail to read wal logs from {}, skip them", (Object)lastWALFile, (Object)e);
        }
        WALRecoverWriter walRecoverWriter = new WALRecoverWriter(lastWALFile);
        try {
            walRecoverWriter.recover(metaData);
        }
        catch (IOException e) {
            logger.error("Fail to recover metadata of wal file {}", (Object)lastWALFile);
        }
        if (WALFileUtils.parseStatusCode(lastWALFile.getName()) != fileStatus && !lastWALFile.renameTo(SystemFileFactory.INSTANCE.getFile(this.logDirectory, targetName = WALFileUtils.getLogFileName(WALFileUtils.parseVersionId(lastWALFile.getName()), WALFileUtils.parseStartSearchIndex(lastWALFile.getName()), fileStatus)))) {
            logger.error("Fail to rename file {} to {}", (Object)lastWALFile, (Object)targetName);
        }
        return new long[]{lastVersionId, lastSearchIndex};
    }

    private void recoverInfoFromCheckpoints() {
        CheckpointRecoverUtils.CheckpointInfo info = CheckpointRecoverUtils.recoverMemTableInfo(this.logDirectory);
        this.memTableId2Info = info.getMemTableId2Info();
        this.memTableId2RecoverPerformer = new HashMap<Long, UnsealedTsFileRecoverPerformer>();
        long maxMemTableId = info.getMaxMemTableId();
        AtomicLong memTableIdCounter = AbstractMemTable.memTableIdCounter;
        long oldVal = memTableIdCounter.get();
        while (maxMemTableId > oldVal) {
            if (memTableIdCounter.compareAndSet(oldVal, maxMemTableId)) continue;
            oldVal = memTableIdCounter.get();
        }
        for (MemTableInfo memTableInfo : this.memTableId2Info.values()) {
            this.firstValidVersionId = Math.min(this.firstValidVersionId, memTableInfo.getFirstFileVersionId());
            UnsealedTsFileRecoverPerformer recoverPerformer = walRecoverManger.removeRecoverPerformer(new File(memTableInfo.getTsFilePath()));
            if (recoverPerformer == null) continue;
            this.memTableId2RecoverPerformer.put(memTableInfo.getMemTableId(), recoverPerformer);
        }
    }

    private void recoverTsFiles() {
        if (this.memTableId2RecoverPerformer.isEmpty()) {
            return;
        }
        for (UnsealedTsFileRecoverPerformer recoverPerformer : this.memTableId2RecoverPerformer.values()) {
            try {
                recoverPerformer.startRecovery();
            }
            catch (Exception e) {
                recoverPerformer.getRecoverListener().fail(e);
            }
        }
        File[] walFiles = this.logDirectory.listFiles((dir, name) -> WALFileUtils.walFilenameFilter(dir, name) && WALFileUtils.parseVersionId(name) >= this.firstValidVersionId);
        if (walFiles == null) {
            this.endRecovery();
            return;
        }
        WALFileUtils.ascSortByVersionId(walFiles);
        for (int i = 0; i < walFiles.length; ++i) {
            File walFile = walFiles[i];
            try (WALByteBufReader reader = new WALByteBufReader(walFile);){
                if (Collections.disjoint(this.memTableId2Info.keySet(), reader.getMetaData().getMemTablesId())) continue;
                while (reader.hasNext()) {
                    ByteBuffer buffer = reader.next();
                    buffer.position(1);
                    long memTableId = buffer.getLong();
                    if (!this.memTableId2Info.containsKey(memTableId)) continue;
                    buffer.clear();
                    WALEntry walEntry = WALEntry.deserialize(new DataInputStream(new ByteArrayInputStream(buffer.array())));
                    UnsealedTsFileRecoverPerformer recoverPerformer = this.memTableId2RecoverPerformer.get(walEntry.getMemTableId());
                    if (recoverPerformer != null) {
                        recoverPerformer.redoLog(walEntry);
                        continue;
                    }
                    logger.debug("Fail to find TsFile recover performer for wal entry in TsFile {}", (Object)walFile);
                }
                continue;
            }
            catch (Exception e) {
                logger.warn("Fail to read wal logs from {}, skip them", (Object)walFile, (Object)e);
            }
        }
        this.endRecovery();
    }

    private void endRecovery() {
        for (UnsealedTsFileRecoverPerformer recoverPerformer : this.memTableId2RecoverPerformer.values()) {
            try {
                recoverPerformer.endRecovery();
                recoverPerformer.getRecoverListener().succeed();
            }
            catch (Exception e) {
                recoverPerformer.getRecoverListener().fail(e);
            }
        }
    }
}

