/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.disk;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.rescon.disk.FolderManager;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategyType;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.MaxDiskUsableSpaceFirstStrategy;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.MinFolderOccupiedSpaceFirstStrategy;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.RandomOnDiskUsableSpaceStrategy;
import org.apache.iotdb.metrics.utils.FileStoreUtils;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.apache.iotdb.tsfile.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierManager {
    private static final Logger logger = LoggerFactory.getLogger(TierManager.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private DirectoryStrategyType directoryStrategyType = DirectoryStrategyType.SEQUENCE_STRATEGY;
    private final List<FolderManager> seqTiers = new ArrayList<FolderManager>();
    private final List<FolderManager> unSeqTiers = new ArrayList<FolderManager>();
    private final Map<String, Integer> seqDir2TierLevel = new HashMap<String, Integer>();
    private final Map<String, Integer> unSeqDir2TierLevel = new HashMap<String, Integer>();
    private long[] tierDiskTotalSpace;

    private TierManager() {
        this.initFolders();
    }

    public synchronized void initFolders() {
        try {
            String strategyName = Class.forName(config.getMultiDirStrategyClassName()).getSimpleName();
            if (strategyName.equals(MaxDiskUsableSpaceFirstStrategy.class.getSimpleName())) {
                this.directoryStrategyType = DirectoryStrategyType.MAX_DISK_USABLE_SPACE_FIRST_STRATEGY;
            } else if (strategyName.equals(MinFolderOccupiedSpaceFirstStrategy.class.getSimpleName())) {
                this.directoryStrategyType = DirectoryStrategyType.MIN_FOLDER_OCCUPIED_SPACE_FIRST_STRATEGY;
            } else if (strategyName.equals(RandomOnDiskUsableSpaceStrategy.class.getSimpleName())) {
                this.directoryStrategyType = DirectoryStrategyType.RANDOM_ON_DISK_USABLE_SPACE_STRATEGY;
            }
        }
        catch (Exception e) {
            logger.error("Can't find strategy {} for mult-directories.", (Object)config.getMultiDirStrategyClassName(), (Object)e);
        }
        config.updatePath();
        String[][] tierDirs = config.getTierDataDirs();
        for (int i = 0; i < tierDirs.length; ++i) {
            block12: for (int j = 0; j < tierDirs[i].length; ++j) {
                switch (FSUtils.getFSType((String)tierDirs[i][j])) {
                    case LOCAL: {
                        try {
                            tierDirs[i][j] = new File(tierDirs[i][j]).getCanonicalPath();
                        }
                        catch (IOException e) {
                            logger.error("Fail to get canonical path of data dir {}", (Object)tierDirs[i][j], (Object)e);
                        }
                        continue block12;
                    }
                }
            }
        }
        for (int tierLevel = 0; tierLevel < tierDirs.length; ++tierLevel) {
            List<String> seqDirs = Arrays.stream(tierDirs[tierLevel]).filter(Objects::nonNull).map(v -> FSFactoryProducer.getFSFactory().getFile(v, "sequence").getPath()).collect(Collectors.toList());
            this.mkDataDirs(seqDirs);
            try {
                this.seqTiers.add(new FolderManager(seqDirs, this.directoryStrategyType));
            }
            catch (DiskSpaceInsufficientException e) {
                logger.error("All disks of tier {} are full.", (Object)tierLevel, (Object)e);
            }
            for (String dir : seqDirs) {
                this.seqDir2TierLevel.put(dir, tierLevel);
            }
            List<String> unSeqDirs = Arrays.stream(tierDirs[tierLevel]).filter(Objects::nonNull).map(v -> FSFactoryProducer.getFSFactory().getFile(v, "unsequence").getPath()).collect(Collectors.toList());
            this.mkDataDirs(unSeqDirs);
            try {
                this.unSeqTiers.add(new FolderManager(unSeqDirs, this.directoryStrategyType));
            }
            catch (DiskSpaceInsufficientException e) {
                logger.error("All disks of tier {} are full.", (Object)tierLevel, (Object)e);
            }
            for (String dir : unSeqDirs) {
                this.unSeqDir2TierLevel.put(dir, tierLevel);
            }
        }
        this.tierDiskTotalSpace = this.getTierDiskSpace(DiskSpaceType.TOTAL);
    }

    public synchronized void resetFolders() {
        long startTime = System.currentTimeMillis();
        this.seqTiers.clear();
        this.unSeqTiers.clear();
        this.seqDir2TierLevel.clear();
        this.unSeqDir2TierLevel.clear();
        this.initFolders();
        long endTime = System.currentTimeMillis();
        logger.info("The folders is reset successfully, which takes {} ms.", (Object)(endTime - startTime));
    }

    private void mkDataDirs(List<String> folders) {
        for (String folder : folders) {
            File file = FSFactoryProducer.getFSFactory().getFile(folder);
            if (FSUtils.getFSType((File)file) == FSType.OBJECT_STORAGE) continue;
            if (file.mkdirs()) {
                logger.info("folder {} doesn't exist, create it", (Object)file.getPath());
                continue;
            }
            logger.info("create folder {} failed. Is the folder existed: {}", (Object)file.getPath(), (Object)file.exists());
        }
    }

    public String getNextFolderForTsFile(int tierLevel, boolean sequence) throws DiskSpaceInsufficientException {
        return sequence ? this.seqTiers.get(tierLevel).getNextFolder() : this.unSeqTiers.get(tierLevel).getNextFolder();
    }

    public List<String> getAllFilesFolders() {
        ArrayList<String> folders = new ArrayList<String>(this.seqDir2TierLevel.keySet());
        folders.addAll(this.unSeqDir2TierLevel.keySet());
        return folders;
    }

    public List<String> getAllLocalFilesFolders() {
        return this.getAllFilesFolders().stream().filter(FSUtils::isLocal).collect(Collectors.toList());
    }

    public List<String> getAllSequenceFileFolders() {
        return new ArrayList<String>(this.seqDir2TierLevel.keySet());
    }

    public List<String> getAllLocalSequenceFileFolders() {
        return this.seqDir2TierLevel.keySet().stream().filter(FSUtils::isLocal).collect(Collectors.toList());
    }

    public List<String> getAllUnSequenceFileFolders() {
        return new ArrayList<String>(this.unSeqDir2TierLevel.keySet());
    }

    public List<String> getAllLocalUnSequenceFileFolders() {
        return this.unSeqDir2TierLevel.keySet().stream().filter(FSUtils::isLocal).collect(Collectors.toList());
    }

    public int getTiersNum() {
        return this.seqTiers.size();
    }

    public int getFileTierLevel(File file) {
        Path filePath;
        if (!file.exists()) {
            return this.getTiersNum() - 1;
        }
        try {
            filePath = file.getCanonicalFile().toPath();
        }
        catch (IOException e) {
            logger.error("Fail to get canonical path of data dir {}", (Object)file, (Object)e);
            filePath = file.toPath();
        }
        for (Map.Entry<String, Integer> entry : this.seqDir2TierLevel.entrySet()) {
            if (!filePath.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        for (Map.Entry<String, Integer> entry : this.unSeqDir2TierLevel.entrySet()) {
            if (!filePath.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return 0;
    }

    public long[] getTierDiskTotalSpace() {
        return Arrays.copyOf(this.tierDiskTotalSpace, this.tierDiskTotalSpace.length);
    }

    public long[] getTierDiskUsableSpace() {
        return this.getTierDiskSpace(DiskSpaceType.USABLE);
    }

    private long[] getTierDiskSpace(DiskSpaceType type) {
        String[][] tierDirs = config.getTierDataDirs();
        long[] tierDiskSpace = new long[tierDirs.length];
        block6: for (int tierLevel = 0; tierLevel < tierDirs.length; ++tierLevel) {
            HashSet<FileStore> tierFileStores = new HashSet<FileStore>();
            for (String dir : tierDirs[tierLevel]) {
                if (!FSUtils.isLocal((String)dir)) {
                    tierDiskSpace[tierLevel] = Long.MAX_VALUE;
                    continue block6;
                }
                FileStore fileStore = FileStoreUtils.getFileStore((String)dir);
                if (fileStore == null || tierFileStores.contains(fileStore)) continue;
                tierFileStores.add(fileStore);
                try {
                    switch (type) {
                        case TOTAL: {
                            int n = tierLevel;
                            tierDiskSpace[n] = tierDiskSpace[n] + fileStore.getTotalSpace();
                            break;
                        }
                        case USABLE: {
                            int n = tierLevel;
                            tierDiskSpace[n] = tierDiskSpace[n] + fileStore.getUsableSpace();
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    logger.error("Failed to statistic the size of {}, because", (Object)fileStore, (Object)e);
                }
            }
        }
        return tierDiskSpace;
    }

    public static TierManager getInstance() {
        return TierManagerHolder.INSTANCE;
    }

    private static class TierManagerHolder {
        private static final TierManager INSTANCE = new TierManager();

        private TierManagerHolder() {
        }
    }

    private static enum DiskSpaceType {
        TOTAL,
        USABLE;

    }
}

