/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.agent;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMetaKeeper;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.mpp.rpc.thrift.TPushConsumerGroupMetaRespExceptionMessage;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionConsumerAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionConsumerAgent.class);
    private final ConsumerGroupMetaKeeper consumerGroupMetaKeeper = new ConsumerGroupMetaKeeper();

    protected void acquireReadLock() {
        this.consumerGroupMetaKeeper.acquireReadLock();
    }

    protected void releaseReadLock() {
        this.consumerGroupMetaKeeper.releaseReadLock();
    }

    protected void acquireWriteLock() {
        this.consumerGroupMetaKeeper.acquireWriteLock();
    }

    protected void releaseWriteLock() {
        this.consumerGroupMetaKeeper.releaseWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TPushConsumerGroupMetaRespExceptionMessage handleSingleConsumerGroupMetaChanges(ConsumerGroupMeta consumerGroupMetaFromCoordinator) {
        this.acquireWriteLock();
        try {
            if (consumerGroupMetaFromCoordinator.isEmpty()) {
                this.handleDropConsumerGroupInternal(consumerGroupMetaFromCoordinator.getConsumerGroupId());
            } else {
                this.handleSingleConsumerGroupMetaChangesInternal(consumerGroupMetaFromCoordinator);
            }
            TPushConsumerGroupMetaRespExceptionMessage tPushConsumerGroupMetaRespExceptionMessage = null;
            return tPushConsumerGroupMetaRespExceptionMessage;
        }
        catch (Exception e) {
            String consumerGroupId = consumerGroupMetaFromCoordinator.getConsumerGroupId();
            String exceptionMessage = String.format("Subscription: Failed to handle single consumer group meta changes for consumer group %s, because %s", consumerGroupId, e.getMessage());
            LOGGER.warn(exceptionMessage);
            TPushConsumerGroupMetaRespExceptionMessage tPushConsumerGroupMetaRespExceptionMessage = new TPushConsumerGroupMetaRespExceptionMessage(consumerGroupId, exceptionMessage, System.currentTimeMillis());
            return tPushConsumerGroupMetaRespExceptionMessage;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void handleSingleConsumerGroupMetaChangesInternal(ConsumerGroupMeta metaFromCoordinator) {
        String consumerGroupId = metaFromCoordinator.getConsumerGroupId();
        ConsumerGroupMeta metaInAgent = this.consumerGroupMetaKeeper.getConsumerGroupMeta(consumerGroupId);
        if (Objects.isNull(metaInAgent) || metaInAgent.getCreationTime() != metaFromCoordinator.getCreationTime()) {
            if (SubscriptionAgent.broker().isBrokerExist(consumerGroupId)) {
                LOGGER.warn("Subscription: broker bound to consumer group [{}] has already existed when the corresponding consumer group meta does not exist on local agent, drop it", (Object)consumerGroupId);
                if (!SubscriptionAgent.broker().dropBroker(consumerGroupId)) {
                    String exceptionMessage = String.format("Failed to drop stale broker bound to consumer group [%s]", consumerGroupId);
                    LOGGER.warn(exceptionMessage);
                    throw new SubscriptionException(exceptionMessage);
                }
            }
            this.consumerGroupMetaKeeper.removeConsumerGroupMeta(consumerGroupId);
            this.consumerGroupMetaKeeper.addConsumerGroupMeta(consumerGroupId, metaFromCoordinator);
            SubscriptionAgent.broker().createBroker(consumerGroupId);
            return;
        }
        this.consumerGroupMetaKeeper.removeConsumerGroupMeta(consumerGroupId);
        this.consumerGroupMetaKeeper.addConsumerGroupMeta(consumerGroupId, metaFromCoordinator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TPushConsumerGroupMetaRespExceptionMessage handleConsumerGroupMetaChanges(List<ConsumerGroupMeta> consumerGroupMetasFromCoordinator) {
        this.acquireWriteLock();
        try {
            Iterator<ConsumerGroupMeta> iterator = consumerGroupMetasFromCoordinator.iterator();
            if (iterator.hasNext()) {
                ConsumerGroupMeta consumerGroupMetaFromCoordinator = iterator.next();
                try {
                    this.handleSingleConsumerGroupMetaChangesInternal(consumerGroupMetaFromCoordinator);
                    TPushConsumerGroupMetaRespExceptionMessage tPushConsumerGroupMetaRespExceptionMessage = null;
                    return tPushConsumerGroupMetaRespExceptionMessage;
                }
                catch (Exception e) {
                    String consumerGroupId = consumerGroupMetaFromCoordinator.getConsumerGroupId();
                    String exceptionMessage = String.format("Subscription: Failed to handle single consumer group meta changes for consumer group %s, because %s", consumerGroupId, e.getMessage());
                    LOGGER.warn(exceptionMessage);
                    TPushConsumerGroupMetaRespExceptionMessage tPushConsumerGroupMetaRespExceptionMessage = new TPushConsumerGroupMetaRespExceptionMessage(consumerGroupId, exceptionMessage, System.currentTimeMillis());
                    this.releaseWriteLock();
                    return tPushConsumerGroupMetaRespExceptionMessage;
                }
            }
            iterator = null;
            return iterator;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TPushConsumerGroupMetaRespExceptionMessage handleDropConsumerGroup(String consumerGroupId) {
        this.acquireWriteLock();
        try {
            this.handleDropConsumerGroupInternal(consumerGroupId);
            TPushConsumerGroupMetaRespExceptionMessage tPushConsumerGroupMetaRespExceptionMessage = null;
            return tPushConsumerGroupMetaRespExceptionMessage;
        }
        catch (Exception e) {
            String exceptionMessage = String.format("Subscription: Failed to drop consumer group %s, because %s", consumerGroupId, e.getMessage());
            LOGGER.warn(exceptionMessage);
            TPushConsumerGroupMetaRespExceptionMessage tPushConsumerGroupMetaRespExceptionMessage = new TPushConsumerGroupMetaRespExceptionMessage(consumerGroupId, exceptionMessage, System.currentTimeMillis());
            return tPushConsumerGroupMetaRespExceptionMessage;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void handleDropConsumerGroupInternal(String consumerGroupId) {
        if (SubscriptionAgent.broker().isBrokerExist(consumerGroupId)) {
            if (!SubscriptionAgent.broker().dropBroker(consumerGroupId)) {
                String exceptionMessage = String.format("Failed to drop broker bound to consumer group [%s]", consumerGroupId);
                LOGGER.warn(exceptionMessage);
                throw new SubscriptionException(exceptionMessage);
            }
        } else {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not existed when the corresponding consumer group meta has already existed on local agent, ignore it", (Object)consumerGroupId);
        }
        this.consumerGroupMetaKeeper.removeConsumerGroupMeta(consumerGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsumerExisted(String consumerGroupId, String consumerId) {
        this.acquireReadLock();
        try {
            ConsumerGroupMeta consumerGroupMeta = this.consumerGroupMetaKeeper.getConsumerGroupMeta(consumerGroupId);
            boolean bl = Objects.nonNull(consumerGroupMeta) && consumerGroupMeta.containsConsumer(consumerId);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getTopicsSubscribedByConsumer(String consumerGroupId, String consumerId) {
        this.acquireReadLock();
        try {
            Set set = this.consumerGroupMetaKeeper.getTopicsSubscribedByConsumer(consumerGroupId, consumerId);
            return set;
        }
        finally {
            this.releaseReadLock();
        }
    }
}

