/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.task.subtask;

import org.apache.iotdb.commons.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.task.subtask.connector.PipeConnectorSubtask;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.event.Event;

public class SubscriptionConnectorSubtask
extends PipeConnectorSubtask {
    private final String topicName;
    private final String consumerGroupId;

    public SubscriptionConnectorSubtask(String taskID, long creationTime, String attributeSortedString, int connectorIndex, BoundedBlockingPendingQueue<Event> inputPendingQueue, PipeConnector outputPipeConnector, String topicName, String consumerGroupId) {
        super(taskID, creationTime, attributeSortedString, connectorIndex, inputPendingQueue, outputPipeConnector);
        this.topicName = topicName;
        this.consumerGroupId = consumerGroupId;
    }

    @Override
    protected boolean executeOnce() {
        if (this.isClosed.get()) {
            return false;
        }
        SubscriptionAgent.broker().executePrefetch(this);
        return true;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public BoundedBlockingPendingQueue<Event> getInputPendingQueue() {
        return this.inputPendingQueue;
    }
}

