/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.timer;

public class SubscriptionPollTimer {
    private long startMs;
    private long currentTimeMs;
    private long deadlineMs;
    private long timeoutMs;

    public SubscriptionPollTimer(long startMs, long timeoutMs) {
        this.update(startMs);
        this.reset(timeoutMs);
    }

    public boolean isExpired() {
        return this.currentTimeMs >= this.deadlineMs;
    }

    public boolean notExpired() {
        return !this.isExpired();
    }

    public void reset(long timeoutMs) {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("Invalid negative timeout " + timeoutMs);
        }
        this.timeoutMs = timeoutMs;
        this.startMs = this.currentTimeMs;
        this.deadlineMs = this.currentTimeMs > Long.MAX_VALUE - timeoutMs ? Long.MAX_VALUE : this.currentTimeMs + timeoutMs;
    }

    public void update() {
        this.update(System.currentTimeMillis());
    }

    public void update(long currentTimeMs) {
        this.currentTimeMs = Math.max(currentTimeMs, this.currentTimeMs);
    }

    public long remainingMs() {
        return Math.max(0L, this.deadlineMs - this.currentTimeMs);
    }

    public long currentTimeMs() {
        return this.currentTimeMs;
    }

    public long elapsedMs() {
        return this.currentTimeMs - this.startMs;
    }

    public long timeoutMs() {
        return this.timeoutMs;
    }
}

