/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.task.Task;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TaskTest {
    @Test
    public void combineShouldReturnCompletedWhenBothCompleted() {
        Assertions.assertThat((Comparable)Task.combine((Task.Result)Task.Result.COMPLETED, (Task.Result)Task.Result.COMPLETED)).isEqualTo((Object)Task.Result.COMPLETED);
    }

    @Test
    public void combineShouldReturnPartialWhenPartialLeft() {
        Assertions.assertThat((Comparable)Task.combine((Task.Result)Task.Result.PARTIAL, (Task.Result)Task.Result.COMPLETED)).isEqualTo((Object)Task.Result.PARTIAL);
    }

    @Test
    public void combineShouldReturnPartialWhenPartialRight() {
        Assertions.assertThat((Comparable)Task.combine((Task.Result)Task.Result.COMPLETED, (Task.Result)Task.Result.PARTIAL)).isEqualTo((Object)Task.Result.PARTIAL);
    }

    @Test
    public void combineShouldReturnPartialWhenBothPartial() {
        Assertions.assertThat((Comparable)Task.combine((Task.Result)Task.Result.PARTIAL, (Task.Result)Task.Result.PARTIAL)).isEqualTo((Object)Task.Result.PARTIAL);
    }

    @Test
    public void onCompleteShouldExecuteOperationWhenCompleted() {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        Task.Operation[] operationArray = new Task.Operation[1];
        operationArray[0] = atomicInteger::incrementAndGet;
        Task.Result.COMPLETED.onComplete(operationArray);
        Assertions.assertThat((int)atomicInteger.get()).isEqualTo(1);
    }

    @Test
    public void onFailureShouldNotExecuteOperationWhenCompleted() {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        Task.Operation[] operationArray = new Task.Operation[1];
        operationArray[0] = atomicInteger::incrementAndGet;
        Task.Result.COMPLETED.onFailure(operationArray);
        Assertions.assertThat((int)atomicInteger.get()).isEqualTo(0);
    }

    @Test
    public void onCompleteShouldNotExecuteOperationWhenPartial() {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        Task.Operation[] operationArray = new Task.Operation[1];
        operationArray[0] = atomicInteger::incrementAndGet;
        Task.Result.PARTIAL.onComplete(operationArray);
        Assertions.assertThat((int)atomicInteger.get()).isEqualTo(0);
    }

    @Test
    public void onFailureShouldExecuteOperationWhenPartial() {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        Task.Operation[] operationArray = new Task.Operation[1];
        operationArray[0] = atomicInteger::incrementAndGet;
        Task.Result.PARTIAL.onFailure(operationArray);
        Assertions.assertThat((int)atomicInteger.get()).isEqualTo(1);
    }

    @Test
    public void onCompleteShouldReturnPartialWhenPartial() {
        Assertions.assertThat((Comparable)Task.Result.PARTIAL.onComplete(new Task.Operation[]{() -> {}})).isEqualTo((Object)Task.Result.PARTIAL);
    }

    @Test
    public void onFailureShouldReturnCompletedWhenCompleted() {
        Assertions.assertThat((Comparable)Task.Result.COMPLETED.onFailure(new Task.Operation[]{() -> {}})).isEqualTo((Object)Task.Result.COMPLETED);
    }

    @Test
    public void onCompleteShouldReturnCompletedWhenCompleted() {
        Assertions.assertThat((Comparable)Task.Result.COMPLETED.onComplete(new Task.Operation[]{() -> {}})).isEqualTo((Object)Task.Result.COMPLETED);
    }

    @Test
    public void onFailureShouldReturnPartialWhenPartial() {
        Assertions.assertThat((Comparable)Task.Result.PARTIAL.onFailure(new Task.Operation[]{() -> {}})).isEqualTo((Object)Task.Result.PARTIAL);
    }

    @Test
    public void onCompleteShouldReturnPartialWhenOperationThrows() {
        Assertions.assertThat((Comparable)Task.Result.COMPLETED.onComplete(new Task.Operation[]{() -> {
            throw new RuntimeException();
        }})).isEqualTo((Object)Task.Result.PARTIAL);
    }

    @Test
    public void onFailureShouldPreserveExceptions() {
        Assertions.assertThatThrownBy(() -> Task.Result.PARTIAL.onFailure(new Task.Operation[]{() -> {
            throw new RuntimeException();
        }})).isInstanceOf(RuntimeException.class);
    }
}

