/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Provides;
import java.io.Closeable;
import java.net.URI;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.atmos.binders.BindMetadataToHeaders;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.SystemMetadata;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.atmos.fallbacks.EndpointIfAlreadyExists;
import org.jclouds.atmos.filters.SignRequest;
import org.jclouds.atmos.functions.AtmosObjectName;
import org.jclouds.atmos.functions.ParseDirectoryListFromContentAndHeaders;
import org.jclouds.atmos.functions.ParseObjectFromHeadersAndHttpContent;
import org.jclouds.atmos.functions.ParseSystemMetadataFromHeaders;
import org.jclouds.atmos.functions.ParseUserMetadataFromHeaders;
import org.jclouds.atmos.functions.ReturnTrueIfGroupACLIsOtherRead;
import org.jclouds.atmos.options.ListOptions;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.http.options.GetOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@Deprecated
@RequestFilters(value={SignRequest.class})
@Path(value="/rest/namespace")
public interface AtmosAsyncClient
extends Closeable {
    @Provides
    public AtmosObject newObject();

    @Named(value="ListDirectory")
    @GET
    @ResponseParser(value=ParseDirectoryListFromContentAndHeaders.class)
    @Consumes(value={"text/xml"})
    public ListenableFuture<BoundedSet<? extends DirectoryEntry>> listDirectories(ListOptions ... var1);

    @Named(value="ListDirectory")
    @GET
    @Path(value="/{directoryName}/")
    @ResponseParser(value=ParseDirectoryListFromContentAndHeaders.class)
    @Fallback(value=BlobStoreFallbacks.ThrowContainerNotFoundOn404.class)
    @Consumes(value={"text/xml"})
    public ListenableFuture<BoundedSet<? extends DirectoryEntry>> listDirectory(@PathParam(value="directoryName") String var1, ListOptions ... var2);

    @Named(value="CreateDirectory")
    @POST
    @Path(value="/{directoryName}/")
    @Fallback(value=EndpointIfAlreadyExists.class)
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"*/*"})
    public ListenableFuture<URI> createDirectory(@PathParam(value="directoryName") String var1, PutOptions ... var2);

    @Named(value="CreateObject")
    @POST
    @Path(value="/{parent}/{name}")
    @Headers(keys={"Expect"}, values={"100-continue"})
    @Consumes(value={"*/*"})
    public ListenableFuture<URI> createFile(@PathParam(value="parent") String var1, @PathParam(value="name") @ParamParser(value=AtmosObjectName.class) @BinderParam(value=BindMetadataToHeaders.class) AtmosObject var2, PutOptions ... var3);

    @Named(value="UpdateObject")
    @PUT
    @Path(value="/{parent}/{name}")
    @Headers(keys={"Expect"}, values={"100-continue"})
    @Fallback(value=BlobStoreFallbacks.ThrowKeyNotFoundOn404.class)
    @Consumes(value={"*/*"})
    public ListenableFuture<Void> updateFile(@PathParam(value="parent") String var1, @PathParam(value="name") @ParamParser(value=AtmosObjectName.class) @BinderParam(value=BindMetadataToHeaders.class) AtmosObject var2, PutOptions ... var3);

    @Named(value="ReadObject")
    @GET
    @ResponseParser(value=ParseObjectFromHeadersAndHttpContent.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public ListenableFuture<AtmosObject> readFile(@PathParam(value="path") String var1, GetOptions ... var2);

    @Named(value="GetObjectMetadata")
    @HEAD
    @ResponseParser(value=ParseObjectFromHeadersAndHttpContent.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public ListenableFuture<AtmosObject> headFile(@PathParam(value="path") String var1);

    @Named(value="GetSystemMetadata")
    @HEAD
    @ResponseParser(value=ParseSystemMetadataFromHeaders.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public ListenableFuture<SystemMetadata> getSystemMetadata(@PathParam(value="path") String var1);

    @Named(value="GetUserMetadata")
    @HEAD
    @ResponseParser(value=ParseUserMetadataFromHeaders.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/{path}")
    @QueryParams(keys={"metadata/user"})
    @Consumes(value={"*/*"})
    public ListenableFuture<UserMetadata> getUserMetadata(@PathParam(value="path") String var1);

    @Named(value="DeleteObject")
    @DELETE
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public ListenableFuture<Void> deletePath(@PathParam(value="path") String var1);

    @Named(value="GetObjectMetadata")
    @HEAD
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public ListenableFuture<Boolean> pathExists(@PathParam(value="path") String var1);

    @Named(value="GetObjectMetadata")
    @HEAD
    @ResponseParser(value=ReturnTrueIfGroupACLIsOtherRead.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> isPublic(@PathParam(value="path") String var1);
}

