/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.binders;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindUserMetadataToHeaders
implements Binder,
Function<UserMetadata, Map<String, String>> {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof UserMetadata), (Object)"this binder is only valid for UserMetadatas!");
        Preconditions.checkNotNull(request, (Object)"request");
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)Multimaps.forMap(this.apply((UserMetadata)UserMetadata.class.cast(input))))).build();
    }

    public Map<String, String> apply(UserMetadata md) {
        String header;
        ImmutableMap.Builder headers = ImmutableMap.builder();
        if (md.getMetadata().size() > 0) {
            header = Joiner.on((char)',').withKeyValueSeparator("=").join(md.getMetadata());
            headers.put((Object)"x-emc-meta", (Object)header);
        }
        if (md.getListableMetadata().size() > 0) {
            header = Joiner.on((char)',').withKeyValueSeparator("=").join(md.getListableMetadata());
            headers.put((Object)"x-emc-listable-meta", (Object)header);
        }
        if (md.getTags().size() > 0) {
            header = Joiner.on((char)',').join(md.getTags());
            headers.put((Object)"x-emc-tags", (Object)header);
        }
        if (md.getListableTags().size() > 0) {
            header = Joiner.on((char)',').join(md.getListableTags());
            headers.put((Object)"x-emc-listable-tags", (Object)header);
        }
        return headers.build();
    }
}

