/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.domain;

import org.jclouds.atmos.domain.FileType;

public class DirectoryEntry
implements Comparable<DirectoryEntry> {
    private final String objectid;
    private final FileType type;
    private final String objname;

    public DirectoryEntry(String objectid, FileType type, String objname) {
        this.objectid = objectid;
        this.objname = objname;
        this.type = type;
    }

    public String getObjectID() {
        return this.objectid;
    }

    public String getObjectName() {
        return this.objname;
    }

    public FileType getType() {
        return this.type;
    }

    @Override
    public int compareTo(DirectoryEntry o) {
        if (this.getObjectName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getObjectName().compareTo(o.getObjectName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.objectid == null ? 0 : this.objectid.hashCode());
        result = 31 * result + (this.objname == null ? 0 : this.objname.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectoryEntry other = (DirectoryEntry)obj;
        if (this.objectid == null ? other.objectid != null : !this.objectid.equals(other.objectid)) {
            return false;
        }
        if (this.objname == null ? other.objname != null : !this.objname.equals(other.objname)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public String toString() {
        return "DirectoryEntry [type=" + (Object)((Object)this.type) + ", objectid=" + this.objectid + ", objname=" + this.objname + "]";
    }
}

