/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.glance.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.location.Zone;
import org.jclouds.rest.HttpClient;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.util.Strings2;

@Singleton
public class ZoneToEndpointNegotiateVersion
implements Function<Object, URI> {
    public static final String VERSION_NEGOTIATION_HEADER = "Is-Version-Negotiation-Request";
    private static final Pattern versionRegex = Pattern.compile("v[0-9]+(\\.[0-9])?[0-9]*");
    private final Supplier<Map<String, Supplier<URI>>> zoneToEndpointSupplier;
    private final String apiVersion;
    private final LoadingCache<URI, URI> endpointCache;

    @Inject
    public ZoneToEndpointNegotiateVersion(@Zone Supplier<Map<String, Supplier<URI>>> zoneToEndpointSupplier, @ApiVersion String rawApiVersionString, final HttpClient client, final Json json) {
        this.zoneToEndpointSupplier = (Supplier)Preconditions.checkNotNull(zoneToEndpointSupplier, (Object)"zoneToEndpointSupplier");
        this.apiVersion = !rawApiVersionString.startsWith("v") ? "v" + rawApiVersionString : rawApiVersionString;
        this.endpointCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<URI, URI>(){

            public URI load(URI baseEndpointUri) {
                try {
                    List baseEndpointPathParts = Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)baseEndpointUri.getPath());
                    if (!baseEndpointPathParts.isEmpty() && versionRegex.matcher((CharSequence)baseEndpointPathParts.get(baseEndpointPathParts.size() - 1)).matches()) {
                        baseEndpointUri = new URI(baseEndpointUri.getScheme(), baseEndpointUri.getUserInfo(), baseEndpointUri.getHost(), baseEndpointUri.getPort(), Joiner.on((char)'/').join(baseEndpointPathParts.subList(0, baseEndpointPathParts.size() - 1)) + "/", baseEndpointUri.getQuery(), baseEndpointUri.getFragment());
                    }
                    HttpRequest negotiationRequest = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(baseEndpointUri).addHeader(ZoneToEndpointNegotiateVersion.VERSION_NEGOTIATION_HEADER, new String[]{"true"})).build();
                    InputStream response = client.invoke(negotiationRequest).getPayload().openStream();
                    VersionsJsonResponse versions = (VersionsJsonResponse)json.fromJson(Strings2.toStringAndClose((InputStream)response), VersionsJsonResponse.class);
                    for (VersionsJsonResponse.Version version : versions.versions) {
                        if (!ZoneToEndpointNegotiateVersion.this.apiVersion.equals(version.id)) continue;
                        URI versionedEndpointUri = new URI(((VersionsJsonResponse.Version.Link)Iterables.getOnlyElement(version.links)).href);
                        return new URI(baseEndpointUri.getScheme(), versionedEndpointUri.getUserInfo(), versionedEndpointUri.getHost(), versionedEndpointUri.getPort(), versionedEndpointUri.getPath(), versionedEndpointUri.getQuery(), versionedEndpointUri.getFragment());
                    }
                }
                catch (URISyntaxException ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
                catch (IOException ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
                throw new UnsupportedOperationException("Glance endpoint does not support API version: " + ZoneToEndpointNegotiateVersion.this.apiVersion);
            }
        });
    }

    public URI apply(Object from) {
        Preconditions.checkArgument((boolean)(from instanceof String), (Object)"you must specify a zone, as a String argument");
        Map zoneToEndpoint = (Map)this.zoneToEndpointSupplier.get();
        Preconditions.checkState((!zoneToEndpoint.isEmpty() ? 1 : 0) != 0, (Object)"no zone name to endpoint mappings configured!");
        Preconditions.checkArgument((boolean)zoneToEndpoint.containsKey(from), (String)"requested location %s, which is not in the configured locations: %s", (Object[])new Object[]{from, zoneToEndpoint});
        URI uri = (URI)((Supplier)((Map)this.zoneToEndpointSupplier.get()).get(from)).get();
        try {
            return (URI)this.endpointCache.get((Object)uri);
        }
        catch (ExecutionException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private static class VersionsJsonResponse {
        public List<Version> versions;

        private VersionsJsonResponse() {
        }

        public static class Version {
            public String status;
            public String id;
            public List<Link> links;

            public static class Link {
                public String href;
                public String rel;
            }
        }
    }
}

