/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class FloatingIP {
    private String id;
    @Named(value="router_id")
    private String routerId;
    @Named(value="tenant_id")
    private String tenantId;
    @Named(value="floating_network_id")
    private String floatingNetworkId;
    @Named(value="fixed_ip_address")
    private String fixedIpAddress;
    @Named(value="floating_ip_address")
    private String floatingIpAddress;
    @Named(value="port_id")
    private String portId;

    @ConstructorProperties(value={"id", "router_id", "tenant_id", "floating_network_id", "fixed_ip_address", "floating_ip_address", "port_id"})
    private FloatingIP(String id, String routerId, String tenantId, String floatingNetworkId, String fixedIpAddress, String floatingIpAddress, String portId) {
        this.id = id;
        this.routerId = routerId;
        this.tenantId = tenantId;
        this.floatingNetworkId = floatingNetworkId;
        this.fixedIpAddress = fixedIpAddress;
        this.floatingIpAddress = floatingIpAddress;
        this.portId = portId;
    }

    private FloatingIP() {
    }

    private FloatingIP(FloatingIP floatingIP) {
        this(floatingIP.id, floatingIP.routerId, floatingIP.tenantId, floatingIP.floatingNetworkId, floatingIP.fixedIpAddress, floatingIP.floatingIpAddress, floatingIP.portId);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getRouterId() {
        return this.routerId;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public String getFloatingNetworkId() {
        return this.floatingNetworkId;
    }

    @Nullable
    public String getFixedIpAddress() {
        return this.fixedIpAddress;
    }

    @Nullable
    public String getFloatingIpAddress() {
        return this.floatingIpAddress;
    }

    @Nullable
    public String getPortId() {
        return this.portId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatingIP that = (FloatingIP)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.routerId, (Object)that.routerId) && Objects.equal((Object)this.tenantId, (Object)that.tenantId) && Objects.equal((Object)this.floatingNetworkId, (Object)that.floatingNetworkId) && Objects.equal((Object)this.fixedIpAddress, (Object)that.fixedIpAddress) && Objects.equal((Object)this.floatingIpAddress, (Object)that.floatingIpAddress) && Objects.equal((Object)this.portId, (Object)that.portId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.routerId, this.tenantId, this.floatingNetworkId, this.fixedIpAddress, this.floatingIpAddress, this.portId});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("routerId", (Object)this.routerId).add("tenantId", (Object)this.tenantId).add("floatingNetworkId", (Object)this.floatingNetworkId).add("fixedIpAddress", (Object)this.fixedIpAddress).add("floatingIpAddress", (Object)this.floatingIpAddress).add("portId", (Object)this.portId).toString();
    }

    public static CreateBuilder createBuilder(String floatingNetworkId) {
        return new CreateBuilder(floatingNetworkId);
    }

    public static UpdateBuilder updateBuilder() {
        return new UpdateBuilder();
    }

    public static class UpdateFloatingIP
    extends FloatingIP {
        private UpdateFloatingIP(FloatingIP floatingIP) {
            super(floatingIP);
        }
    }

    public static class CreateFloatingIP
    extends FloatingIP {
        private CreateFloatingIP(FloatingIP floatingIP) {
            super(floatingIP);
        }
    }

    public static class UpdateBuilder
    extends Builder<UpdateBuilder> {
        private UpdateBuilder() {
        }

        public UpdateBuilder floatingIpAddress(String floatingIpAddress) {
            this.floatingIP.floatingIpAddress = floatingIpAddress;
            return this;
        }

        public UpdateFloatingIP build() {
            return new UpdateFloatingIP(this.floatingIP);
        }

        @Override
        protected UpdateBuilder self() {
            return this;
        }
    }

    public static class CreateBuilder
    extends Builder<CreateBuilder> {
        private CreateBuilder(String floatingNetworkId) {
            this.floatingIP.floatingNetworkId = floatingNetworkId;
        }

        public CreateFloatingIP build() {
            return new CreateFloatingIP(this.floatingIP);
        }

        @Override
        protected CreateBuilder self() {
            return this;
        }
    }

    private static abstract class Builder<ParameterizedBuilderType> {
        protected FloatingIP floatingIP = new FloatingIP();

        private Builder() {
        }

        protected abstract ParameterizedBuilderType self();

        public ParameterizedBuilderType tenantId(String tenantId) {
            this.floatingIP.tenantId = tenantId;
            return this.self();
        }

        public ParameterizedBuilderType floatingNetworkId(String floatingNetworkId) {
            this.floatingIP.floatingNetworkId = floatingNetworkId;
            return this.self();
        }

        public ParameterizedBuilderType fixedIpAddress(String fixedIpAddress) {
            this.floatingIP.fixedIpAddress = fixedIpAddress;
            return this.self();
        }

        public ParameterizedBuilderType portId(String portId) {
            this.floatingIP.portId = portId;
            return this.self();
        }
    }
}

