/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.extensions.lbaas.v1;

import com.google.common.annotations.Beta;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.HealthMonitor;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.HealthMonitors;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.Member;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.Members;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.Pool;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.Pools;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.VIP;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.VIPs;
import org.jclouds.openstack.neutron.v2.fallbacks.lbaas.v1.EmptyHealthMonitorsFallback;
import org.jclouds.openstack.neutron.v2.fallbacks.lbaas.v1.EmptyMembersFallback;
import org.jclouds.openstack.neutron.v2.fallbacks.lbaas.v1.EmptyPoolsFallback;
import org.jclouds.openstack.neutron.v2.fallbacks.lbaas.v1.EmptyVIPsFallback;
import org.jclouds.openstack.neutron.v2.functions.lbaas.v1.HealthMonitorsToPagedIterable;
import org.jclouds.openstack.neutron.v2.functions.lbaas.v1.MembersToPagedIterable;
import org.jclouds.openstack.neutron.v2.functions.lbaas.v1.ParseHealthMonitors;
import org.jclouds.openstack.neutron.v2.functions.lbaas.v1.ParseMembers;
import org.jclouds.openstack.neutron.v2.functions.lbaas.v1.ParsePools;
import org.jclouds.openstack.neutron.v2.functions.lbaas.v1.ParseVIPs;
import org.jclouds.openstack.neutron.v2.functions.lbaas.v1.PoolsToPagedIterable;
import org.jclouds.openstack.neutron.v2.functions.lbaas.v1.VIPsToPagedIterable;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@Extension(of="network", namespace="http://wiki.openstack.org/neutron/LBaaS/API_1.0")
@Path(value="/lb")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Beta
public interface LBaaSApi {
    @Named(value="vip:list")
    @GET
    @Path(value="/vips")
    @Transform(value=VIPsToPagedIterable.class)
    @ResponseParser(value=ParseVIPs.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<VIP> listVIPs();

    @Named(value="vip:list")
    @GET
    @Path(value="/vips")
    @ResponseParser(value=ParseVIPs.class)
    @Fallback(value=EmptyVIPsFallback.class)
    public VIPs listVIPs(PaginationOptions var1);

    @Named(value="vip:get")
    @GET
    @Path(value="/vips/{id}")
    @SelectJson(value={"vip"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public VIP getVIP(@PathParam(value="id") String var1);

    @Named(value="vip:create")
    @POST
    @Path(value="/vips")
    @SelectJson(value={"vip"})
    public VIP createVIP(@WrapWith(value="vip") VIP.CreateVIP var1);

    @Named(value="vip:update")
    @PUT
    @Path(value="/vips/{id}")
    @SelectJson(value={"vip"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public VIP updateVIP(@PathParam(value="id") String var1, @WrapWith(value="vip") VIP.UpdateVIP var2);

    @Named(value="vip:delete")
    @DELETE
    @Path(value="/vips/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteVIP(@PathParam(value="id") String var1);

    @Named(value="pool:list")
    @GET
    @Path(value="/pools")
    @Transform(value=PoolsToPagedIterable.class)
    @ResponseParser(value=ParsePools.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Pool> listPools();

    @Named(value="pool:list")
    @GET
    @Path(value="/pools")
    @ResponseParser(value=ParsePools.class)
    @Fallback(value=EmptyPoolsFallback.class)
    public Pools listPools(PaginationOptions var1);

    @Named(value="pool:get")
    @GET
    @Path(value="/pools/{id}")
    @SelectJson(value={"pool"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Pool getPool(@PathParam(value="id") String var1);

    @Named(value="pool:create")
    @POST
    @Path(value="/pools")
    @SelectJson(value={"pool"})
    public Pool createPool(@WrapWith(value="pool") Pool.CreatePool var1);

    @Named(value="pool:update")
    @PUT
    @Path(value="/pools/{id}")
    @SelectJson(value={"pool"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Pool updatePool(@PathParam(value="id") String var1, @WrapWith(value="pool") Pool.UpdatePool var2);

    @Named(value="pool:delete")
    @DELETE
    @Path(value="/pools/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deletePool(@PathParam(value="id") String var1);

    @Named(value="member:list")
    @GET
    @Path(value="/members")
    @Transform(value=MembersToPagedIterable.class)
    @ResponseParser(value=ParseMembers.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Member> listMembers();

    @Named(value="member:list")
    @GET
    @Path(value="/members")
    @ResponseParser(value=ParseMembers.class)
    @Fallback(value=EmptyMembersFallback.class)
    public Members listMembers(PaginationOptions var1);

    @Named(value="member:get")
    @GET
    @Path(value="/members/{id}")
    @SelectJson(value={"member"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Member getMember(@PathParam(value="id") String var1);

    @Named(value="member:create")
    @POST
    @Path(value="/members")
    @SelectJson(value={"member"})
    public Member createMember(@WrapWith(value="member") Member.CreateMember var1);

    @Named(value="member:update")
    @PUT
    @Path(value="/members/{id}")
    @SelectJson(value={"member"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Member updateMember(@PathParam(value="id") String var1, @WrapWith(value="member") Member.UpdateMember var2);

    @Named(value="member:delete")
    @DELETE
    @Path(value="/members/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteMember(@PathParam(value="id") String var1);

    @Named(value="health_monitor:list")
    @GET
    @Path(value="/health_monitors")
    @Transform(value=HealthMonitorsToPagedIterable.class)
    @ResponseParser(value=ParseHealthMonitors.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<HealthMonitor> listHealthMonitors();

    @Named(value="health_monitor:list")
    @GET
    @Path(value="/health_monitors")
    @ResponseParser(value=ParseHealthMonitors.class)
    @Fallback(value=EmptyHealthMonitorsFallback.class)
    public HealthMonitors listHealthMonitors(PaginationOptions var1);

    @Named(value="health_monitor:get")
    @GET
    @Path(value="/health_monitors/{id}")
    @SelectJson(value={"health_monitor"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public HealthMonitor getHealthMonitor(@PathParam(value="id") String var1);

    @Named(value="health_monitor:create")
    @POST
    @Path(value="/health_monitors")
    @SelectJson(value={"health_monitor"})
    public HealthMonitor createHealthMonitor(@WrapWith(value="health_monitor") HealthMonitor.CreateHealthMonitor var1);

    @Named(value="health_monitor:update")
    @PUT
    @Path(value="/health_monitors/{id}")
    @SelectJson(value={"health_monitor"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public HealthMonitor updateHealthMonitor(@PathParam(value="id") String var1, @WrapWith(value="health_monitor") HealthMonitor.UpdateHealthMonitor var2);

    @Named(value="health_monitor:delete")
    @DELETE
    @Path(value="/health_monitors/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteHealthMonitor(@PathParam(value="id") String var1);

    @Named(value="pool:associate_health_monitor")
    @POST
    @Path(value="/pools/{pool-id}/health_monitors")
    @SelectJson(value={"health_monitor"})
    @Payload(value="%7B\"health_monitor\":%7B\"id\":\"{healthMonitorId}\"%7D%7D")
    @Produces(value={"application/json"})
    public HealthMonitor associateHealthMonitor(@PathParam(value="pool-id") String var1, @PayloadParam(value="healthMonitorId") String var2);

    @Named(value="pool:disassociate_health_monitor")
    @DELETE
    @Path(value="/pools/{pool-id}/health_monitors/{health-monitor-id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean disassociateHealthMonitor(@PathParam(value="pool-id") String var1, @PathParam(value="health-monitor-id") String var2);
}

