/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling;

import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.Processor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.ResolverImpl;
import org.apache.felix.utils.resource.ResourceBuilder;
import org.apache.felix.utils.resource.ResourceImpl;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.DeploymentEvent;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.LocationPattern;
import org.apache.karaf.features.internal.download.DownloadCallback;
import org.apache.karaf.features.internal.download.DownloadManager;
import org.apache.karaf.features.internal.download.Downloader;
import org.apache.karaf.features.internal.download.StreamProvider;
import org.apache.karaf.features.internal.model.Conditional;
import org.apache.karaf.features.internal.model.ConfigFile;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JacksonUtil;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.features.internal.service.Deployer;
import org.apache.karaf.features.internal.service.FeaturesProcessorImpl;
import org.apache.karaf.features.internal.service.FeaturesServiceConfig;
import org.apache.karaf.features.internal.service.State;
import org.apache.karaf.features.internal.service.StaticInstallSupport;
import org.apache.karaf.features.internal.util.MapUtils;
import org.apache.karaf.features.internal.util.MultiException;
import org.apache.karaf.profile.assembly.CustomDownloadManager;
import org.apache.karaf.tooling.utils.MavenUtil;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.karaf.tooling.utils.ReactorMavenResolver;
import org.apache.karaf.util.Version;
import org.apache.karaf.util.config.PropertiesLoader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.repository.WorkspaceReader;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.MavenResolvers;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Requirement;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.Resolver;

@Mojo(name="verify", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class VerifyMojo
extends MojoSupport {
    @Parameter(property="descriptors")
    protected Set<String> descriptors;
    @Parameter(property="blacklistedDescriptors")
    protected Set<String> blacklistedDescriptors;
    @Parameter(property="featureProcessingInstructions")
    protected File featureProcessingInstructions;
    @Parameter(property="failOnUninstall")
    protected boolean failOnUninstall = true;
    @Parameter(property="failOnUpdate")
    protected boolean failOnUpdate = true;
    @Parameter(property="features")
    protected List<String> features;
    @Parameter(property="framework")
    protected Set<String> framework;
    @Parameter(property="configuration")
    protected String configuration;
    @Parameter(property="distribution", defaultValue="org.apache.karaf:apache-karaf")
    protected String distribution;
    @Parameter(property="javase")
    protected String javase;
    @Parameter(property="dist-dir")
    protected String distDir;
    @Parameter(property="karaf-version")
    protected String karafVersion;
    @Parameter(property="additional-metadata")
    protected File additionalMetadata;
    @Parameter(property="ignore-missing-conditions")
    protected boolean ignoreMissingConditions;
    @Parameter(property="fail")
    protected String fail = "end";
    @Parameter(property="verify-transitive")
    protected boolean verifyTransitive = false;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Component(role=WorkspaceReader.class, hint="reactor")
    protected WorkspaceReader reactor;
    @Parameter(property="skip", defaultValue="${features.verify.skip}")
    protected boolean skip;
    @Parameter(readonly=true, defaultValue="${project.groupId}")
    protected String selfGroupId;
    @Parameter(readonly=true, defaultValue="${project.artifactId}")
    protected String selfArtifactId;
    protected MavenResolver resolver;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        if (this.karafVersion == null) {
            this.karafVersion = Version.karafVersion();
        }
        Hashtable<String, String> config = new Hashtable<String, String>();
        String remoteRepositories = MavenUtil.remoteRepositoryList(this.project.getRemoteProjectRepositories());
        this.getLog().info((CharSequence)("Using repositories: " + remoteRepositories));
        config.put("maven.repositories", remoteRepositories);
        config.put("maven.localRepository", this.localRepo.getBasedir());
        if (this.mavenSession.getRequest().getUserSettingsFile().exists()) {
            config.put("maven.settings", this.mavenSession.getRequest().getUserSettingsFile().toString());
        }
        this.resolver = new ReactorMavenResolver(this.reactor, MavenResolvers.createMavenResolver(config, (String)"maven"));
        this.doExecute();
    }

    private String getVersion(String id, String def) {
        String v = this.getVersion(id);
        return v != null ? v : def;
    }

    private String getVersion(String id) {
        Artifact artifact = (Artifact)this.project.getArtifactMap().get(id);
        if (artifact != null) {
            return artifact.getBaseVersion();
        }
        if (id.startsWith("org.apache.karaf")) {
            return this.karafVersion;
        }
        return null;
    }

    private static Object invoke(Object object, String getter) throws MojoExecutionException {
        try {
            return object.getClass().getMethod(getter, new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build remote repository from " + object.toString(), e);
        }
    }

    private static Object getPolicy(Object object, boolean snapshots) throws MojoExecutionException {
        return VerifyMojo.invoke(object, "getPolicy", new Class[]{Boolean.TYPE}, new Object[]{snapshots});
    }

    private static Object invoke(Object object, String getter, Class<?>[] types, Object[] params) throws MojoExecutionException {
        try {
            return object.getClass().getMethod(getter, types).invoke(object, params);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build remote repository from " + object.toString(), e);
        }
    }

    protected void doExecute() throws MojoExecutionException {
        Map<String, Features> repositories;
        System.setProperty("karaf.home", "target/karaf");
        System.setProperty("karaf.data", "target/karaf/data");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (this.additionalMetadata != null) {
            try (FileReader reader = new FileReader(this.additionalMetadata);){
                Properties metadata = new Properties();
                metadata.load(reader);
                Enumeration<?> e = metadata.propertyNames();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object val = metadata.get(key);
                    properties.put(key.toString(), val.toString());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to load additional metadata from " + this.additionalMetadata, (Exception)e);
            }
        }
        LinkedHashSet<String> allDescriptors = new LinkedHashSet<String>();
        if (this.descriptors == null) {
            if (this.framework == null) {
                this.framework = Collections.singleton("framework");
            }
            this.descriptors = new LinkedHashSet<String>();
            if (this.framework.contains("framework")) {
                allDescriptors.add("mvn:org.apache.karaf.features/framework/" + this.getVersion("org.apache.karaf.features:framework") + "/xml/features");
            }
            String filePrefix = null;
            filePrefix = System.getProperty("os.name").contains("Windows") ? "file:/" : "file:";
            allDescriptors.add(filePrefix + this.project.getBuild().getDirectory() + File.separator + "feature" + File.separator + "feature.xml");
        } else {
            allDescriptors.addAll(this.descriptors);
            if (this.framework != null && this.framework.contains("framework")) {
                allDescriptors.add("mvn:org.apache.karaf.features/framework/" + this.getVersion("org.apache.karaf.features:framework") + "/xml/features");
            }
        }
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(8);
        CustomDownloadManager manager = new CustomDownloadManager(this.resolver, executor);
        HashMap<String, List> allFeatures = new HashMap<String, List>();
        try {
            repositories = this.loadRepositories((DownloadManager)manager, allDescriptors);
            for (String string : repositories.keySet()) {
                List features = repositories.get(string).getFeature();
                for (org.apache.karaf.features.internal.model.Feature feature : features) {
                    for (org.apache.karaf.features.internal.model.Bundle bi : feature.getBundle()) {
                        String loc = bi.getLocation();
                        String nloc = null;
                        if (loc.contains("file:")) {
                            for (ConfigFile cfi : feature.getConfigfile()) {
                                if (!cfi.getFinalname().substring(1).equals(loc.substring(loc.indexOf("file:") + "file:".length()))) continue;
                                nloc = cfi.getLocation();
                            }
                        }
                        if (nloc == null) continue;
                        Field field = bi.getClass().getDeclaredField("location");
                        field.setAccessible(true);
                        field.set(bi, loc.substring(0, loc.indexOf("file:")) + nloc);
                    }
                }
                allFeatures.put(string, features);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to load features descriptors", e);
        }
        ArrayList featuresToTest = new ArrayList();
        if (this.verifyTransitive) {
            for (List features : allFeatures.values()) {
                featuresToTest.addAll(features);
            }
        } else {
            for (String uri : this.descriptors) {
                featuresToTest.addAll((Collection)allFeatures.get(uri));
            }
        }
        if (this.features != null && !this.features.isEmpty()) {
            Pattern pattern = VerifyMojo.getPattern(this.features);
            Iterator iterator = featuresToTest.iterator();
            while (iterator.hasNext()) {
                org.apache.karaf.features.internal.model.Feature feature = (org.apache.karaf.features.internal.model.Feature)iterator.next();
                String id = feature.getName() + "/" + feature.getVersion();
                if (pattern.matcher(id).matches()) continue;
                iterator.remove();
            }
        }
        for (String fmk : this.framework) {
            properties.put("feature.framework." + fmk, fmk);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashSet<String> ignored = new LinkedHashSet<String>();
        LinkedHashSet<String> skipped = new LinkedHashSet<String>();
        LinkedHashMap<String, Exception> failures = new LinkedHashMap<String, Exception>();
        for (org.apache.karaf.features.internal.model.Feature feature : featuresToTest) {
            block45: {
                String id = feature.getId();
                if (feature.isBlacklisted()) {
                    skipped.add(id);
                    this.getLog().info((CharSequence)("Verification of feature " + id + " skipped"));
                    continue;
                }
                try {
                    this.verifyResolution((DownloadManager)new CustomDownloadManager(this.resolver, executor), repositories, Collections.singleton(id), properties);
                    linkedHashSet.add(id);
                    this.getLog().info((CharSequence)("Verification of feature " + id + " succeeded"));
                }
                catch (Exception e) {
                    if (e.getCause() instanceof ResolutionException || !this.getLog().isDebugEnabled()) {
                        this.getLog().warn((CharSequence)(e.getMessage() + ": " + id));
                        this.getLog().warn((CharSequence)e.getCause().getMessage());
                    } else {
                        this.getLog().warn((Throwable)e);
                    }
                    failures.put(id, e);
                    if (!"first".equals(this.fail)) break block45;
                    throw e;
                }
            }
            for (Conditional cond : feature.getConditional()) {
                LinkedHashSet<String> ids = new LinkedHashSet<String>();
                ids.add(feature.getId());
                ids.addAll(cond.getCondition());
                String cid = String.join((CharSequence)"+", ids);
                try {
                    this.verifyResolution((DownloadManager)manager, repositories, ids, properties);
                    linkedHashSet.add(cid);
                    this.getLog().info((CharSequence)("Verification of feature " + cid + " succeeded"));
                }
                catch (Exception e) {
                    if (this.ignoreMissingConditions && e.getCause() instanceof ResolutionException) {
                        boolean ignore = true;
                        Collection requirements = ((ResolutionException)e.getCause()).getUnresolvedRequirements();
                        for (Requirement req : requirements) {
                            ignore &= "osgi.identity".equals(req.getNamespace()) && "karaf.feature".equals(req.getAttributes().get("type")) && cond.getCondition().contains(req.getAttributes().get("osgi.identity").toString());
                        }
                        if (ignore) {
                            ignored.add(cid);
                            this.getLog().warn((CharSequence)("Feature resolution failed for " + cid + "\nMessage: " + e.getCause().getMessage()));
                            continue;
                        }
                    }
                    if (e.getCause() instanceof ResolutionException || !this.getLog().isDebugEnabled()) {
                        this.getLog().warn((CharSequence)e.getMessage());
                    } else {
                        this.getLog().warn((Throwable)e);
                    }
                    failures.put(cid, e);
                    if (!"first".equals(this.fail)) continue;
                    throw e;
                }
            }
        }
        int nb = linkedHashSet.size() + ignored.size() + failures.size();
        this.getLog().info((CharSequence)("Features verified: " + nb + ", failures: " + failures.size() + ", ignored: " + ignored.size() + ", skipped: " + skipped.size()));
        if (!failures.isEmpty()) {
            this.getLog().info((CharSequence)("Failures: " + String.join((CharSequence)", ", failures.keySet())));
        }
        if ("end".equals(this.fail) && !failures.isEmpty()) {
            throw new MojoExecutionException("Verification failures", (Exception)new MultiException("Verification failures", new ArrayList(failures.values())));
        }
    }

    static Pattern getPattern(List<String> features) {
        StringBuilder sb = new StringBuilder();
        boolean prevIsNeg = false;
        for (String feature : features) {
            if (sb.length() > 0 && !prevIsNeg) {
                sb.append("|");
            }
            sb.append("(");
            feature = feature.trim();
            boolean negative = feature.startsWith("!");
            if (negative) {
                feature = feature.substring("!".length());
                sb.append("(?!");
            }
            String p = feature.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
            sb.append(p);
            if (!feature.contains("/")) {
                sb.append("/.*");
            }
            if (negative) {
                sb.append(")");
            }
            prevIsNeg = negative;
        }
        for (String feature : features) {
            sb.append(")");
        }
        return Pattern.compile(sb.toString());
    }

    private void verifyResolution(DownloadManager manager, Map<String, Features> repositories, Set<String> features, Hashtable<String, String> properties) throws MojoExecutionException {
        try {
            Bundle systemBundle = this.getSystemBundle(VerifyMojo.getMetadata(properties, "metadata#"));
            DummyDeployCallback callback = new DummyDeployCallback(systemBundle, repositories.values(), this.failOnUpdate, this.failOnUninstall);
            Deployer deployer = new Deployer(manager, (Resolver)new ResolverImpl((Logger)new MavenResolverLog()), (Deployer.DeployCallback)callback);
            Deployer.DeploymentRequest request = Deployer.DeploymentRequest.defaultDeploymentRequest();
            for (String fmwk : this.framework) {
                MapUtils.addToMapSet((Map)request.requirements, (Object)"root", (Object)fmwk);
            }
            try {
                deployer.deploy(callback.getDeploymentState(), request);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to resolve framework features", e);
            }
            for (String feature : features) {
                MapUtils.addToMapSet((Map)request.requirements, (Object)"root", (Object)feature);
            }
            try {
                deployer.deployFully(callback.getDeploymentState(), request);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Feature resolution failed for " + features + "\nMessage: " + (e instanceof ResolutionException ? e.getMessage() : e.toString()) + "\nRepositories: " + VerifyMojo.toString(new TreeSet<String>(repositories.keySet())) + "\nResources: " + VerifyMojo.toString(new TreeSet<String>(manager.getProviders().keySet())), e);
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error verifying feature " + features + "\nMessage: " + e.getMessage(), e);
        }
    }

    private static String toString(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (String s : collection) {
            sb.append("\t").append(s).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private Bundle getSystemBundle(Map<String, Map<VersionRange, Map<String, String>>> metadata) throws Exception {
        URL configPropURL;
        if (this.configuration != null) {
            configPropURL = new URL(this.configuration);
        } else {
            Artifact karafDistro = (Artifact)this.project.getArtifactMap().get(this.distribution);
            if (karafDistro != null) {
                String dir = this.distDir;
                if ("kar".equals(karafDistro.getType()) && dir == null) {
                    dir = "resources";
                }
                if (dir == null) {
                    dir = karafDistro.getArtifactId() + "-" + karafDistro.getBaseVersion();
                }
                configPropURL = new URL("jar:file:" + karafDistro.getFile() + "!/" + dir + "/etc/config.properties");
            } else {
                String version = this.getVersion(this.distribution, "RELEASE");
                String[] dist = this.distribution.split(":");
                File distFile = this.resolveDistributionArtifact(version, dist);
                String resolvedVersion = distFile.getName().substring(dist[1].length() + 1, distFile.getName().length() - 4);
                Object dir = this.distDir;
                if (dir == null) {
                    dir = dist[1] + "-" + resolvedVersion;
                }
                configPropURL = new URL("jar:file:" + distFile + "!/" + (String)dir + "/etc/config.properties");
            }
        }
        org.apache.felix.utils.properties.Properties configProps = PropertiesLoader.loadPropertiesFile((URL)configPropURL, (boolean)true);
        if (this.javase == null) {
            configProps.put("java.specification.version", System.getProperty("java.specification.version"));
        } else {
            configProps.put("java.specification.version", this.javase);
        }
        configProps.substitute();
        Attributes attributes = new Attributes();
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-SymbolicName", "system.bundle");
        attributes.putValue("Bundle-Version", "0.0.0");
        String exportPackages = configProps.getProperty("org.osgi.framework.system.packages");
        if (configProps.containsKey((Object)"org.osgi.framework.system.packages.extra")) {
            exportPackages = exportPackages + "," + configProps.getProperty("org.osgi.framework.system.packages.extra");
        }
        exportPackages = exportPackages.replaceAll(",\\s*,", ",");
        attributes.putValue("Export-Package", exportPackages);
        String systemCaps = configProps.getProperty("org.osgi.framework.system.capabilities");
        attributes.putValue("Provide-Capability", systemCaps);
        Hashtable<String, String> headers = new Hashtable<String, String>();
        for (Map.Entry entry : attributes.entrySet()) {
            headers.put(entry.getKey().toString(), entry.getValue().toString());
        }
        FakeBundleRevision resource = new FakeBundleRevision(headers, "system-bundle", 0L);
        return resource.getBundle();
    }

    private File resolveDistributionArtifact(String version, String[] dist) throws IOException {
        BiFunction<String, String, String> fallback = (input, fbk) -> input == null || input.trim().isEmpty() ? fbk : input;
        if (dist.length < 3) {
            return this.resolver.resolve(dist[0], dist[1], "", "zip", version);
        }
        if (dist.length < 4) {
            return this.resolver.resolve(dist[0], dist[1], "", fallback.apply(dist[2], "zip"), version);
        }
        if (dist.length < 5) {
            return this.resolver.resolve(dist[0], dist[1], "", fallback.apply(dist[2], "zip"), fallback.apply(dist[3], version));
        }
        if (dist.length == 5) {
            return this.resolver.resolve(dist[0], dist[1], fallback.apply(dist[3], ""), fallback.apply(dist[2], "zip"), fallback.apply(dist[4], version));
        }
        throw new IllegalArgumentException("Invalid distribution uri");
    }

    public Map<String, Features> loadRepositories(DownloadManager manager, Set<String> uris) throws Exception {
        final HashMap<String, Features> loaded = new HashMap<String, Features>();
        final Downloader downloader = manager.createDownloader();
        FeaturesServiceConfig config = null;
        config = this.featureProcessingInstructions != null ? new FeaturesServiceConfig(this.featureProcessingInstructions.toURI().toString(), null) : new FeaturesServiceConfig();
        final FeaturesProcessorImpl processor = new FeaturesProcessorImpl(config);
        if (this.blacklistedDescriptors != null) {
            this.blacklistedDescriptors.forEach(lp -> processor.getInstructions().getBlacklistedRepositoryLocationPatterns().add(new LocationPattern(lp)));
        }
        processor.getInstructions().getBlacklistedRepositoryLocationPatterns().add(new LocationPattern("mvn:" + this.selfGroupId + "/" + this.selfArtifactId));
        for (String repository : uris) {
            if (processor.isRepositoryBlacklisted(repository)) continue;
            downloader.download(repository, new DownloadCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void downloaded(StreamProvider provider) throws Exception {
                    Map map = loaded;
                    synchronized (map) {
                        if (loaded.containsKey(provider.getUrl())) {
                            return;
                        }
                    }
                    try (InputStream is = provider.open();){
                        Features featuresModel = JacksonUtil.isJson((String)provider.getUrl()) ? JacksonUtil.unmarshal((String)provider.getUrl()) : JaxbUtil.unmarshal((String)provider.getUrl(), (InputStream)is, (boolean)false);
                        processor.process(featuresModel);
                        Map map2 = loaded;
                        synchronized (map2) {
                            loaded.put(provider.getUrl(), featuresModel);
                            for (String innerRepository : featuresModel.getRepository()) {
                                if (processor.isRepositoryBlacklisted(innerRepository)) continue;
                                downloader.download(innerRepository, (DownloadCallback)this);
                            }
                        }
                    }
                }
            });
        }
        downloader.await();
        return loaded;
    }

    public static Set<String> getPrefixedProperties(Map<String, String> properties, String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (String key : properties.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String url = properties.get(key);
            if (url == null || url.length() == 0) {
                url = key.substring(prefix.length());
            }
            if (url.isEmpty()) continue;
            result.add(url);
        }
        return result;
    }

    public static Map<String, Map<VersionRange, Map<String, String>>> getMetadata(Map<String, String> properties, String prefix) {
        HashMap<String, Map<VersionRange, Map<String, String>>> result = new HashMap<String, Map<VersionRange, Map<String, String>>>();
        for (String key : properties.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String val = properties.get(key);
            String[] parts = (key = key.substring(prefix.length())).split("#");
            if (parts.length != 3) continue;
            Map ranges = result.computeIfAbsent(parts[0], k -> new HashMap());
            String version = parts[1];
            if (!version.startsWith("[") && !version.startsWith("(")) {
                Processor processor = new Processor();
                processor.setProperty("@", VersionTable.getVersion((String)version).toString());
                Macro macro = new Macro(processor, new Object[0]);
                version = macro.process("${range;[==,=+)}");
            }
            VersionRange range = new VersionRange(version);
            ranges.computeIfAbsent(range, k -> new HashMap()).put(parts[2], val);
        }
        return result;
    }

    public class MavenResolverLog
    extends Logger {
        public MavenResolverLog() {
            super(4);
        }

        protected void doLog(int level, String msg, Throwable throwable) {
            switch (level) {
                case 4: {
                    VerifyMojo.this.getLog().debug((CharSequence)msg, throwable);
                    break;
                }
                case 3: {
                    VerifyMojo.this.getLog().info((CharSequence)msg, throwable);
                    break;
                }
                case 2: {
                    VerifyMojo.this.getLog().warn((CharSequence)msg, throwable);
                    break;
                }
                case 1: {
                    VerifyMojo.this.getLog().error((CharSequence)msg, throwable);
                }
            }
        }
    }

    public static class DummyDeployCallback
    extends StaticInstallSupport
    implements Deployer.DeployCallback {
        private final Bundle systemBundle;
        private final Deployer.DeploymentState dstate;
        private final AtomicLong nextBundleId = new AtomicLong(0L);

        public DummyDeployCallback(Bundle sysBundle, Collection<Features> repositories, boolean failOnUpdate, boolean failOnUninstall) {
            this.failOnUpdate = failOnUpdate;
            this.failOnUninstall = failOnUninstall;
            this.systemBundle = sysBundle;
            this.dstate = new Deployer.DeploymentState();
            this.dstate.bundles = new HashMap();
            this.dstate.bundlesPerRegion = new HashMap();
            this.dstate.filtersPerRegion = new HashMap();
            this.dstate.state = new State();
            MapUtils.addToMapSet((Map)this.dstate.bundlesPerRegion, (Object)"root", (Object)0L);
            this.dstate.bundles.put(0L, this.systemBundle);
            LinkedList<org.apache.karaf.features.internal.model.Feature> features = new LinkedList<org.apache.karaf.features.internal.model.Feature>();
            for (Features repo : repositories) {
                if (repo.isBlacklisted()) continue;
                for (org.apache.karaf.features.internal.model.Feature f : repo.getFeature()) {
                    if (f.isBlacklisted()) continue;
                    features.add(f);
                }
            }
            this.dstate.partitionFeatures(features);
        }

        public Deployer.DeploymentState getDeploymentState() {
            return this.dstate;
        }

        public void saveState(State state) {
            this.dstate.state.replace(state);
        }

        public void persistResolveRequest(Deployer.DeploymentRequest request) {
        }

        public void installConfigs(Feature feature) {
        }

        public void deleteConfigs(Feature feature) throws IOException, InvalidSyntaxException {
        }

        public void installLibraries(Feature feature) {
        }

        public void callListeners(FeatureEvent featureEvent) {
        }

        public void callListeners(DeploymentEvent deployEvent) {
        }

        public Bundle installBundle(String region, String uri, InputStream is) throws BundleException {
            try {
                ZipEntry entry;
                Hashtable<String, String> headers = new Hashtable<String, String>();
                ZipInputStream zis = new ZipInputStream(is);
                while ((entry = zis.getNextEntry()) != null) {
                    if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                    Attributes attributes = new Manifest(zis).getMainAttributes();
                    for (Map.Entry<Object, Object> attr : attributes.entrySet()) {
                        headers.put(attr.getKey().toString(), attr.getValue().toString());
                    }
                }
                FakeBundleRevision revision = new FakeBundleRevision(headers, uri, this.nextBundleId.incrementAndGet());
                Bundle bundle = revision.getBundle();
                MapUtils.addToMapSet((Map)this.dstate.bundlesPerRegion, (Object)region, (Object)bundle.getBundleId());
                this.dstate.bundles.put(bundle.getBundleId(), bundle);
                return bundle;
            }
            catch (IOException e) {
                throw new BundleException("Unable to install bundle", (Throwable)e);
            }
        }

        public void uninstall(Bundle bundle) throws BundleException {
            for (String region : this.dstate.bundlesPerRegion.keySet()) {
                MapUtils.removeFromMapSet((Map)this.dstate.bundlesPerRegion, (Object)region, (Object)bundle.getBundleId());
            }
            this.dstate.bundles.remove(bundle.getBundleId());
        }

        public void bundleBlacklisted(BundleInfo bundleInfo) {
        }
    }

    public static class FakeBundleRevision
    extends ResourceImpl
    implements BundleRevision,
    BundleStartLevel {
        private final Bundle bundle;
        private int startLevel;

        public FakeBundleRevision(final Hashtable<String, String> headers, final String location, final long bundleId) throws BundleException {
            ResourceBuilder.build((ResourceImpl)this, (String)location, headers);
            this.bundle = (Bundle)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{Bundle.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) {
                    switch (method.getName()) {
                        case "hashCode": {
                            return this.hashCode();
                        }
                        case "equals": {
                            return proxy == args[0];
                        }
                        case "toString": {
                            return bundle.getSymbolicName() + "/" + bundle.getVersion();
                        }
                        case "adapt": {
                            if (args.length == 1 && args[0] == BundleRevision.class) {
                                return this;
                            }
                            if (args.length != 1 || args[0] != BundleStartLevel.class) break;
                            return this;
                        }
                        case "getHeaders": {
                            return headers;
                        }
                        case "getBundleId": {
                            return bundleId;
                        }
                        case "getLocation": {
                            return location;
                        }
                        case "getSymbolicName": {
                            String name = (String)headers.get("Bundle-SymbolicName");
                            int idx = name.indexOf(59);
                            if (idx > 0) {
                                name = name.substring(0, idx).trim();
                            }
                            return name;
                        }
                        case "getVersion": {
                            return new org.osgi.framework.Version((String)headers.get("Bundle-Version"));
                        }
                        case "getState": {
                            return 32;
                        }
                        case "getLastModified": {
                            return 0L;
                        }
                    }
                    return null;
                }
            });
        }

        public int getStartLevel() {
            return this.startLevel;
        }

        public void setStartLevel(int startLevel) {
            this.startLevel = startLevel;
        }

        public boolean isPersistentlyStarted() {
            return true;
        }

        public boolean isActivationPolicyUsed() {
            return false;
        }

        public String getSymbolicName() {
            return this.bundle.getSymbolicName();
        }

        public org.osgi.framework.Version getVersion() {
            return this.bundle.getVersion();
        }

        public List<BundleCapability> getDeclaredCapabilities(String namespace) {
            throw new UnsupportedOperationException();
        }

        public List<BundleRequirement> getDeclaredRequirements(String namespace) {
            throw new UnsupportedOperationException();
        }

        public int getTypes() {
            throw new UnsupportedOperationException();
        }

        public BundleWiring getWiring() {
            throw new UnsupportedOperationException();
        }

        public Bundle getBundle() {
            return this.bundle;
        }
    }
}

