/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.MessageFactory2Adapter;
import org.apache.logging.log4j.util.MessageSupplier;
import org.apache.logging.log4j.util.Supplier;
import org.junit.Assert;
import org.junit.Test;

public class AbstractLoggerTest {
    private static final StringBuilder CHAR_SEQ = new StringBuilder("CharSeq");
    private static Throwable t = new UnsupportedOperationException("Test");
    private static Class<AbstractLogger> obj = AbstractLogger.class;
    private static String pattern = "{}, {}";
    private static String p1 = "Long Beach";
    private static String p2 = "California";
    private static Message charSeq = new SimpleMessage((CharSequence)CHAR_SEQ);
    private static Message simple = new SimpleMessage("Hello");
    private static Message object = new ObjectMessage(obj);
    private static Message param = new ParameterizedMessage(pattern, (Object)p1, (Object)p2);
    private static final Marker MARKER = MarkerManager.getMarker((String)"TEST");
    private static final String MARKER_NAME = "TEST";
    private static final LogEvent[] EVENTS = new LogEvent[]{new LogEvent(null, simple, null), new LogEvent("TEST", simple, null), new LogEvent(null, simple, t), new LogEvent("TEST", simple, t), new LogEvent(null, object, null), new LogEvent("TEST", object, null), new LogEvent(null, object, t), new LogEvent("TEST", object, t), new LogEvent(null, param, null), new LogEvent("TEST", param, null), new LogEvent(null, simple, null), new LogEvent(null, simple, t), new LogEvent("TEST", simple, null), new LogEvent("TEST", simple, t), new LogEvent("TEST", simple, null), new LogEvent(null, charSeq, null), new LogEvent(null, charSeq, t), new LogEvent("TEST", charSeq, null), new LogEvent("TEST", charSeq, t)};

    @Test
    public void testDebug() {
        CountingLogger logger = new CountingLogger();
        logger.setCurrentLevel(Level.DEBUG);
        logger.setCurrentEvent(EVENTS[0]);
        logger.debug("Hello");
        logger.debug(null, "Hello");
        logger.setCurrentEvent(EVENTS[1]);
        logger.debug(MARKER, "Hello");
        logger.setCurrentEvent(EVENTS[2]);
        logger.debug("Hello", t);
        logger.debug(null, "Hello", t);
        logger.setCurrentEvent(EVENTS[3]);
        logger.debug(MARKER, "Hello", t);
        logger.setCurrentEvent(EVENTS[4]);
        logger.debug(obj);
        logger.setCurrentEvent(EVENTS[5]);
        logger.debug(MARKER, obj);
        logger.setCurrentEvent(EVENTS[6]);
        logger.debug(obj, t);
        logger.debug(null, obj, t);
        logger.setCurrentEvent(EVENTS[7]);
        logger.debug(MARKER, obj, t);
        logger.setCurrentEvent(EVENTS[8]);
        logger.debug(pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[9]);
        logger.debug(MARKER, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[10]);
        logger.debug(simple);
        logger.debug(null, simple);
        logger.debug(null, simple, null);
        logger.setCurrentEvent(EVENTS[11]);
        logger.debug(simple, t);
        logger.debug(null, simple, t);
        logger.setCurrentEvent(EVENTS[12]);
        logger.debug(MARKER, simple, null);
        logger.setCurrentEvent(EVENTS[13]);
        logger.debug(MARKER, simple, t);
        logger.setCurrentEvent(EVENTS[14]);
        logger.debug(MARKER, simple);
        logger.setCurrentEvent(EVENTS[15]);
        logger.debug(CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[16]);
        logger.debug(CHAR_SEQ, t);
        logger.setCurrentEvent(EVENTS[17]);
        logger.debug(MARKER, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[18]);
        logger.debug(MARKER, CHAR_SEQ, t);
        Assert.assertEquals((String)"log(CharSeq) invocations", (long)4L, (long)logger.getCharSeqCount());
        Assert.assertEquals((String)"log(Object) invocations", (long)5L, (long)logger.getObjectCount());
    }

    @Test
    public void testError() {
        CountingLogger logger = new CountingLogger();
        logger.setCurrentLevel(Level.ERROR);
        logger.setCurrentEvent(EVENTS[0]);
        logger.error("Hello");
        logger.error(null, "Hello");
        logger.setCurrentEvent(EVENTS[1]);
        logger.error(MARKER, "Hello");
        logger.setCurrentEvent(EVENTS[2]);
        logger.error("Hello", t);
        logger.error(null, "Hello", t);
        logger.setCurrentEvent(EVENTS[3]);
        logger.error(MARKER, "Hello", t);
        logger.setCurrentEvent(EVENTS[4]);
        logger.error(obj);
        logger.setCurrentEvent(EVENTS[5]);
        logger.error(MARKER, obj);
        logger.setCurrentEvent(EVENTS[6]);
        logger.error(obj, t);
        logger.error(null, obj, t);
        logger.setCurrentEvent(EVENTS[7]);
        logger.error(MARKER, obj, t);
        logger.setCurrentEvent(EVENTS[8]);
        logger.error(pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[9]);
        logger.error(MARKER, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[10]);
        logger.error(simple);
        logger.error(null, simple);
        logger.error(null, simple, null);
        logger.setCurrentEvent(EVENTS[11]);
        logger.error(simple, t);
        logger.error(null, simple, t);
        logger.setCurrentEvent(EVENTS[12]);
        logger.error(MARKER, simple, null);
        logger.setCurrentEvent(EVENTS[13]);
        logger.error(MARKER, simple, t);
        logger.setCurrentEvent(EVENTS[14]);
        logger.error(MARKER, simple);
        logger.setCurrentEvent(EVENTS[15]);
        logger.error(CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[16]);
        logger.error(CHAR_SEQ, t);
        logger.setCurrentEvent(EVENTS[17]);
        logger.error(MARKER, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[18]);
        logger.error(MARKER, CHAR_SEQ, t);
        Assert.assertEquals((String)"log(CharSeq) invocations", (long)4L, (long)logger.getCharSeqCount());
        Assert.assertEquals((String)"log(Object) invocations", (long)5L, (long)logger.getObjectCount());
    }

    @Test
    public void testFatal() {
        CountingLogger logger = new CountingLogger();
        logger.setCurrentLevel(Level.FATAL);
        logger.setCurrentEvent(EVENTS[0]);
        logger.fatal("Hello");
        logger.fatal(null, "Hello");
        logger.setCurrentEvent(EVENTS[1]);
        logger.fatal(MARKER, "Hello");
        logger.setCurrentEvent(EVENTS[2]);
        logger.fatal("Hello", t);
        logger.fatal(null, "Hello", t);
        logger.setCurrentEvent(EVENTS[3]);
        logger.fatal(MARKER, "Hello", t);
        logger.setCurrentEvent(EVENTS[4]);
        logger.fatal(obj);
        logger.setCurrentEvent(EVENTS[5]);
        logger.fatal(MARKER, obj);
        logger.setCurrentEvent(EVENTS[6]);
        logger.fatal(obj, t);
        logger.fatal(null, obj, t);
        logger.setCurrentEvent(EVENTS[7]);
        logger.fatal(MARKER, obj, t);
        logger.setCurrentEvent(EVENTS[8]);
        logger.fatal(pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[9]);
        logger.fatal(MARKER, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[10]);
        logger.fatal(simple);
        logger.fatal(null, simple);
        logger.fatal(null, simple, null);
        logger.setCurrentEvent(EVENTS[11]);
        logger.fatal(simple, t);
        logger.fatal(null, simple, t);
        logger.setCurrentEvent(EVENTS[12]);
        logger.fatal(MARKER, simple, null);
        logger.setCurrentEvent(EVENTS[13]);
        logger.fatal(MARKER, simple, t);
        logger.setCurrentEvent(EVENTS[14]);
        logger.fatal(MARKER, simple);
        logger.setCurrentEvent(EVENTS[15]);
        logger.fatal(CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[16]);
        logger.fatal(CHAR_SEQ, t);
        logger.setCurrentEvent(EVENTS[17]);
        logger.fatal(MARKER, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[18]);
        logger.fatal(MARKER, CHAR_SEQ, t);
        Assert.assertEquals((String)"log(CharSeq) invocations", (long)4L, (long)logger.getCharSeqCount());
        Assert.assertEquals((String)"log(Object) invocations", (long)5L, (long)logger.getObjectCount());
    }

    @Test
    public void testInfo() {
        CountingLogger logger = new CountingLogger();
        logger.setCurrentLevel(Level.INFO);
        logger.setCurrentEvent(EVENTS[0]);
        logger.info("Hello");
        logger.info(null, "Hello");
        logger.setCurrentEvent(EVENTS[1]);
        logger.info(MARKER, "Hello");
        logger.setCurrentEvent(EVENTS[2]);
        logger.info("Hello", t);
        logger.info(null, "Hello", t);
        logger.setCurrentEvent(EVENTS[3]);
        logger.info(MARKER, "Hello", t);
        logger.setCurrentEvent(EVENTS[4]);
        logger.info(obj);
        logger.setCurrentEvent(EVENTS[5]);
        logger.info(MARKER, obj);
        logger.setCurrentEvent(EVENTS[6]);
        logger.info(obj, t);
        logger.info(null, obj, t);
        logger.setCurrentEvent(EVENTS[7]);
        logger.info(MARKER, obj, t);
        logger.setCurrentEvent(EVENTS[8]);
        logger.info(pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[9]);
        logger.info(MARKER, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[10]);
        logger.info(simple);
        logger.info(null, simple);
        logger.info(null, simple, null);
        logger.setCurrentEvent(EVENTS[11]);
        logger.info(simple, t);
        logger.info(null, simple, t);
        logger.setCurrentEvent(EVENTS[12]);
        logger.info(MARKER, simple, null);
        logger.setCurrentEvent(EVENTS[13]);
        logger.info(MARKER, simple, t);
        logger.setCurrentEvent(EVENTS[14]);
        logger.info(MARKER, simple);
        logger.setCurrentEvent(EVENTS[15]);
        logger.info(CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[16]);
        logger.info(CHAR_SEQ, t);
        logger.setCurrentEvent(EVENTS[17]);
        logger.info(MARKER, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[18]);
        logger.info(MARKER, CHAR_SEQ, t);
        Assert.assertEquals((String)"log(CharSeq) invocations", (long)4L, (long)logger.getCharSeqCount());
        Assert.assertEquals((String)"log(Object) invocations", (long)5L, (long)logger.getObjectCount());
    }

    @Test
    public void testLogDebug() {
        CountingLogger logger = new CountingLogger();
        logger.setCurrentLevel(Level.DEBUG);
        logger.setCurrentEvent(EVENTS[0]);
        logger.log(Level.DEBUG, "Hello");
        logger.log(Level.DEBUG, null, "Hello");
        logger.setCurrentEvent(EVENTS[1]);
        logger.log(Level.DEBUG, MARKER, "Hello");
        logger.setCurrentEvent(EVENTS[2]);
        logger.log(Level.DEBUG, "Hello", t);
        logger.log(Level.DEBUG, null, "Hello", t);
        logger.setCurrentEvent(EVENTS[3]);
        logger.log(Level.DEBUG, MARKER, "Hello", t);
        logger.setCurrentEvent(EVENTS[4]);
        logger.log(Level.DEBUG, obj);
        logger.setCurrentEvent(EVENTS[5]);
        logger.log(Level.DEBUG, MARKER, obj);
        logger.setCurrentEvent(EVENTS[6]);
        logger.log(Level.DEBUG, obj, t);
        logger.log(Level.DEBUG, null, obj, t);
        logger.setCurrentEvent(EVENTS[7]);
        logger.log(Level.DEBUG, MARKER, obj, t);
        logger.setCurrentEvent(EVENTS[8]);
        logger.log(Level.DEBUG, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[9]);
        logger.log(Level.DEBUG, MARKER, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[10]);
        logger.log(Level.DEBUG, simple);
        logger.log(Level.DEBUG, null, simple);
        logger.log(Level.DEBUG, null, simple, null);
        logger.setCurrentEvent(EVENTS[11]);
        logger.log(Level.DEBUG, simple, t);
        logger.log(Level.DEBUG, null, simple, t);
        logger.setCurrentEvent(EVENTS[12]);
        logger.log(Level.DEBUG, MARKER, simple, null);
        logger.setCurrentEvent(EVENTS[13]);
        logger.log(Level.DEBUG, MARKER, simple, t);
        logger.setCurrentEvent(EVENTS[14]);
        logger.log(Level.DEBUG, MARKER, simple);
        logger.setCurrentEvent(EVENTS[15]);
        logger.log(Level.DEBUG, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[16]);
        logger.log(Level.DEBUG, CHAR_SEQ, t);
        logger.setCurrentEvent(EVENTS[17]);
        logger.log(Level.DEBUG, MARKER, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[18]);
        logger.log(Level.DEBUG, MARKER, CHAR_SEQ, t);
        Assert.assertEquals((String)"log(CharSeq) invocations", (long)4L, (long)logger.getCharSeqCount());
        Assert.assertEquals((String)"log(Object) invocations", (long)5L, (long)logger.getObjectCount());
    }

    @Test
    public void testLogError() {
        CountingLogger logger = new CountingLogger();
        logger.setCurrentLevel(Level.ERROR);
        logger.setCurrentEvent(EVENTS[0]);
        logger.log(Level.ERROR, "Hello");
        logger.log(Level.ERROR, null, "Hello");
        logger.setCurrentEvent(EVENTS[1]);
        logger.log(Level.ERROR, MARKER, "Hello");
        logger.setCurrentEvent(EVENTS[2]);
        logger.log(Level.ERROR, "Hello", t);
        logger.log(Level.ERROR, null, "Hello", t);
        logger.setCurrentEvent(EVENTS[3]);
        logger.log(Level.ERROR, MARKER, "Hello", t);
        logger.setCurrentEvent(EVENTS[4]);
        logger.log(Level.ERROR, obj);
        logger.setCurrentEvent(EVENTS[5]);
        logger.log(Level.ERROR, MARKER, obj);
        logger.setCurrentEvent(EVENTS[6]);
        logger.log(Level.ERROR, obj, t);
        logger.log(Level.ERROR, null, obj, t);
        logger.setCurrentEvent(EVENTS[7]);
        logger.log(Level.ERROR, MARKER, obj, t);
        logger.setCurrentEvent(EVENTS[8]);
        logger.log(Level.ERROR, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[9]);
        logger.log(Level.ERROR, MARKER, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[10]);
        logger.log(Level.ERROR, simple);
        logger.log(Level.ERROR, null, simple);
        logger.log(Level.ERROR, null, simple, null);
        logger.setCurrentEvent(EVENTS[11]);
        logger.log(Level.ERROR, simple, t);
        logger.log(Level.ERROR, null, simple, t);
        logger.setCurrentEvent(EVENTS[12]);
        logger.log(Level.ERROR, MARKER, simple, null);
        logger.setCurrentEvent(EVENTS[13]);
        logger.log(Level.ERROR, MARKER, simple, t);
        logger.setCurrentEvent(EVENTS[14]);
        logger.log(Level.ERROR, MARKER, simple);
        logger.setCurrentEvent(EVENTS[15]);
        logger.log(Level.ERROR, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[16]);
        logger.log(Level.ERROR, CHAR_SEQ, t);
        logger.setCurrentEvent(EVENTS[17]);
        logger.log(Level.ERROR, MARKER, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[18]);
        logger.log(Level.ERROR, MARKER, CHAR_SEQ, t);
        Assert.assertEquals((String)"log(CharSeq) invocations", (long)4L, (long)logger.getCharSeqCount());
        Assert.assertEquals((String)"log(Object) invocations", (long)5L, (long)logger.getObjectCount());
    }

    @Test
    public void testLogFatal() {
        CountingLogger logger = new CountingLogger();
        logger.setCurrentLevel(Level.FATAL);
        logger.setCurrentEvent(EVENTS[0]);
        logger.log(Level.FATAL, "Hello");
        logger.log(Level.FATAL, null, "Hello");
        logger.setCurrentEvent(EVENTS[1]);
        logger.log(Level.FATAL, MARKER, "Hello");
        logger.setCurrentEvent(EVENTS[2]);
        logger.log(Level.FATAL, "Hello", t);
        logger.log(Level.FATAL, null, "Hello", t);
        logger.setCurrentEvent(EVENTS[3]);
        logger.log(Level.FATAL, MARKER, "Hello", t);
        logger.setCurrentEvent(EVENTS[4]);
        logger.log(Level.FATAL, obj);
        logger.setCurrentEvent(EVENTS[5]);
        logger.log(Level.FATAL, MARKER, obj);
        logger.setCurrentEvent(EVENTS[6]);
        logger.log(Level.FATAL, obj, t);
        logger.log(Level.FATAL, null, obj, t);
        logger.setCurrentEvent(EVENTS[7]);
        logger.log(Level.FATAL, MARKER, obj, t);
        logger.setCurrentEvent(EVENTS[8]);
        logger.log(Level.FATAL, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[9]);
        logger.log(Level.FATAL, MARKER, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[10]);
        logger.log(Level.FATAL, simple);
        logger.log(Level.FATAL, null, simple);
        logger.log(Level.FATAL, null, simple, null);
        logger.setCurrentEvent(EVENTS[11]);
        logger.log(Level.FATAL, simple, t);
        logger.log(Level.FATAL, null, simple, t);
        logger.setCurrentEvent(EVENTS[12]);
        logger.log(Level.FATAL, MARKER, simple, null);
        logger.setCurrentEvent(EVENTS[13]);
        logger.log(Level.FATAL, MARKER, simple, t);
        logger.setCurrentEvent(EVENTS[14]);
        logger.log(Level.FATAL, MARKER, simple);
        logger.setCurrentEvent(EVENTS[15]);
        logger.log(Level.FATAL, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[16]);
        logger.log(Level.FATAL, CHAR_SEQ, t);
        logger.setCurrentEvent(EVENTS[17]);
        logger.log(Level.FATAL, MARKER, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[18]);
        logger.log(Level.FATAL, MARKER, CHAR_SEQ, t);
        Assert.assertEquals((String)"log(CharSeq) invocations", (long)4L, (long)logger.getCharSeqCount());
        Assert.assertEquals((String)"log(Object) invocations", (long)5L, (long)logger.getObjectCount());
    }

    @Test
    public void testLogInfo() {
        CountingLogger logger = new CountingLogger();
        logger.setCurrentLevel(Level.INFO);
        logger.setCurrentEvent(EVENTS[0]);
        logger.log(Level.INFO, "Hello");
        logger.log(Level.INFO, null, "Hello");
        logger.setCurrentEvent(EVENTS[1]);
        logger.log(Level.INFO, MARKER, "Hello");
        logger.setCurrentEvent(EVENTS[2]);
        logger.log(Level.INFO, "Hello", t);
        logger.log(Level.INFO, null, "Hello", t);
        logger.setCurrentEvent(EVENTS[3]);
        logger.log(Level.INFO, MARKER, "Hello", t);
        logger.setCurrentEvent(EVENTS[4]);
        logger.log(Level.INFO, obj);
        logger.setCurrentEvent(EVENTS[5]);
        logger.log(Level.INFO, MARKER, obj);
        logger.setCurrentEvent(EVENTS[6]);
        logger.log(Level.INFO, obj, t);
        logger.log(Level.INFO, null, obj, t);
        logger.setCurrentEvent(EVENTS[7]);
        logger.log(Level.INFO, MARKER, obj, t);
        logger.setCurrentEvent(EVENTS[8]);
        logger.log(Level.INFO, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[9]);
        logger.log(Level.INFO, MARKER, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[10]);
        logger.log(Level.INFO, simple);
        logger.log(Level.INFO, null, simple);
        logger.log(Level.INFO, null, simple, null);
        logger.setCurrentEvent(EVENTS[11]);
        logger.log(Level.INFO, simple, t);
        logger.log(Level.INFO, null, simple, t);
        logger.setCurrentEvent(EVENTS[12]);
        logger.log(Level.INFO, MARKER, simple, null);
        logger.setCurrentEvent(EVENTS[13]);
        logger.log(Level.INFO, MARKER, simple, t);
        logger.setCurrentEvent(EVENTS[14]);
        logger.log(Level.INFO, MARKER, simple);
        logger.setCurrentEvent(EVENTS[15]);
        logger.log(Level.INFO, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[16]);
        logger.log(Level.INFO, CHAR_SEQ, t);
        logger.setCurrentEvent(EVENTS[17]);
        logger.log(Level.INFO, MARKER, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[18]);
        logger.log(Level.INFO, MARKER, CHAR_SEQ, t);
        Assert.assertEquals((String)"log(CharSeq) invocations", (long)4L, (long)logger.getCharSeqCount());
        Assert.assertEquals((String)"log(Object) invocations", (long)5L, (long)logger.getObjectCount());
    }

    @Test
    public void testLogTrace() {
        CountingLogger logger = new CountingLogger();
        logger.setCurrentLevel(Level.TRACE);
        logger.setCurrentEvent(EVENTS[0]);
        logger.log(Level.TRACE, "Hello");
        logger.log(Level.TRACE, null, "Hello");
        logger.setCurrentEvent(EVENTS[1]);
        logger.log(Level.TRACE, MARKER, "Hello");
        logger.setCurrentEvent(EVENTS[2]);
        logger.log(Level.TRACE, "Hello", t);
        logger.log(Level.TRACE, null, "Hello", t);
        logger.setCurrentEvent(EVENTS[3]);
        logger.log(Level.TRACE, MARKER, "Hello", t);
        logger.setCurrentEvent(EVENTS[4]);
        logger.log(Level.TRACE, obj);
        logger.setCurrentEvent(EVENTS[5]);
        logger.log(Level.TRACE, MARKER, obj);
        logger.setCurrentEvent(EVENTS[6]);
        logger.log(Level.TRACE, obj, t);
        logger.log(Level.TRACE, null, obj, t);
        logger.setCurrentEvent(EVENTS[7]);
        logger.log(Level.TRACE, MARKER, obj, t);
        logger.setCurrentEvent(EVENTS[8]);
        logger.log(Level.TRACE, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[9]);
        logger.log(Level.TRACE, MARKER, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[10]);
        logger.log(Level.TRACE, simple);
        logger.log(Level.TRACE, null, simple);
        logger.log(Level.TRACE, null, simple, null);
        logger.setCurrentEvent(EVENTS[11]);
        logger.log(Level.TRACE, simple, t);
        logger.log(Level.TRACE, null, simple, t);
        logger.setCurrentEvent(EVENTS[12]);
        logger.log(Level.TRACE, MARKER, simple, null);
        logger.setCurrentEvent(EVENTS[13]);
        logger.log(Level.TRACE, MARKER, simple, t);
        logger.setCurrentEvent(EVENTS[14]);
        logger.log(Level.TRACE, MARKER, simple);
        logger.setCurrentEvent(EVENTS[15]);
        logger.log(Level.TRACE, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[16]);
        logger.log(Level.TRACE, CHAR_SEQ, t);
        logger.setCurrentEvent(EVENTS[17]);
        logger.log(Level.TRACE, MARKER, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[18]);
        logger.log(Level.TRACE, MARKER, CHAR_SEQ, t);
        Assert.assertEquals((String)"log(CharSeq) invocations", (long)4L, (long)logger.getCharSeqCount());
        Assert.assertEquals((String)"log(Object) invocations", (long)5L, (long)logger.getObjectCount());
    }

    @Test
    public void testLogWarn() {
        CountingLogger logger = new CountingLogger();
        logger.setCurrentLevel(Level.WARN);
        logger.setCurrentEvent(EVENTS[0]);
        logger.log(Level.WARN, "Hello");
        logger.log(Level.WARN, null, "Hello");
        logger.setCurrentEvent(EVENTS[1]);
        logger.log(Level.WARN, MARKER, "Hello");
        logger.setCurrentEvent(EVENTS[2]);
        logger.log(Level.WARN, "Hello", t);
        logger.log(Level.WARN, null, "Hello", t);
        logger.setCurrentEvent(EVENTS[3]);
        logger.log(Level.WARN, MARKER, "Hello", t);
        logger.setCurrentEvent(EVENTS[4]);
        logger.log(Level.WARN, obj);
        logger.setCurrentEvent(EVENTS[5]);
        logger.log(Level.WARN, MARKER, obj);
        logger.setCurrentEvent(EVENTS[6]);
        logger.log(Level.WARN, obj, t);
        logger.log(Level.WARN, null, obj, t);
        logger.setCurrentEvent(EVENTS[7]);
        logger.log(Level.WARN, MARKER, obj, t);
        logger.setCurrentEvent(EVENTS[8]);
        logger.log(Level.WARN, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[9]);
        logger.log(Level.WARN, MARKER, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[10]);
        logger.log(Level.WARN, simple);
        logger.log(Level.WARN, null, simple);
        logger.log(Level.WARN, null, simple, null);
        logger.setCurrentEvent(EVENTS[11]);
        logger.log(Level.WARN, simple, t);
        logger.log(Level.WARN, null, simple, t);
        logger.setCurrentEvent(EVENTS[12]);
        logger.log(Level.WARN, MARKER, simple, null);
        logger.setCurrentEvent(EVENTS[13]);
        logger.log(Level.WARN, MARKER, simple, t);
        logger.setCurrentEvent(EVENTS[14]);
        logger.log(Level.WARN, MARKER, simple);
        logger.setCurrentEvent(EVENTS[15]);
        logger.log(Level.WARN, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[16]);
        logger.log(Level.WARN, CHAR_SEQ, t);
        logger.setCurrentEvent(EVENTS[17]);
        logger.log(Level.WARN, MARKER, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[18]);
        logger.log(Level.WARN, MARKER, CHAR_SEQ, t);
        Assert.assertEquals((String)"log(CharSeq) invocations", (long)4L, (long)logger.getCharSeqCount());
        Assert.assertEquals((String)"log(Object) invocations", (long)5L, (long)logger.getObjectCount());
    }

    @Test
    public void testTrace() {
        CountingLogger logger = new CountingLogger();
        logger.setCurrentLevel(Level.TRACE);
        logger.setCurrentEvent(EVENTS[0]);
        logger.trace("Hello");
        logger.trace(null, "Hello");
        logger.setCurrentEvent(EVENTS[1]);
        logger.trace(MARKER, "Hello");
        logger.setCurrentEvent(EVENTS[2]);
        logger.trace("Hello", t);
        logger.trace(null, "Hello", t);
        logger.setCurrentEvent(EVENTS[3]);
        logger.trace(MARKER, "Hello", t);
        logger.setCurrentEvent(EVENTS[4]);
        logger.trace(obj);
        logger.setCurrentEvent(EVENTS[5]);
        logger.trace(MARKER, obj);
        logger.setCurrentEvent(EVENTS[6]);
        logger.trace(obj, t);
        logger.trace(null, obj, t);
        logger.setCurrentEvent(EVENTS[7]);
        logger.trace(MARKER, obj, t);
        logger.setCurrentEvent(EVENTS[8]);
        logger.trace(pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[9]);
        logger.trace(MARKER, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[10]);
        logger.trace(simple);
        logger.trace(null, simple);
        logger.trace(null, simple, null);
        logger.setCurrentEvent(EVENTS[11]);
        logger.trace(simple, t);
        logger.trace(null, simple, t);
        logger.setCurrentEvent(EVENTS[12]);
        logger.trace(MARKER, simple, null);
        logger.setCurrentEvent(EVENTS[13]);
        logger.trace(MARKER, simple, t);
        logger.setCurrentEvent(EVENTS[14]);
        logger.trace(MARKER, simple);
        logger.setCurrentEvent(EVENTS[15]);
        logger.trace(CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[16]);
        logger.trace(CHAR_SEQ, t);
        logger.setCurrentEvent(EVENTS[17]);
        logger.trace(MARKER, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[18]);
        logger.trace(MARKER, CHAR_SEQ, t);
        Assert.assertEquals((String)"log(CharSeq) invocations", (long)4L, (long)logger.getCharSeqCount());
        Assert.assertEquals((String)"log(Object) invocations", (long)5L, (long)logger.getObjectCount());
    }

    @Test
    public void testWarn() {
        CountingLogger logger = new CountingLogger();
        logger.setCurrentLevel(Level.WARN);
        logger.setCurrentEvent(EVENTS[0]);
        logger.warn("Hello");
        logger.warn(null, "Hello");
        logger.setCurrentEvent(EVENTS[1]);
        logger.warn(MARKER, "Hello");
        logger.setCurrentEvent(EVENTS[2]);
        logger.warn("Hello", t);
        logger.warn(null, "Hello", t);
        logger.setCurrentEvent(EVENTS[3]);
        logger.warn(MARKER, "Hello", t);
        logger.setCurrentEvent(EVENTS[4]);
        logger.warn(obj);
        logger.setCurrentEvent(EVENTS[5]);
        logger.warn(MARKER, obj);
        logger.setCurrentEvent(EVENTS[6]);
        logger.warn(obj, t);
        logger.warn(null, obj, t);
        logger.setCurrentEvent(EVENTS[7]);
        logger.warn(MARKER, obj, t);
        logger.setCurrentEvent(EVENTS[8]);
        logger.warn(pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[9]);
        logger.warn(MARKER, pattern, p1, p2);
        logger.setCurrentEvent(EVENTS[10]);
        logger.warn(simple);
        logger.warn(null, simple);
        logger.warn(null, simple, null);
        logger.setCurrentEvent(EVENTS[11]);
        logger.warn(simple, t);
        logger.warn(null, simple, t);
        logger.setCurrentEvent(EVENTS[12]);
        logger.warn(MARKER, simple, null);
        logger.setCurrentEvent(EVENTS[13]);
        logger.warn(MARKER, simple, t);
        logger.setCurrentEvent(EVENTS[14]);
        logger.warn(MARKER, simple);
        logger.setCurrentEvent(EVENTS[15]);
        logger.warn(CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[16]);
        logger.warn(CHAR_SEQ, t);
        logger.setCurrentEvent(EVENTS[17]);
        logger.warn(MARKER, CHAR_SEQ);
        logger.setCurrentEvent(EVENTS[18]);
        logger.warn(MARKER, CHAR_SEQ, t);
        Assert.assertEquals((String)"log(CharSeq) invocations", (long)4L, (long)logger.getCharSeqCount());
        Assert.assertEquals((String)"log(Object) invocations", (long)5L, (long)logger.getObjectCount());
    }

    @Test
    public void testMessageWithThrowable() {
        ThrowableExpectingLogger logger = new ThrowableExpectingLogger(true);
        ThrowableMessage message = new ThrowableMessage(t);
        logger.debug(message);
        logger.error(message);
        logger.fatal(message);
        logger.info(message);
        logger.trace(message);
        logger.warn(message);
        logger.log(Level.INFO, message);
        logger.debug(MARKER, message);
        logger.error(MARKER, message);
        logger.fatal(MARKER, message);
        logger.info(MARKER, message);
        logger.trace(MARKER, message);
        logger.warn(MARKER, message);
        logger.log(Level.INFO, MARKER, message);
    }

    @Test
    public void testMessageWithoutThrowable() {
        ThrowableExpectingLogger logger = new ThrowableExpectingLogger(false);
        ThrowableMessage message = new ThrowableMessage(null);
        logger.debug(message);
        logger.error(message);
        logger.fatal(message);
        logger.info(message);
        logger.trace(message);
        logger.warn(message);
        logger.log(Level.INFO, message);
        logger.debug(MARKER, message);
        logger.error(MARKER, message);
        logger.fatal(MARKER, message);
        logger.info(MARKER, message);
        logger.trace(MARKER, message);
        logger.warn(MARKER, message);
        logger.log(Level.INFO, MARKER, message);
    }

    @Test
    public void testMessageSupplierWithThrowable() {
        ThrowableExpectingLogger logger = new ThrowableExpectingLogger(true);
        final ThrowableMessage message = new ThrowableMessage(t);
        MessageSupplier supplier = new MessageSupplier(){

            public Message get() {
                return message;
            }
        };
        logger.debug(supplier);
        logger.error(supplier);
        logger.fatal(supplier);
        logger.info(supplier);
        logger.trace(supplier);
        logger.warn(supplier);
        logger.log(Level.INFO, supplier);
        logger.debug(MARKER, supplier);
        logger.error(MARKER, supplier);
        logger.fatal(MARKER, supplier);
        logger.info(MARKER, supplier);
        logger.trace(MARKER, supplier);
        logger.warn(MARKER, supplier);
        logger.log(Level.INFO, MARKER, supplier);
    }

    @Test
    public void testMessageSupplierWithoutThrowable() {
        ThrowableExpectingLogger logger = new ThrowableExpectingLogger(false);
        final ThrowableMessage message = new ThrowableMessage(null);
        MessageSupplier supplier = new MessageSupplier(){

            public Message get() {
                return message;
            }
        };
        logger.debug(supplier);
        logger.error(supplier);
        logger.fatal(supplier);
        logger.info(supplier);
        logger.trace(supplier);
        logger.warn(supplier);
        logger.log(Level.INFO, supplier);
        logger.debug(MARKER, supplier);
        logger.error(MARKER, supplier);
        logger.fatal(MARKER, supplier);
        logger.info(MARKER, supplier);
        logger.trace(MARKER, supplier);
        logger.warn(MARKER, supplier);
        logger.log(Level.INFO, MARKER, supplier);
    }

    @Test
    public void testSupplierWithThrowable() {
        ThrowableExpectingLogger logger = new ThrowableExpectingLogger(true);
        final ThrowableMessage message = new ThrowableMessage(t);
        Supplier<Message> supplier = new Supplier<Message>(){

            public Message get() {
                return message;
            }
        };
        logger.debug((Supplier)supplier);
        logger.error((Supplier)supplier);
        logger.fatal((Supplier)supplier);
        logger.info((Supplier)supplier);
        logger.trace((Supplier)supplier);
        logger.warn((Supplier)supplier);
        logger.log(Level.INFO, (Supplier)supplier);
        logger.debug(MARKER, (Supplier)supplier);
        logger.error(MARKER, (Supplier)supplier);
        logger.fatal(MARKER, (Supplier)supplier);
        logger.info(MARKER, (Supplier)supplier);
        logger.trace(MARKER, (Supplier)supplier);
        logger.warn(MARKER, (Supplier)supplier);
        logger.log(Level.INFO, MARKER, (Supplier)supplier);
    }

    @Test
    public void testSupplierWithoutThrowable() {
        ThrowableExpectingLogger logger = new ThrowableExpectingLogger(false);
        final ThrowableMessage message = new ThrowableMessage(null);
        Supplier<Message> supplier = new Supplier<Message>(){

            public Message get() {
                return message;
            }
        };
        logger.debug((Supplier)supplier);
        logger.error((Supplier)supplier);
        logger.fatal((Supplier)supplier);
        logger.info((Supplier)supplier);
        logger.trace((Supplier)supplier);
        logger.warn((Supplier)supplier);
        logger.log(Level.INFO, (Supplier)supplier);
        logger.debug(MARKER, (Supplier)supplier);
        logger.error(MARKER, (Supplier)supplier);
        logger.fatal(MARKER, (Supplier)supplier);
        logger.info(MARKER, (Supplier)supplier);
        logger.trace(MARKER, (Supplier)supplier);
        logger.warn(MARKER, (Supplier)supplier);
        logger.log(Level.INFO, MARKER, (Supplier)supplier);
    }

    private static class ThrowableMessage
    implements Message {
        private static final long serialVersionUID = 1L;
        private final Throwable throwable;

        public ThrowableMessage(Throwable throwable) {
            this.throwable = throwable;
        }

        public String getFormattedMessage() {
            return null;
        }

        public String getFormat() {
            return null;
        }

        public Object[] getParameters() {
            return new Object[0];
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    private static class ThrowableExpectingLogger
    extends AbstractLogger {
        private static final long serialVersionUID = -7218195998038685039L;
        private final boolean expectingThrowables;

        ThrowableExpectingLogger(boolean expectingThrowables) {
            super("ThrowableExpectingLogger", (MessageFactory)new MessageFactory2Adapter((MessageFactory)ParameterizedMessageFactory.INSTANCE));
            this.expectingThrowables = expectingThrowables;
        }

        public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable t) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
            return true;
        }

        public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
            if (this.expectingThrowables) {
                Assert.assertNotNull((String)"Expected a Throwable but received null!", (Object)t);
            } else {
                Assert.assertNull((String)("Expected null but received a Throwable! " + t), (Object)t);
            }
        }

        public Level getLevel() {
            return Level.INFO;
        }
    }

    private static class LogEvent {
        String markerName;
        Message data;
        Throwable t;

        public LogEvent(String markerName, Message data, Throwable t) {
            this.markerName = markerName;
            this.data = data;
            this.t = t;
        }
    }

    private static class CountingLogger
    extends AbstractLogger {
        private static final long serialVersionUID = -3171452617952475480L;
        private Level currentLevel;
        private LogEvent currentEvent;
        private int charSeqCount;
        private int objectCount;

        CountingLogger() {
            super("CountingLogger", (MessageFactory)new MessageFactory2Adapter((MessageFactory)ParameterizedMessageFactory.INSTANCE));
        }

        void setCurrentLevel(Level currentLevel) {
            this.currentLevel = currentLevel;
        }

        void setCurrentEvent(LogEvent currentEvent) {
            this.currentEvent = currentEvent;
        }

        int getCharSeqCount() {
            return this.charSeqCount;
        }

        int getObjectCount() {
            return this.objectCount;
        }

        public Level getLevel() {
            return this.currentLevel;
        }

        public boolean isEnabled(Level level, Marker marker, Message data, Throwable t) {
            Assert.assertTrue((String)("Incorrect Level. Expected " + this.currentLevel + ", actual " + level), (boolean)level.equals((Object)this.currentLevel));
            if (marker == null) {
                if (this.currentEvent.markerName != null) {
                    Assert.fail((String)("Incorrect marker. Expected " + this.currentEvent.markerName + ", actual is null"));
                }
            } else if (this.currentEvent.markerName == null) {
                Assert.fail((String)("Incorrect marker. Expected null. Actual is " + marker.getName()));
            } else {
                Assert.assertTrue((String)("Incorrect marker. Expected " + this.currentEvent.markerName + ", actual " + marker.getName()), (boolean)this.currentEvent.markerName.equals(marker.getName()));
            }
            if (data == null) {
                if (this.currentEvent.data != null) {
                    Assert.fail((String)("Incorrect message. Expected " + this.currentEvent.data + ", actual is null"));
                }
            } else if (this.currentEvent.data == null) {
                Assert.fail((String)("Incorrect message. Expected null. Actual is " + data.getFormattedMessage()));
            } else {
                Assert.assertTrue((String)("Incorrect message type. Expected " + this.currentEvent.data + ", actual " + data), (boolean)data.getClass().isAssignableFrom(this.currentEvent.data.getClass()));
                Assert.assertTrue((String)("Incorrect message. Expected " + this.currentEvent.data.getFormattedMessage() + ", actual " + data.getFormattedMessage()), (boolean)this.currentEvent.data.getFormattedMessage().equals(data.getFormattedMessage()));
            }
            if (t == null) {
                if (this.currentEvent.t != null) {
                    Assert.fail((String)("Incorrect Throwable. Expected " + this.currentEvent.t + ", actual is null"));
                }
            } else if (this.currentEvent.t == null) {
                Assert.fail((String)("Incorrect Throwable. Expected null. Actual is " + t));
            } else {
                Assert.assertTrue((String)("Incorrect Throwable. Expected " + this.currentEvent.t + ", actual " + t), (boolean)this.currentEvent.t.equals(t));
            }
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, CharSequence data, Throwable t) {
            ++this.charSeqCount;
            return this.isEnabled(level, marker, (Message)new SimpleMessage(data), t);
        }

        public boolean isEnabled(Level level, Marker marker, Object data, Throwable t) {
            ++this.objectCount;
            return this.isEnabled(level, marker, (Message)new ObjectMessage(data), t);
        }

        public boolean isEnabled(Level level, Marker marker, String data) {
            return this.isEnabled(level, marker, (Message)new SimpleMessage(data), (Throwable)null);
        }

        public boolean isEnabled(Level level, Marker marker, String data, Object ... p1) {
            return this.isEnabled(level, marker, (Message)new ParameterizedMessage(data, p1), (Throwable)null);
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
            return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, p0), (Throwable)null);
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
            return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, p0, p1), (Throwable)null);
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
            return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2}), (Throwable)null);
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
            return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3}), (Throwable)null);
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
            return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3, p4}), (Throwable)null);
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
            return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3, p4, p5}), (Throwable)null);
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
            return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3, p4, p5, p6}), (Throwable)null);
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
            return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3, p4, p5, p6, p7}), (Throwable)null);
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
            return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3, p4, p5, p6, p7, p8}), (Throwable)null);
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
            return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3, p4, p5, p6, p7, p8, p9}), (Throwable)null);
        }

        public boolean isEnabled(Level level, Marker marker, String data, Throwable t) {
            return this.isEnabled(level, marker, (Message)new SimpleMessage(data), t);
        }

        public void logMessage(String fqcn, Level level, Marker marker, Message data, Throwable t) {
            Assert.assertTrue((String)("Incorrect Level. Expected " + this.currentLevel + ", actual " + level), (boolean)level.equals((Object)this.currentLevel));
            if (marker == null) {
                if (this.currentEvent.markerName != null) {
                    Assert.fail((String)("Incorrect marker. Expected " + this.currentEvent.markerName + ", actual is null"));
                }
            } else if (this.currentEvent.markerName == null) {
                Assert.fail((String)("Incorrect marker. Expected null. Actual is " + marker.getName()));
            } else {
                Assert.assertTrue((String)("Incorrect marker. Expected " + this.currentEvent.markerName + ", actual " + marker.getName()), (boolean)this.currentEvent.markerName.equals(marker.getName()));
            }
            if (data == null) {
                if (this.currentEvent.data != null) {
                    Assert.fail((String)("Incorrect message. Expected " + this.currentEvent.data + ", actual is null"));
                }
            } else if (this.currentEvent.data == null) {
                Assert.fail((String)("Incorrect message. Expected null. Actual is " + data.getFormattedMessage()));
            } else {
                Assert.assertTrue((String)("Incorrect message type. Expected " + this.currentEvent.data + ", actual " + data), (boolean)data.getClass().isAssignableFrom(this.currentEvent.data.getClass()));
                Assert.assertTrue((String)("Incorrect message. Expected " + this.currentEvent.data.getFormattedMessage() + ", actual " + data.getFormattedMessage()), (boolean)this.currentEvent.data.getFormattedMessage().equals(data.getFormattedMessage()));
            }
            if (t == null) {
                if (this.currentEvent.t != null) {
                    Assert.fail((String)("Incorrect Throwable. Expected " + this.currentEvent.t + ", actual is null"));
                }
            } else if (this.currentEvent.t == null) {
                Assert.fail((String)("Incorrect Throwable. Expected null. Actual is " + t));
            } else {
                Assert.assertTrue((String)("Incorrect Throwable. Expected " + this.currentEvent.t + ", actual " + t), (boolean)this.currentEvent.t.equals(t));
            }
        }
    }
}

