/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.util.PropertySource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PropertySourceTokenizerTest {
    private final CharSequence value;
    private final List<CharSequence> expectedTokens;

    public PropertySourceTokenizerTest(CharSequence value, List<CharSequence> expectedTokens) {
        this.value = value;
        this.expectedTokens = expectedTokens;
    }

    @Parameterized.Parameters(name="{0}")
    public static Object[][] data() {
        return new Object[][]{{"log4j.simple", Collections.singletonList("simple")}, {"log4j_simple", Collections.singletonList("simple")}, {"log4j-simple", Collections.singletonList("simple")}, {"log4j/simple", Collections.singletonList("simple")}, {"log4j2.simple", Collections.singletonList("simple")}, {"Log4jSimple", Collections.singletonList("simple")}, {"LOG4J_simple", Collections.singletonList("simple")}, {"org.apache.logging.log4j.simple", Collections.singletonList("simple")}, {"log4j.simpleProperty", Arrays.asList("simple", "property")}, {"log4j.simple_property", Arrays.asList("simple", "property")}, {"LOG4J_simple_property", Arrays.asList("simple", "property")}, {"LOG4J_SIMPLE_PROPERTY", Arrays.asList("simple", "property")}, {"log4j2-dashed-propertyName", Arrays.asList("dashed", "property", "name")}, {"Log4jProperty_with.all-the/separators", Arrays.asList("property", "with", "all", "the", "separators")}, {"org.apache.logging.log4j.config.property", Arrays.asList("config", "property")}};
    }

    @Test
    public void testTokenize() throws Exception {
        List tokens = PropertySource.Util.tokenize((CharSequence)this.value);
        Assert.assertEquals(this.expectedTokens, (Object)tokens);
    }
}

