/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Stack;
import org.apache.logging.log4j.util.ClassLocator;
import org.apache.logging.log4j.util.StackLocator;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.ParentRunner;
import sun.reflect.Reflection;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class StackLocatorUtilTest {
    @Test
    public void testStackTraceEquivalence() throws Exception {
        for (int i = 1; i < 15; ++i) {
            Class expected = Reflection.getCallerClass((int)(i + StackLocator.JDK_7u25_OFFSET));
            Class actual = StackLocatorUtil.getCallerClass((int)i);
            Class<?> fallbackActual = Class.forName(StackLocatorUtil.getStackTraceElement((int)i).getClassName());
            Assert.assertSame((Object)expected, (Object)actual);
            Assert.assertSame((Object)expected, fallbackActual);
        }
    }

    @Test
    public void testGetCallerClass() throws Exception {
        Class<StackLocatorUtilTest> expected = StackLocatorUtilTest.class;
        Class actual = StackLocatorUtil.getCallerClass((int)1);
        Assert.assertSame(expected, (Object)actual);
    }

    @Test
    public void testGetCallerClassNameViaStackTrace() throws Exception {
        Class<StackLocatorUtilTest> expected = StackLocatorUtilTest.class;
        Class<?> actual = Class.forName(new Throwable().getStackTrace()[0].getClassName());
        Assert.assertSame(expected, actual);
    }

    @Test
    public void testGetCurrentStackTrace() throws Exception {
        Stack classes = StackLocatorUtil.getCurrentStackTrace();
        Stack reversed = new Stack();
        reversed.ensureCapacity(classes.size());
        while (!classes.empty()) {
            reversed.push(classes.pop());
        }
        while (reversed.peek() != StackLocatorUtil.class) {
            reversed.pop();
        }
        reversed.pop();
        Assert.assertSame(StackLocatorUtilTest.class, reversed.pop());
    }

    @Test
    public void testGetCallerClassViaName() throws Exception {
        Class<BlockJUnit4ClassRunner> expected = BlockJUnit4ClassRunner.class;
        Class actual = StackLocatorUtil.getCallerClass((String)"org.junit.runners.ParentRunner");
        Assert.assertSame(expected, (Object)actual);
    }

    @Test
    public void testGetCallerClassViaAnchorClass() throws Exception {
        Class<BlockJUnit4ClassRunner> expected = BlockJUnit4ClassRunner.class;
        Class actual = StackLocatorUtil.getCallerClass(ParentRunner.class);
        Assert.assertSame(expected, (Object)actual);
    }

    @Test
    public void testLocateClass() {
        ClassLocator locator = new ClassLocator();
        Class<?> clazz = locator.locateClass();
        Assert.assertNotNull((String)"Could not locate class", clazz);
        Assert.assertEquals((String)"Incorrect class", this.getClass(), clazz);
    }
}

