/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import org.apache.logging.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class LevelTest {
    @Test
    public void testDefault() {
        Level level = Level.toLevel((String)"Information", (Level)Level.ERROR);
        Assert.assertNotNull((Object)level);
        Assert.assertEquals((Object)Level.ERROR, (Object)level);
    }

    @Test
    public void testForNameEquals() {
        String name = "Foo";
        boolean intValue = true;
        Level level = Level.forName((String)"Foo", (int)1);
        Assert.assertNotNull((Object)level);
        Assert.assertEquals((Object)level, (Object)Level.forName((String)"Foo", (int)1));
        Assert.assertEquals((Object)level, (Object)Level.getLevel((String)"Foo"));
        Assert.assertEquals((long)1L, (long)Level.getLevel((String)"Foo").intLevel());
    }

    @Test
    public void testGoodLevels() {
        Level level = Level.toLevel((String)"INFO");
        Assert.assertNotNull((Object)level);
        Assert.assertEquals((Object)Level.INFO, (Object)level);
    }

    @Test
    public void testIsInRangeErrorToDebug() {
        Assert.assertFalse((boolean)Level.OFF.isInRange(Level.ERROR, Level.DEBUG));
        Assert.assertFalse((boolean)Level.FATAL.isInRange(Level.ERROR, Level.DEBUG));
        Assert.assertTrue((boolean)Level.ERROR.isInRange(Level.ERROR, Level.DEBUG));
        Assert.assertTrue((boolean)Level.WARN.isInRange(Level.ERROR, Level.DEBUG));
        Assert.assertTrue((boolean)Level.INFO.isInRange(Level.ERROR, Level.DEBUG));
        Assert.assertTrue((boolean)Level.DEBUG.isInRange(Level.ERROR, Level.DEBUG));
        Assert.assertFalse((boolean)Level.TRACE.isInRange(Level.ERROR, Level.DEBUG));
        Assert.assertFalse((boolean)Level.ALL.isInRange(Level.ERROR, Level.DEBUG));
    }

    @Test
    public void testIsInRangeFatalToTrace() {
        Assert.assertFalse((boolean)Level.OFF.isInRange(Level.FATAL, Level.TRACE));
        Assert.assertTrue((boolean)Level.FATAL.isInRange(Level.FATAL, Level.TRACE));
        Assert.assertTrue((boolean)Level.ERROR.isInRange(Level.FATAL, Level.TRACE));
        Assert.assertTrue((boolean)Level.WARN.isInRange(Level.FATAL, Level.TRACE));
        Assert.assertTrue((boolean)Level.INFO.isInRange(Level.FATAL, Level.TRACE));
        Assert.assertTrue((boolean)Level.DEBUG.isInRange(Level.FATAL, Level.TRACE));
        Assert.assertTrue((boolean)Level.TRACE.isInRange(Level.FATAL, Level.TRACE));
        Assert.assertFalse((boolean)Level.ALL.isInRange(Level.FATAL, Level.TRACE));
    }

    @Test
    public void testIsInRangeOffToAll() {
        Assert.assertTrue((boolean)Level.OFF.isInRange(Level.OFF, Level.ALL));
        Assert.assertTrue((boolean)Level.FATAL.isInRange(Level.OFF, Level.ALL));
        Assert.assertTrue((boolean)Level.ERROR.isInRange(Level.OFF, Level.ALL));
        Assert.assertTrue((boolean)Level.WARN.isInRange(Level.OFF, Level.ALL));
        Assert.assertTrue((boolean)Level.INFO.isInRange(Level.OFF, Level.ALL));
        Assert.assertTrue((boolean)Level.DEBUG.isInRange(Level.OFF, Level.ALL));
        Assert.assertTrue((boolean)Level.TRACE.isInRange(Level.OFF, Level.ALL));
        Assert.assertTrue((boolean)Level.ALL.isInRange(Level.OFF, Level.ALL));
    }

    @Test
    public void testIsInRangeSameLevels() {
        Assert.assertTrue((boolean)Level.OFF.isInRange(Level.OFF, Level.OFF));
        Assert.assertFalse((boolean)Level.OFF.isInRange(Level.FATAL, Level.FATAL));
        Assert.assertFalse((boolean)Level.OFF.isInRange(Level.ERROR, Level.ERROR));
        Assert.assertFalse((boolean)Level.OFF.isInRange(Level.WARN, Level.WARN));
        Assert.assertFalse((boolean)Level.OFF.isInRange(Level.INFO, Level.INFO));
        Assert.assertFalse((boolean)Level.OFF.isInRange(Level.DEBUG, Level.DEBUG));
        Assert.assertFalse((boolean)Level.OFF.isInRange(Level.TRACE, Level.TRACE));
        Assert.assertFalse((boolean)Level.OFF.isInRange(Level.ALL, Level.ALL));
        Assert.assertFalse((boolean)Level.FATAL.isInRange(Level.OFF, Level.OFF));
        Assert.assertTrue((boolean)Level.FATAL.isInRange(Level.FATAL, Level.FATAL));
        Assert.assertFalse((boolean)Level.FATAL.isInRange(Level.ERROR, Level.ERROR));
        Assert.assertFalse((boolean)Level.FATAL.isInRange(Level.WARN, Level.WARN));
        Assert.assertFalse((boolean)Level.FATAL.isInRange(Level.INFO, Level.INFO));
        Assert.assertFalse((boolean)Level.FATAL.isInRange(Level.DEBUG, Level.DEBUG));
        Assert.assertFalse((boolean)Level.FATAL.isInRange(Level.TRACE, Level.TRACE));
        Assert.assertFalse((boolean)Level.FATAL.isInRange(Level.ALL, Level.ALL));
        Assert.assertFalse((boolean)Level.ERROR.isInRange(Level.OFF, Level.OFF));
        Assert.assertFalse((boolean)Level.ERROR.isInRange(Level.FATAL, Level.FATAL));
        Assert.assertTrue((boolean)Level.ERROR.isInRange(Level.ERROR, Level.ERROR));
        Assert.assertFalse((boolean)Level.ERROR.isInRange(Level.WARN, Level.WARN));
        Assert.assertFalse((boolean)Level.ERROR.isInRange(Level.INFO, Level.INFO));
        Assert.assertFalse((boolean)Level.ERROR.isInRange(Level.DEBUG, Level.DEBUG));
        Assert.assertFalse((boolean)Level.ERROR.isInRange(Level.TRACE, Level.TRACE));
        Assert.assertFalse((boolean)Level.ERROR.isInRange(Level.ALL, Level.ALL));
        Assert.assertFalse((boolean)Level.WARN.isInRange(Level.OFF, Level.OFF));
        Assert.assertFalse((boolean)Level.WARN.isInRange(Level.FATAL, Level.FATAL));
        Assert.assertFalse((boolean)Level.WARN.isInRange(Level.ERROR, Level.ERROR));
        Assert.assertTrue((boolean)Level.WARN.isInRange(Level.WARN, Level.WARN));
        Assert.assertFalse((boolean)Level.WARN.isInRange(Level.INFO, Level.INFO));
        Assert.assertFalse((boolean)Level.WARN.isInRange(Level.DEBUG, Level.DEBUG));
        Assert.assertFalse((boolean)Level.WARN.isInRange(Level.TRACE, Level.TRACE));
        Assert.assertFalse((boolean)Level.WARN.isInRange(Level.ALL, Level.ALL));
        Assert.assertFalse((boolean)Level.INFO.isInRange(Level.OFF, Level.OFF));
        Assert.assertFalse((boolean)Level.INFO.isInRange(Level.FATAL, Level.FATAL));
        Assert.assertFalse((boolean)Level.INFO.isInRange(Level.ERROR, Level.ERROR));
        Assert.assertFalse((boolean)Level.INFO.isInRange(Level.WARN, Level.WARN));
        Assert.assertTrue((boolean)Level.INFO.isInRange(Level.INFO, Level.INFO));
        Assert.assertFalse((boolean)Level.INFO.isInRange(Level.DEBUG, Level.DEBUG));
        Assert.assertFalse((boolean)Level.INFO.isInRange(Level.TRACE, Level.TRACE));
        Assert.assertFalse((boolean)Level.INFO.isInRange(Level.ALL, Level.ALL));
        Assert.assertFalse((boolean)Level.DEBUG.isInRange(Level.OFF, Level.OFF));
        Assert.assertFalse((boolean)Level.DEBUG.isInRange(Level.FATAL, Level.FATAL));
        Assert.assertFalse((boolean)Level.DEBUG.isInRange(Level.ERROR, Level.ERROR));
        Assert.assertFalse((boolean)Level.DEBUG.isInRange(Level.WARN, Level.WARN));
        Assert.assertFalse((boolean)Level.DEBUG.isInRange(Level.INFO, Level.INFO));
        Assert.assertTrue((boolean)Level.DEBUG.isInRange(Level.DEBUG, Level.DEBUG));
        Assert.assertFalse((boolean)Level.DEBUG.isInRange(Level.TRACE, Level.TRACE));
        Assert.assertFalse((boolean)Level.DEBUG.isInRange(Level.ALL, Level.ALL));
        Assert.assertFalse((boolean)Level.TRACE.isInRange(Level.OFF, Level.OFF));
        Assert.assertFalse((boolean)Level.TRACE.isInRange(Level.FATAL, Level.FATAL));
        Assert.assertFalse((boolean)Level.TRACE.isInRange(Level.ERROR, Level.ERROR));
        Assert.assertFalse((boolean)Level.TRACE.isInRange(Level.WARN, Level.WARN));
        Assert.assertFalse((boolean)Level.TRACE.isInRange(Level.INFO, Level.INFO));
        Assert.assertFalse((boolean)Level.TRACE.isInRange(Level.DEBUG, Level.DEBUG));
        Assert.assertTrue((boolean)Level.TRACE.isInRange(Level.TRACE, Level.TRACE));
        Assert.assertFalse((boolean)Level.TRACE.isInRange(Level.ALL, Level.ALL));
        Assert.assertFalse((boolean)Level.ALL.isInRange(Level.OFF, Level.OFF));
        Assert.assertFalse((boolean)Level.ALL.isInRange(Level.FATAL, Level.FATAL));
        Assert.assertFalse((boolean)Level.ALL.isInRange(Level.ERROR, Level.ERROR));
        Assert.assertFalse((boolean)Level.ALL.isInRange(Level.WARN, Level.WARN));
        Assert.assertFalse((boolean)Level.ALL.isInRange(Level.INFO, Level.INFO));
        Assert.assertFalse((boolean)Level.ALL.isInRange(Level.DEBUG, Level.DEBUG));
        Assert.assertFalse((boolean)Level.ALL.isInRange(Level.TRACE, Level.TRACE));
        Assert.assertTrue((boolean)Level.ALL.isInRange(Level.ALL, Level.ALL));
    }

    @Test
    public void testIsInRangeWarnToInfo() {
        Assert.assertFalse((boolean)Level.OFF.isInRange(Level.WARN, Level.INFO));
        Assert.assertFalse((boolean)Level.FATAL.isInRange(Level.WARN, Level.INFO));
        Assert.assertFalse((boolean)Level.ERROR.isInRange(Level.WARN, Level.INFO));
        Assert.assertTrue((boolean)Level.WARN.isInRange(Level.WARN, Level.INFO));
        Assert.assertTrue((boolean)Level.INFO.isInRange(Level.WARN, Level.INFO));
        Assert.assertFalse((boolean)Level.DEBUG.isInRange(Level.WARN, Level.INFO));
        Assert.assertFalse((boolean)Level.TRACE.isInRange(Level.WARN, Level.INFO));
        Assert.assertFalse((boolean)Level.ALL.isInRange(Level.WARN, Level.INFO));
    }

    @Test
    public void testIsLessSpecificThan() {
        Assert.assertTrue((boolean)Level.OFF.isLessSpecificThan(Level.OFF));
        Assert.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.FATAL));
        Assert.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.ERROR));
        Assert.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.WARN));
        Assert.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.INFO));
        Assert.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.DEBUG));
        Assert.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.TRACE));
        Assert.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.ALL));
        Assert.assertTrue((boolean)Level.FATAL.isLessSpecificThan(Level.OFF));
        Assert.assertTrue((boolean)Level.FATAL.isLessSpecificThan(Level.FATAL));
        Assert.assertFalse((boolean)Level.FATAL.isLessSpecificThan(Level.ERROR));
        Assert.assertFalse((boolean)Level.FATAL.isLessSpecificThan(Level.WARN));
        Assert.assertFalse((boolean)Level.FATAL.isLessSpecificThan(Level.INFO));
        Assert.assertFalse((boolean)Level.FATAL.isLessSpecificThan(Level.DEBUG));
        Assert.assertFalse((boolean)Level.FATAL.isLessSpecificThan(Level.TRACE));
        Assert.assertFalse((boolean)Level.FATAL.isLessSpecificThan(Level.ALL));
        Assert.assertTrue((boolean)Level.ERROR.isLessSpecificThan(Level.OFF));
        Assert.assertTrue((boolean)Level.ERROR.isLessSpecificThan(Level.FATAL));
        Assert.assertTrue((boolean)Level.ERROR.isLessSpecificThan(Level.ERROR));
        Assert.assertFalse((boolean)Level.ERROR.isLessSpecificThan(Level.WARN));
        Assert.assertFalse((boolean)Level.ERROR.isLessSpecificThan(Level.INFO));
        Assert.assertFalse((boolean)Level.ERROR.isLessSpecificThan(Level.DEBUG));
        Assert.assertFalse((boolean)Level.ERROR.isLessSpecificThan(Level.TRACE));
        Assert.assertFalse((boolean)Level.ERROR.isLessSpecificThan(Level.ALL));
        Assert.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.OFF));
        Assert.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.FATAL));
        Assert.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.ERROR));
        Assert.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.WARN));
        Assert.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.INFO));
        Assert.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.DEBUG));
        Assert.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.TRACE));
        Assert.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.ALL));
        Assert.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.OFF));
        Assert.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.FATAL));
        Assert.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.ERROR));
        Assert.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.WARN));
        Assert.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.INFO));
        Assert.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.DEBUG));
        Assert.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.TRACE));
        Assert.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.ALL));
        Assert.assertTrue((boolean)Level.INFO.isLessSpecificThan(Level.OFF));
        Assert.assertTrue((boolean)Level.INFO.isLessSpecificThan(Level.FATAL));
        Assert.assertTrue((boolean)Level.INFO.isLessSpecificThan(Level.ERROR));
        Assert.assertTrue((boolean)Level.INFO.isLessSpecificThan(Level.WARN));
        Assert.assertTrue((boolean)Level.INFO.isLessSpecificThan(Level.INFO));
        Assert.assertFalse((boolean)Level.INFO.isLessSpecificThan(Level.DEBUG));
        Assert.assertFalse((boolean)Level.INFO.isLessSpecificThan(Level.TRACE));
        Assert.assertFalse((boolean)Level.INFO.isLessSpecificThan(Level.ALL));
        Assert.assertTrue((boolean)Level.DEBUG.isLessSpecificThan(Level.OFF));
        Assert.assertTrue((boolean)Level.DEBUG.isLessSpecificThan(Level.FATAL));
        Assert.assertTrue((boolean)Level.DEBUG.isLessSpecificThan(Level.ERROR));
        Assert.assertTrue((boolean)Level.DEBUG.isLessSpecificThan(Level.WARN));
        Assert.assertTrue((boolean)Level.DEBUG.isLessSpecificThan(Level.INFO));
        Assert.assertTrue((boolean)Level.DEBUG.isLessSpecificThan(Level.DEBUG));
        Assert.assertFalse((boolean)Level.DEBUG.isLessSpecificThan(Level.TRACE));
        Assert.assertFalse((boolean)Level.DEBUG.isLessSpecificThan(Level.ALL));
        Assert.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.OFF));
        Assert.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.FATAL));
        Assert.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.ERROR));
        Assert.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.WARN));
        Assert.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.INFO));
        Assert.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.DEBUG));
        Assert.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.TRACE));
        Assert.assertFalse((boolean)Level.TRACE.isLessSpecificThan(Level.ALL));
        Assert.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.OFF));
        Assert.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.FATAL));
        Assert.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.ERROR));
        Assert.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.WARN));
        Assert.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.INFO));
        Assert.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.DEBUG));
        Assert.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.TRACE));
        Assert.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.ALL));
    }
}

