/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MarkerTest {
    @Before
    public void setUp() {
        MarkerManager.clear();
    }

    @Test
    public void testGetMarker() {
        Marker expected = MarkerManager.getMarker((String)"A");
        Assert.assertNull((Object)expected.getParents());
    }

    @Test
    public void testGetMarkerWithParents() {
        Marker expected = MarkerManager.getMarker((String)"A");
        Marker p1 = MarkerManager.getMarker((String)"P1");
        p1.addParents(new Marker[]{MarkerManager.getMarker((String)"PP1")});
        Marker p2 = MarkerManager.getMarker((String)"P2");
        expected.addParents(new Marker[]{p1});
        expected.addParents(new Marker[]{p2});
        Assert.assertEquals((long)2L, (long)expected.getParents().length);
    }

    @Test
    public void testHasParents() {
        Marker parent = MarkerManager.getMarker((String)"PARENT");
        Marker existing = MarkerManager.getMarker((String)"EXISTING");
        Assert.assertFalse((boolean)existing.hasParents());
        existing.setParents(new Marker[]{parent});
        Assert.assertTrue((boolean)existing.hasParents());
    }

    @Test
    public void testMarker() {
        Marker parent = MarkerManager.getMarker((String)"PARENT");
        Marker test1 = MarkerManager.getMarker((String)"TEST1").setParents(new Marker[]{parent});
        Marker test2 = MarkerManager.getMarker((String)"TEST2").addParents(new Marker[]{parent});
        Assert.assertTrue((String)"TEST1 is not an instance of PARENT", (boolean)test1.isInstanceOf(parent));
        Assert.assertTrue((String)"TEST2 is not an instance of PARENT", (boolean)test2.isInstanceOf(parent));
    }

    @Test
    public void testMultipleParents() {
        Marker parent1 = MarkerManager.getMarker((String)"PARENT1");
        Marker parent2 = MarkerManager.getMarker((String)"PARENT2");
        Marker test1 = MarkerManager.getMarker((String)"TEST1").setParents(new Marker[]{parent1, parent2});
        Marker test2 = MarkerManager.getMarker((String)"TEST2").addParents(new Marker[]{parent1, parent2});
        Assert.assertTrue((String)"TEST1 is not an instance of PARENT1", (boolean)test1.isInstanceOf(parent1));
        Assert.assertTrue((String)"TEST1 is not an instance of PARENT2", (boolean)test1.isInstanceOf(parent2));
        Assert.assertTrue((String)"TEST2 is not an instance of PARENT1", (boolean)test2.isInstanceOf(parent1));
        Assert.assertTrue((String)"TEST2 is not an instance of PARENT2", (boolean)test2.isInstanceOf(parent2));
    }

    @Test
    public void testAddToExistingParents() {
        Marker parent = MarkerManager.getMarker((String)"PARENT");
        Marker existing = MarkerManager.getMarker((String)"EXISTING");
        Marker test1 = MarkerManager.getMarker((String)"TEST1").setParents(new Marker[]{existing});
        test1.addParents(new Marker[]{parent});
        Assert.assertTrue((String)"TEST1 is not an instance of PARENT", (boolean)test1.isInstanceOf(parent));
        Assert.assertTrue((String)"TEST1 is not an instance of EXISTING", (boolean)test1.isInstanceOf(existing));
    }

    @Test
    public void testDuplicateParents() {
        Marker parent = MarkerManager.getMarker((String)"PARENT");
        Marker existing = MarkerManager.getMarker((String)"EXISTING");
        Marker test1 = MarkerManager.getMarker((String)"TEST1").setParents(new Marker[]{existing});
        test1.addParents(new Marker[]{parent});
        Marker[] parents = test1.getParents();
        test1.addParents(new Marker[]{existing});
        Assert.assertTrue((String)"duplicate add allowed", (parents.length == test1.getParents().length ? 1 : 0) != 0);
        test1.addParents(new Marker[]{existing, MarkerManager.getMarker((String)"EXTRA")});
        Assert.assertTrue((String)"incorrect add", (parents.length + 1 == test1.getParents().length ? 1 : 0) != 0);
        Assert.assertTrue((String)"TEST1 is not an instance of PARENT", (boolean)test1.isInstanceOf(parent));
        Assert.assertTrue((String)"TEST1 is not an instance of EXISTING", (boolean)test1.isInstanceOf(existing));
    }
}

