/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.message.MapMessageJsonFormatter;
import org.apache.logging.log4j.message.ObjectMapMessage;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.junit.Assert;
import org.junit.Test;

public class MapMessageTest {
    @Test
    public void testMap() {
        String testMsg = "Test message {}";
        StringMapMessage msg = new StringMapMessage();
        msg.put("message", "Test message {}");
        msg.put("project", "Log4j");
        String result = msg.getFormattedMessage();
        String expected = "message=\"Test message {}\" project=\"Log4j\"";
        Assert.assertEquals((Object)"message=\"Test message {}\" project=\"Log4j\"", (Object)result);
    }

    @Test
    public void testBuilder() {
        String testMsg = "Test message {}";
        StringMapMessage msg = (StringMapMessage)((StringMapMessage)new StringMapMessage().with("message", "Test message {}")).with("project", "Log4j");
        String result = msg.getFormattedMessage();
        String expected = "message=\"Test message {}\" project=\"Log4j\"";
        Assert.assertEquals((Object)"message=\"Test message {}\" project=\"Log4j\"", (Object)result);
    }

    @Test
    public void testXML() {
        String testMsg = "Test message {}";
        StringMapMessage msg = new StringMapMessage();
        msg.put("message", "Test message {}");
        msg.put("project", "Log4j");
        String result = msg.getFormattedMessage(new String[]{"XML"});
        String expected = "<Map>\n  <Entry key=\"message\">Test message {}</Entry>\n  <Entry key=\"project\">Log4j</Entry>\n</Map>";
        Assert.assertEquals((Object)"<Map>\n  <Entry key=\"message\">Test message {}</Entry>\n  <Entry key=\"project\">Log4j</Entry>\n</Map>", (Object)result);
    }

    @Test
    public void testXMLEscape() {
        String testMsg = "Test message <foo>";
        StringMapMessage msg = new StringMapMessage();
        msg.put("message", "Test message <foo>");
        String result = msg.getFormattedMessage(new String[]{"XML"});
        String expected = "<Map>\n  <Entry key=\"message\">Test message &lt;foo&gt;</Entry>\n</Map>";
        Assert.assertEquals((Object)"<Map>\n  <Entry key=\"message\">Test message &lt;foo&gt;</Entry>\n</Map>", (Object)result);
    }

    @Test
    public void testJSON() {
        String testMsg = "Test message {}";
        StringMapMessage msg = new StringMapMessage();
        msg.put("message", "Test message {}");
        msg.put("project", "Log4j");
        String result = msg.getFormattedMessage(new String[]{"JSON"});
        String expected = "{'message':'Test message {}','project':'Log4j'}".replace('\'', '\"');
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testJSONEscape() {
        String testMsg = "Test message \"Hello, World!\"";
        StringMapMessage msg = new StringMapMessage();
        msg.put("message", "Test message \"Hello, World!\"");
        String result = msg.getFormattedMessage(new String[]{"JSON"});
        String expected = "{\"message\":\"Test message \\\"Hello, World!\\\"\"}";
        Assert.assertEquals((Object)"{\"message\":\"Test message \\\"Hello, World!\\\"\"}", (Object)result);
    }

    @Test
    public void testJSONEscapeNewlineAndOtherControlCharacters() {
        String testMsg = "hello\tworld\r\nhh\bere is it\f";
        StringMapMessage msg = new StringMapMessage();
        msg.put("one\ntwo", "hello\tworld\r\nhh\bere is it\f");
        String result = msg.getFormattedMessage(new String[]{"JSON"});
        String expected = "{\"one\\ntwo\":\"hello\\tworld\\r\\nhh\\bere is it\\f\"}";
        Assert.assertEquals((Object)"{\"one\\ntwo\":\"hello\\tworld\\r\\nhh\\bere is it\\f\"}", (Object)result);
    }

    @Test
    public void testJsonFormatterNestedObjectSupport() {
        String actualJson = ((ObjectMapMessage)((ObjectMapMessage)((ObjectMapMessage)((ObjectMapMessage)new ObjectMapMessage().with("key1", "val1")).with("key2", Collections.singletonMap("key2.1", "val2.1"))).with("key3", Arrays.asList(3, (byte)127, 4.5, Float.valueOf(4.6f), Arrays.asList(true, false), new BigDecimal(30), Collections.singletonMap("key3.3", "val3.3")))).with("key4", new LinkedHashMap<String, Object>(){
            {
                this.put("chars", new char[]{'a', 'b', 'c'});
                this.put("booleans", new boolean[]{true, false});
                this.put("bytes", new byte[]{1, 2});
                this.put("shorts", new short[]{3, 4});
                this.put("ints", new int[]{256, 257});
                this.put("longs", new long[]{0x80000000L, 0x80000001L});
                this.put("floats", new float[]{1.0f, 1.1f});
                this.put("doubles", new double[]{2.0, 2.1});
                this.put("objects", new Object[]{"foo", "bar"});
            }
        })).getFormattedMessage(new String[]{"JSON"});
        String expectedJson = "{'key1':'val1','key2':{'key2.1':'val2.1'},'key3':[3,127,4.5,4.6,[true,false],30,{'key3.3':'val3.3'}],'key4':{'chars':['a','b','c'],'booleans':[true,false],'bytes':[1,2],'shorts':[3,4],'ints':[256,257],'longs':[2147483648,2147483649],'floats':[1.0,1.1],'doubles':[2.0,2.1],'objects':['foo','bar']}}".replace('\'', '\"');
        Assert.assertEquals((Object)expectedJson, (Object)actualJson);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testJsonFormatterInfiniteRecursionPrevention() {
        List<Object> recursiveValue = Arrays.asList(1, null);
        recursiveValue.set(1, recursiveValue);
        ((ObjectMapMessage)new ObjectMapMessage().with("key", recursiveValue)).getFormattedMessage(new String[]{"JSON"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testJsonFormatterMaxDepthViolation() {
        MapMessageTest.testJsonFormatterMaxDepth(MapMessageJsonFormatter.MAX_DEPTH - 1);
    }

    @Test
    public void testJsonFormatterMaxDepthConformance() {
        int depth = MapMessageJsonFormatter.MAX_DEPTH - 2;
        String expectedJson = String.format("{'key':%s1%s}", Strings.repeat((String)"[", (int)depth), Strings.repeat((String)"]", (int)depth)).replace('\'', '\"');
        String actualJson = MapMessageTest.testJsonFormatterMaxDepth(depth);
        Assert.assertEquals((Object)expectedJson, (Object)actualJson);
    }

    public static String testJsonFormatterMaxDepth(int depth) {
        LinkedList<Serializable> list = new LinkedList<Integer>();
        list.add((Serializable)1);
        while (--depth > 0) {
            list = new LinkedList(Collections.singletonList(list));
        }
        return ((ObjectMapMessage)new ObjectMapMessage().with("key", list)).getFormattedMessage(new String[]{"JSON"});
    }

    @Test
    public void testJava() {
        String testMsg = "Test message {}";
        StringMapMessage msg = new StringMapMessage();
        msg.put("message", "Test message {}");
        msg.put("project", "Log4j");
        String result = msg.getFormattedMessage(new String[]{"Java"});
        String expected = "{message=\"Test message {}\", project=\"Log4j\"}";
        Assert.assertEquals((Object)"{message=\"Test message {}\", project=\"Log4j\"}", (Object)result);
    }

    @Test
    public void testMutableByDesign() {
        StringMapMessage msg = new StringMapMessage();
        msg.put("key1", "value1");
        msg.put("key2", "value2");
        String result = msg.getFormattedMessage(new String[]{"Java"});
        String expected = "{key1=\"value1\", key2=\"value2\"}";
        Assert.assertEquals((Object)"{key1=\"value1\", key2=\"value2\"}", (Object)result);
        msg.put("key3", "value3");
        String result2 = msg.getFormattedMessage(new String[]{"Java"});
        String expected2 = "{key1=\"value1\", key2=\"value2\", key3=\"value3\"}";
        Assert.assertEquals((Object)"{key1=\"value1\", key2=\"value2\", key3=\"value3\"}", (Object)result2);
    }

    @Test
    public void testGetNonStringValue() {
        String key = "Key";
        ObjectMapMessage msg = (ObjectMapMessage)new ObjectMapMessage().with("Key", 1L);
        Assert.assertEquals((Object)"1", (Object)msg.get("Key"));
    }

    @Test
    public void testRemoveNonStringValue() {
        String key = "Key";
        ObjectMapMessage msg = (ObjectMapMessage)new ObjectMapMessage().with("Key", 1L);
        Assert.assertEquals((Object)"1", (Object)msg.remove("Key"));
    }

    @Test
    public void testJSONFormatNonStringValue() {
        ObjectMapMessage msg = (ObjectMapMessage)new ObjectMapMessage().with("key", 1L);
        String result = msg.getFormattedMessage(new String[]{"JSON"});
        String expected = "{'key':1}".replace('\'', '\"');
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testXMLFormatNonStringValue() {
        ObjectMapMessage msg = (ObjectMapMessage)new ObjectMapMessage().with("key", 1L);
        String result = msg.getFormattedMessage(new String[]{"XML"});
        String expected = "<Map>\n  <Entry key=\"key\">1</Entry>\n</Map>";
        Assert.assertEquals((Object)"<Map>\n  <Entry key=\"key\">1</Entry>\n</Map>", (Object)result);
    }

    @Test
    public void testFormatToUsedInOutputXml() {
        ObjectMapMessage msg = (ObjectMapMessage)new ObjectMapMessage().with("key", new FormattableTestType());
        String result = msg.getFormattedMessage(new String[]{"XML"});
        String expected = "<Map>\n  <Entry key=\"key\">formatTo</Entry>\n</Map>";
        Assert.assertEquals((Object)"<Map>\n  <Entry key=\"key\">formatTo</Entry>\n</Map>", (Object)result);
    }

    @Test
    public void testFormatToUsedInOutputJson() {
        ObjectMapMessage msg = (ObjectMapMessage)new ObjectMapMessage().with("key", new FormattableTestType());
        String result = msg.getFormattedMessage(new String[]{"JSON"});
        String expected = "{\"key\":\"formatTo\"}";
        Assert.assertEquals((Object)"{\"key\":\"formatTo\"}", (Object)result);
    }

    @Test
    public void testFormatToUsedInOutputJava() {
        ObjectMapMessage msg = (ObjectMapMessage)new ObjectMapMessage().with("key", new FormattableTestType());
        String result = msg.getFormattedMessage(new String[]{"JAVA"});
        String expected = "{key=\"formatTo\"}";
        Assert.assertEquals((Object)"{key=\"formatTo\"}", (Object)result);
    }

    @Test
    public void testFormatToUsedInOutputDefault() {
        ObjectMapMessage msg = (ObjectMapMessage)new ObjectMapMessage().with("key", new FormattableTestType());
        String result = msg.getFormattedMessage(null);
        String expected = "key=\"formatTo\"";
        Assert.assertEquals((Object)"key=\"formatTo\"", (Object)result);
    }

    @Test
    public void testGetUsesDeepToString() {
        String key = "key";
        ObjectMapMessage msg = (ObjectMapMessage)new ObjectMapMessage().with("key", new FormattableTestType());
        String result = msg.get("key");
        String expected = "formatTo";
        Assert.assertEquals((Object)"formatTo", (Object)result);
    }

    @Test
    public void testRemoveUsesDeepToString() {
        String key = "key";
        ObjectMapMessage msg = (ObjectMapMessage)new ObjectMapMessage().with("key", new FormattableTestType());
        String result = msg.remove("key");
        String expected = "formatTo";
        Assert.assertEquals((Object)"formatTo", (Object)result);
    }

    private static final class FormattableTestType
    implements StringBuilderFormattable {
        private FormattableTestType() {
        }

        public String toString() {
            return "toString";
        }

        public void formatTo(StringBuilder buffer) {
            buffer.append("formatTo");
        }
    }
}

