/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.TestLogger;
import org.apache.logging.log4j.TestLoggerContext;
import org.apache.logging.log4j.TestLoggerContextFactory;
import org.apache.logging.log4j.simple.SimpleLoggerContext;
import org.apache.logging.log4j.spi.AbstractLoggerAdapter;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.LoggerContextShutdownAware;
import org.junit.Assert;
import org.junit.Test;

public class LoggerAdapterTest {
    @Test
    public void testCleanup() throws Exception {
        TestLoggerContextFactory factory = new TestLoggerContextFactory();
        TestLoggerAdapter2 adapter = new TestLoggerAdapter2();
        for (int i = 0; i < 5; ++i) {
            LoggerContext lc = adapter.getContext(Integer.toString(i));
            lc.getLogger(Integer.toString(i));
        }
        Assert.assertEquals((String)"Expected 5 LoggerContexts", (long)5L, (long)adapter.registry.size());
        HashSet contexts = new HashSet(adapter.registry.keySet());
        for (LoggerContext context : contexts) {
            ((TestLoggerContext2)context).shutdown();
        }
        Assert.assertEquals((String)"Expected 0 LoggerContexts", (long)0L, (long)adapter.registry.size());
    }

    @Test
    public synchronized void testGetLoggersInContextSynch() throws Exception {
        int i;
        TestLoggerAdapter adapter = new TestLoggerAdapter();
        int num = 500;
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(500);
        RunnableThreadTest[] instances = new RunnableThreadTest[500];
        SimpleLoggerContext lastUsedContext = null;
        for (i = 0; i < 500; ++i) {
            if (i % 2 == 0) {
                lastUsedContext = new SimpleLoggerContext();
            }
            RunnableThreadTest runnable = new RunnableThreadTest(i, adapter, (LoggerContext)lastUsedContext, startSignal, doneSignal);
            Thread thread = new Thread(runnable);
            thread.start();
            instances[i] = runnable;
        }
        startSignal.countDown();
        doneSignal.await();
        for (i = 0; i < 500; i += 2) {
            Map<String, Logger> resultMap1 = instances[i].getResultMap();
            Map<String, Logger> resultMap2 = instances[i + 1].getResultMap();
            Assert.assertSame((String)("not the same map for instances" + i + " and " + (i + 1) + ":"), resultMap1, resultMap2);
            Assert.assertEquals((long)2L, (long)resultMap1.size());
        }
    }

    private static class TestLoggerContext2
    extends TestLoggerContext {
        private final String name;
        private final LoggerContextShutdownAware listener;

        public TestLoggerContext2(String name, LoggerContextShutdownAware listener) {
            this.name = name;
            this.listener = listener;
        }

        public String getName() {
            return this.name;
        }

        public void shutdown() {
            this.listener.contextShutdown((LoggerContext)this);
        }
    }

    private static class TestLoggerAdapter2
    extends AbstractLoggerAdapter<Logger> {
        private TestLoggerAdapter2() {
        }

        protected Logger newLogger(String name, LoggerContext context) {
            return context.getLogger(name);
        }

        protected LoggerContext getContext() {
            return null;
        }

        public LoggerContext getContext(String fqcn) {
            for (LoggerContext lc : this.registry.keySet()) {
                TestLoggerContext2 context = (TestLoggerContext2)lc;
                if (!fqcn.equals(context.getName())) continue;
                return context;
            }
            TestLoggerContext2 lc = new TestLoggerContext2(fqcn, (LoggerContextShutdownAware)this);
            this.registry.put(lc, new ConcurrentHashMap());
            return lc;
        }
    }

    private static class TestLoggerAdapter
    extends AbstractLoggerAdapter<Logger> {
        private TestLoggerAdapter() {
        }

        protected LoggerContext getContext() {
            return null;
        }

        protected Logger newLogger(String name, LoggerContext context) {
            return null;
        }
    }

    private class RunnableThreadTest
    implements Runnable {
        private final AbstractLoggerAdapter<Logger> adapter;
        private final LoggerContext context;
        private final CountDownLatch doneSignal;
        private final int index;
        private Map<String, Logger> resultMap;
        private final CountDownLatch startSignal;

        public RunnableThreadTest(int index, TestLoggerAdapter adapter, LoggerContext context, CountDownLatch startSignal, CountDownLatch doneSignal) {
            this.adapter = adapter;
            this.context = context;
            this.startSignal = startSignal;
            this.doneSignal = doneSignal;
            this.index = index;
        }

        public Map<String, Logger> getResultMap() {
            return this.resultMap;
        }

        @Override
        public void run() {
            try {
                this.startSignal.await();
                this.resultMap = this.adapter.getLoggersInContext(this.context);
                this.resultMap.put(String.valueOf(this.index), (Logger)new TestLogger());
                this.doneSignal.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

