/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.junit.Assert;
import org.junit.Test;

public class MutableThreadContextStackTest {
    @Test
    public void testEmptyIfConstructedWithEmptyList() {
        MutableThreadContextStack stack = new MutableThreadContextStack(new ArrayList());
        Assert.assertTrue((boolean)stack.isEmpty());
    }

    @Test
    public void testConstructorCopiesListContents() {
        List<String> initial = Arrays.asList("a", "b", "c");
        MutableThreadContextStack stack = new MutableThreadContextStack(initial);
        Assert.assertFalse((boolean)stack.isEmpty());
        Assert.assertTrue((boolean)stack.containsAll(initial));
    }

    @Test
    public void testPushAndAddIncreaseStack() {
        MutableThreadContextStack stack = new MutableThreadContextStack(new ArrayList());
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        Assert.assertEquals((long)2L, (long)stack.size());
    }

    @Test
    public void testPeekReturnsLastAddedItem() {
        MutableThreadContextStack stack = new MutableThreadContextStack(new ArrayList());
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        Assert.assertEquals((long)2L, (long)stack.size());
        Assert.assertEquals((Object)"msg2", (Object)stack.peek());
        stack.push("msg3");
        Assert.assertEquals((Object)"msg3", (Object)stack.peek());
    }

    @Test
    public void testPopRemovesLastAddedItem() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Assert.assertEquals((long)3L, (long)stack.getDepth());
        Assert.assertEquals((Object)"msg3", (Object)stack.pop());
        Assert.assertEquals((long)2L, (long)stack.size());
        Assert.assertEquals((long)2L, (long)stack.getDepth());
        Assert.assertEquals((Object)"msg2", (Object)stack.pop());
        Assert.assertEquals((long)1L, (long)stack.size());
        Assert.assertEquals((long)1L, (long)stack.getDepth());
        Assert.assertEquals((Object)"msg1", (Object)stack.pop());
        Assert.assertEquals((long)0L, (long)stack.size());
        Assert.assertEquals((long)0L, (long)stack.getDepth());
    }

    @Test
    public void testAsList() {
        MutableThreadContextStack stack = new MutableThreadContextStack(new ArrayList());
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        stack.push("msg3");
        Assert.assertEquals(Arrays.asList("msg1", "msg2", "msg3"), (Object)stack.asList());
    }

    @Test
    public void testTrim() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        stack.trim(1);
        Assert.assertEquals((long)1L, (long)stack.size());
        Assert.assertEquals((Object)"msg1", (Object)stack.peek());
    }

    @Test
    public void testCopy() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        ThreadContextStack copy = stack.copy();
        Assert.assertEquals((long)3L, (long)copy.size());
        Assert.assertTrue((boolean)copy.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertEquals((long)3L, (long)copy.size());
        Assert.assertTrue((boolean)copy.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
        copy.add((Object)"other");
        Assert.assertEquals((long)4L, (long)copy.size());
        Assert.assertTrue((boolean)stack.isEmpty());
        stack.push("newStackMsg");
        Assert.assertEquals((long)1L, (long)stack.size());
        Assert.assertEquals((long)4L, (long)copy.size());
        copy.clear();
        Assert.assertTrue((boolean)copy.isEmpty());
        Assert.assertEquals((long)1L, (long)stack.size());
    }

    @Test
    public void testClear() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
    }

    @Test
    public void testEqualsVsSameKind() {
        MutableThreadContextStack stack1 = MutableThreadContextStackTest.createStack();
        MutableThreadContextStack stack2 = MutableThreadContextStackTest.createStack();
        Assert.assertEquals((Object)stack1, (Object)stack1);
        Assert.assertEquals((Object)stack2, (Object)stack2);
        Assert.assertEquals((Object)stack1, (Object)stack2);
        Assert.assertEquals((Object)stack2, (Object)stack1);
    }

    @Test
    public void testHashCodeVsSameKind() {
        MutableThreadContextStack stack1 = MutableThreadContextStackTest.createStack();
        MutableThreadContextStack stack2 = MutableThreadContextStackTest.createStack();
        Assert.assertEquals((long)stack1.hashCode(), (long)stack2.hashCode());
    }

    static MutableThreadContextStack createStack() {
        MutableThreadContextStack stack1 = new MutableThreadContextStack(new ArrayList());
        stack1.clear();
        Assert.assertTrue((boolean)stack1.isEmpty());
        stack1.push("msg1");
        stack1.add("msg2");
        stack1.push("msg3");
        Assert.assertEquals((long)3L, (long)stack1.size());
        return stack1;
    }

    @Test
    public void testContains() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Assert.assertTrue((boolean)stack.contains((Object)"msg1"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg3"));
    }

    @Test
    public void testIteratorReturnsInListOrderNotStackOrder() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Iterator iter = stack.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"msg1", iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"msg2", iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"msg3", iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testToArray() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Object[] expecteds = new String[]{"msg1", "msg2", "msg3"};
        Assert.assertArrayEquals((Object[])expecteds, (Object[])stack.toArray());
    }

    @Test
    public void testToArrayTArray() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Object[] expecteds = new String[]{"msg1", "msg2", "msg3"};
        Object[] result = new String[3];
        Assert.assertArrayEquals((Object[])expecteds, (Object[])stack.toArray(result));
        Assert.assertSame((Object)result, (Object)stack.toArray(result));
    }

    @Test
    public void testRemove() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Assert.assertTrue((boolean)stack.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
        stack.remove((Object)"msg1");
        Assert.assertEquals((long)2L, (long)stack.size());
        Assert.assertTrue((boolean)stack.containsAll(Arrays.asList("msg2", "msg3")));
        Assert.assertEquals((Object)"msg3", (Object)stack.peek());
        stack.remove((Object)"msg3");
        Assert.assertEquals((long)1L, (long)stack.size());
        Assert.assertTrue((boolean)stack.containsAll(Arrays.asList("msg2")));
        Assert.assertEquals((Object)"msg2", (Object)stack.peek());
    }

    @Test
    public void testContainsAll() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Assert.assertTrue((boolean)stack.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
    }

    @Test
    public void testAddAll() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        stack.addAll(Arrays.asList("msg4", "msg5"));
        Assert.assertEquals((long)5L, (long)stack.size());
        Assert.assertTrue((boolean)stack.contains((Object)"msg1"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg3"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg4"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg5"));
    }

    @Test
    public void testRemoveAll() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        stack.removeAll(Arrays.asList("msg1", "msg3"));
        Assert.assertEquals((long)1L, (long)stack.size());
        Assert.assertFalse((boolean)stack.contains((Object)"msg1"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assert.assertFalse((boolean)stack.contains((Object)"msg3"));
    }

    @Test
    public void testRetainAll() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        stack.retainAll(Arrays.asList("msg1", "msg3"));
        Assert.assertEquals((long)2L, (long)stack.size());
        Assert.assertTrue((boolean)stack.contains((Object)"msg1"));
        Assert.assertFalse((boolean)stack.contains((Object)"msg2"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg3"));
    }

    @Test
    public void testToStringShowsListContents() {
        MutableThreadContextStack stack = new MutableThreadContextStack(new ArrayList());
        Assert.assertEquals((Object)"[]", (Object)stack.toString());
        stack.push("msg1");
        stack.add("msg2");
        stack.push("msg3");
        Assert.assertEquals((Object)"[msg1, msg2, msg3]", (Object)stack.toString());
        stack.retainAll(Arrays.asList("msg1", "msg3"));
        Assert.assertEquals((Object)"[msg1, msg3]", (Object)stack.toString());
    }

    @Test
    public void testIsFrozenIsFalseByDefault() {
        Assert.assertFalse((boolean)new MutableThreadContextStack().isFrozen());
        Assert.assertFalse((boolean)MutableThreadContextStackTest.createStack().isFrozen());
    }

    @Test
    public void testIsFrozenIsTrueAfterCallToFreeze() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        Assert.assertFalse((boolean)stack.isFrozen());
        stack.freeze();
        Assert.assertTrue((boolean)stack.isFrozen());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddAllOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        stack.addAll(Arrays.asList("a", "b", "c"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        stack.add("a");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClearOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        stack.clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPopOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        stack.pop();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPushOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        stack.push("a");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        stack.remove((Object)"a");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveAllOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        stack.removeAll(Arrays.asList("a", "b"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRetainAllOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        stack.retainAll(Arrays.asList("a", "b"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testTrimOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        stack.trim(3);
    }
}

