/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.it.util.cli;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.apache.maven.it.util.IOUtil;
import org.apache.maven.it.util.cli.StreamConsumer;

public class StreamPumper
extends Thread {
    private BufferedReader in;
    private StreamConsumer consumer = null;
    private PrintWriter out = null;
    private static final int SIZE = 1024;
    boolean done;

    public StreamPumper(InputStream in) {
        this.in = new BufferedReader(new InputStreamReader(in), 1024);
    }

    public StreamPumper(InputStream in, StreamConsumer consumer) {
        this(in);
        this.consumer = consumer;
    }

    public StreamPumper(InputStream in, PrintWriter writer) {
        this(in);
        this.out = writer;
    }

    public StreamPumper(InputStream in, PrintWriter writer, StreamConsumer consumer) {
        this(in);
        this.out = writer;
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object s;
        try {
            s = this.in.readLine();
            while (s != null) {
                this.consumeLine((String)s);
                if (this.out != null) {
                    this.out.println((String)s);
                    this.out.flush();
                }
                s = this.in.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(this.in);
            this.done = true;
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.notifyAll();
            }
        }
        finally {
            IOUtil.close(this.in);
            this.done = true;
            s = this;
            synchronized (s) {
                this.notifyAll();
            }
        }
    }

    public void flush() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() {
        IOUtil.close(this.out);
    }

    public boolean isDone() {
        return this.done;
    }

    private void consumeLine(String line) {
        if (this.consumer != null) {
            this.consumer.consumeLine(line);
        }
    }
}

