/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.it;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.Assert;
import org.apache.maven.it.Embedded3xLauncher;
import org.apache.maven.it.ForkedLauncher;
import org.apache.maven.it.LauncherException;
import org.apache.maven.it.MavenLauncher;
import org.apache.maven.it.VerificationException;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.shared.utils.cli.WriterStreamConsumer;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.io.IOUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Verifier {
    private static final String LOG_FILENAME = "log.txt";
    private static final String[] DEFAULT_CLI_OPTIONS = new String[]{"-e", "--batch-mode"};
    private String localRepo;
    private final String basedir;
    private final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
    private final ByteArrayOutputStream errStream = new ByteArrayOutputStream();
    private final String[] defaultCliOptions;
    private PrintStream originalOut;
    private PrintStream originalErr;
    private List<String> cliOptions = new ArrayList<String>();
    private Properties systemProperties = new Properties();
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    private Properties verifierProperties = new Properties();
    private boolean autoclean = true;
    private String localRepoLayout = "default";
    private boolean debug;
    private Boolean forkJvm;
    private String logFileName = "log.txt";
    private String defaultMavenHome;
    private String defaultClassworldConf;
    private String defaultClasspath;
    private boolean mavenDebug = false;
    private String forkMode;
    private boolean debugJvm = false;
    private static MavenLauncher embeddedLauncher;
    private static final String MARKER = "${artifact:";

    public Verifier(String basedir) throws VerificationException {
        this(basedir, null);
    }

    public Verifier(String basedir, boolean debug) throws VerificationException {
        this(basedir, null, debug);
    }

    public Verifier(String basedir, String settingsFile) throws VerificationException {
        this(basedir, settingsFile, false);
    }

    public Verifier(String basedir, String settingsFile, boolean debug) throws VerificationException {
        this(basedir, settingsFile, debug, DEFAULT_CLI_OPTIONS);
    }

    public Verifier(String basedir, String settingsFile, boolean debug, String[] defaultCliOptions) throws VerificationException {
        this(basedir, settingsFile, debug, null, defaultCliOptions);
    }

    public Verifier(String basedir, String settingsFile, boolean debug, boolean forkJvm) throws VerificationException {
        this(basedir, settingsFile, debug, forkJvm, DEFAULT_CLI_OPTIONS);
    }

    public Verifier(String basedir, String settingsFile, boolean debug, boolean forkJvm, String[] defaultCliOptions) throws VerificationException {
        this(basedir, settingsFile, debug, (Boolean)forkJvm, defaultCliOptions);
    }

    private Verifier(String basedir, String settingsFile, boolean debug, Boolean forkJvm, String[] defaultCliOptions) throws VerificationException {
        this.basedir = basedir;
        this.forkJvm = forkJvm;
        this.forkMode = System.getProperty("verifier.forkMode");
        if (!debug) {
            this.originalOut = System.out;
            this.originalErr = System.err;
        }
        this.setDebug(debug);
        this.findLocalRepo(settingsFile);
        this.findDefaultMavenHome();
        if (StringUtils.isEmpty((String)this.defaultMavenHome) && StringUtils.isEmpty((String)this.forkMode)) {
            this.forkMode = "auto";
        }
        this.defaultCliOptions = defaultCliOptions == null ? new String[]{} : (String[])defaultCliOptions.clone();
    }

    private void findDefaultMavenHome() throws VerificationException {
        File f;
        this.defaultClasspath = System.getProperty("maven.bootclasspath");
        this.defaultClassworldConf = System.getProperty("classworlds.conf");
        this.defaultMavenHome = System.getProperty("maven.home");
        if (this.defaultMavenHome == null) {
            Properties envVars = CommandLineUtils.getSystemEnvVars();
            this.defaultMavenHome = envVars.getProperty("M2_HOME");
        }
        if (this.defaultMavenHome == null && new File(f = new File(System.getProperty("user.home"), "m2"), "bin/mvn").isFile()) {
            this.defaultMavenHome = f.getAbsolutePath();
        }
    }

    public void setLocalRepo(String localRepo) {
        this.localRepo = localRepo;
    }

    public void resetStreams() {
        if (!this.debug) {
            System.setOut(this.originalOut);
            System.setErr(this.originalErr);
        }
    }

    public void displayStreamBuffers() {
        String err;
        String out = this.outStream.toString();
        if (out != null && out.trim().length() > 0) {
            System.out.println("----- Standard Out -----");
            System.out.println(out);
        }
        if ((err = this.errStream.toString()) != null && err.trim().length() > 0) {
            System.err.println("----- Standard Error -----");
            System.err.println(err);
        }
    }

    public void verify(boolean chokeOnErrorOutput) throws VerificationException {
        List<String> lines = this.loadFile(this.getBasedir(), "expected-results.txt", false);
        for (String line : lines) {
            this.verifyExpectedResult(line);
        }
        if (chokeOnErrorOutput) {
            this.verifyErrorFreeLog();
        }
    }

    public void verifyErrorFreeLog() throws VerificationException {
        List<String> lines = this.loadFile(this.getBasedir(), this.getLogFileName(), false);
        for (String line : lines) {
            if (!line.contains("[ERROR]") || Verifier.isVelocityError(line)) continue;
            throw new VerificationException("Error in execution: " + line);
        }
    }

    private static boolean isVelocityError(String line) {
        return line.contains("VM_global_library.vm") || line.contains("VM #") && line.contains("macro");
    }

    public void verifyTextInLog(String text) throws VerificationException {
        List<String> lines = this.loadFile(this.getBasedir(), this.getLogFileName(), false);
        boolean result = false;
        for (String line : lines) {
            if (!line.contains(text)) continue;
            result = true;
            break;
        }
        if (!result) {
            throw new VerificationException("Text not found in log: " + text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties(String filename) throws VerificationException {
        Properties properties;
        block6: {
            properties = new Properties();
            try {
                File propertiesFile = new File(this.getBasedir(), filename);
                if (!propertiesFile.exists()) break block6;
                FileInputStream fis = new FileInputStream(propertiesFile);
                try {
                    properties.load(fis);
                }
                finally {
                    fis.close();
                }
            }
            catch (FileNotFoundException e) {
                throw new VerificationException("Error reading properties file", e);
            }
            catch (IOException e) {
                throw new VerificationException("Error reading properties file", e);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> loadLines(String filename, String encoding) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        File file = new File(this.getBasedir(), filename);
        BufferedReader reader = null;
        try {
            String line;
            reader = StringUtils.isNotEmpty((String)encoding) ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding)) : new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0) continue;
                lines.add(line);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((Reader)reader);
        return lines;
    }

    public List<String> loadFile(String basedir, String filename, boolean hasCommand) throws VerificationException {
        return this.loadFile(new File(basedir, filename), hasCommand);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> loadFile(File file, boolean hasCommand) throws VerificationException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        if (!file.exists()) return lines;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).startsWith("#") && line.length() != 0) {
                    lines.addAll(this.replaceArtifacts(line, hasCommand));
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            try {
                throw new VerificationException(e);
                catch (IOException e2) {
                    throw new VerificationException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return lines;
    }

    private List<String> replaceArtifacts(String line, boolean hasCommand) {
        int index = line.indexOf(MARKER);
        if (index >= 0) {
            String filespec;
            String newLine = line.substring(0, index);
            if ((index = line.indexOf("}", index)) < 0) {
                throw new IllegalArgumentException("line does not contain ending artifact marker: '" + line + "'");
            }
            String artifact = line.substring(newLine.length() + MARKER.length(), index);
            newLine = newLine + this.getArtifactPath(artifact);
            newLine = newLine + line.substring(index + 1);
            ArrayList<String> l = new ArrayList<String>();
            l.add(newLine);
            int endIndex = newLine.lastIndexOf(47);
            String command = null;
            if (hasCommand) {
                int startIndex = newLine.indexOf(32);
                command = newLine.substring(0, startIndex);
                filespec = newLine.substring(startIndex + 1, endIndex);
            } else {
                filespec = newLine;
            }
            File dir = new File(filespec);
            Verifier.addMetadataToList(dir, hasCommand, l, command);
            Verifier.addMetadataToList(dir.getParentFile(), hasCommand, l, command);
            return l;
        }
        return Collections.singletonList(line);
    }

    private static void addMetadataToList(File dir, boolean hasCommand, List<String> l, String command) {
        if (dir.exists() && dir.isDirectory()) {
            String[] files;
            for (String file : files = dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("maven-metadata") && name.endsWith(".xml");
                }
            })) {
                if (hasCommand) {
                    l.add(command + " " + new File(dir, file).getPath());
                    continue;
                }
                l.add(new File(dir, file).getPath());
            }
        }
    }

    private String getArtifactPath(String artifact) {
        StringTokenizer tok = new StringTokenizer(artifact, ":");
        if (tok.countTokens() != 4) {
            throw new IllegalArgumentException("Artifact must have 4 tokens: '" + artifact + "'");
        }
        String[] a = new String[4];
        for (int i = 0; i < 4; ++i) {
            a[i] = tok.nextToken();
        }
        String org = a[0];
        String name = a[1];
        String version = a[2];
        String ext = a[3];
        return this.getArtifactPath(org, name, version, ext);
    }

    public String getArtifactPath(String org, String name, String version, String ext) {
        return this.getArtifactPath(org, name, version, ext, null);
    }

    public String getArtifactPath(String gid, String aid, String version, String ext, String classifier) {
        String repositoryPath;
        if (classifier != null && classifier.length() == 0) {
            classifier = null;
        }
        if ("maven-plugin".equals(ext)) {
            ext = "jar";
        }
        if ("coreit-artifact".equals(ext)) {
            ext = "jar";
            classifier = "it";
        }
        if ("test-jar".equals(ext)) {
            ext = "jar";
            classifier = "tests";
        }
        if ("legacy".equals(this.localRepoLayout)) {
            repositoryPath = gid + "/" + ext + "s/" + aid + "-" + version + "." + ext;
        } else if ("default".equals(this.localRepoLayout)) {
            repositoryPath = gid.replace('.', '/');
            repositoryPath = repositoryPath + "/" + aid + "/" + version;
            repositoryPath = repositoryPath + "/" + aid + "-" + version;
            if (classifier != null) {
                repositoryPath = repositoryPath + "-" + classifier;
            }
            repositoryPath = repositoryPath + "." + ext;
        } else {
            throw new IllegalStateException("Unknown layout: " + this.localRepoLayout);
        }
        return this.localRepo + "/" + repositoryPath;
    }

    public List<String> getArtifactFileNameList(String org, String name, String version, String ext) {
        ArrayList<String> files = new ArrayList<String>();
        String artifactPath = this.getArtifactPath(org, name, version, ext);
        File dir = new File(artifactPath);
        files.add(artifactPath);
        Verifier.addMetadataToList(dir, false, files, null);
        Verifier.addMetadataToList(dir.getParentFile(), false, files, null);
        return files;
    }

    public String getArtifactMetadataPath(String gid, String aid, String version) {
        return this.getArtifactMetadataPath(gid, aid, version, "maven-metadata-local.xml");
    }

    public String getArtifactMetadataPath(String gid, String aid, String version, String filename) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.localRepo);
        buffer.append('/');
        if ("default".equals(this.localRepoLayout)) {
            buffer.append(gid.replace('.', '/'));
            buffer.append('/');
            if (aid != null) {
                buffer.append(aid);
                buffer.append('/');
                if (version != null) {
                    buffer.append(version);
                    buffer.append('/');
                }
            }
        } else {
            throw new IllegalStateException("Unsupported repository layout: " + this.localRepoLayout);
        }
        buffer.append(filename);
        return buffer.toString();
    }

    public String getArtifactMetadataPath(String gid, String aid) {
        return this.getArtifactMetadataPath(gid, aid, null);
    }

    public void executeHook(String filename) throws VerificationException {
        try {
            File f = new File(this.getBasedir(), filename);
            if (!f.exists()) {
                return;
            }
            List<String> lines = this.loadFile(f, true);
            for (String line1 : lines) {
                String line = this.resolveCommandLineArg(line1);
                this.executeCommand(line);
            }
        }
        catch (VerificationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VerificationException(e);
        }
    }

    private void executeCommand(String line) throws VerificationException {
        String cmd;
        int index = line.indexOf(" ");
        String args = null;
        if (index >= 0) {
            cmd = line.substring(0, index);
            args = line.substring(index + 1);
        } else {
            cmd = line;
        }
        if ("rm".equals(cmd)) {
            System.out.println("Removing file: " + args);
            File f = new File(args);
            if (f.exists() && !f.delete()) {
                throw new VerificationException("Error removing file - delete failed");
            }
        } else if ("rmdir".equals(cmd)) {
            System.out.println("Removing directory: " + args);
            try {
                File f = new File(args);
                FileUtils.deleteDirectory((File)f);
            }
            catch (IOException e) {
                throw new VerificationException("Error removing directory - delete failed");
            }
        } else if ("svn".equals(cmd)) {
            Verifier.launchSubversion(line, this.getBasedir());
        } else {
            throw new VerificationException("unknown command: " + cmd);
        }
    }

    public static void launchSubversion(String line, String basedir) throws VerificationException {
        try {
            Commandline cli = new Commandline(line);
            cli.setWorkingDirectory(basedir);
            FileWriter logWriter = new FileWriter(new File(basedir, LOG_FILENAME));
            WriterStreamConsumer out = new WriterStreamConsumer((Writer)logWriter);
            WriterStreamConsumer err = new WriterStreamConsumer((Writer)logWriter);
            System.out.println("Command: " + CommandLineUtils.toString((String[])cli.getCommandline()));
            int ret = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
            ((Writer)logWriter).close();
            if (ret > 0) {
                System.err.println("Exit code: " + ret);
                throw new VerificationException();
            }
        }
        catch (CommandLineException e) {
            throw new VerificationException(e);
        }
        catch (IOException e) {
            throw new VerificationException(e);
        }
    }

    private static String retrieveLocalRepo(String settingsXmlPath) throws VerificationException {
        File userXml;
        UserModelReader userModelReader = new UserModelReader();
        String userHome = System.getProperty("user.home");
        String repo = null;
        if (settingsXmlPath != null) {
            System.out.println("Using settings from " + settingsXmlPath);
            userXml = new File(settingsXmlPath);
        } else {
            userXml = new File(userHome, ".m2/settings.xml");
        }
        if (userXml.exists()) {
            userModelReader.parse(userXml);
            String localRepository = userModelReader.getLocalRepository();
            if (localRepository != null) {
                repo = new File(localRepository).getAbsolutePath();
            }
        }
        return repo;
    }

    public void deleteArtifact(String org, String name, String version, String ext) throws IOException {
        List<String> files = this.getArtifactFileNameList(org, name, version, ext);
        for (String fileName : files) {
            FileUtils.forceDelete((File)new File(fileName));
        }
    }

    public void deleteArtifacts(String gid) throws IOException {
        String path;
        if ("default".equals(this.localRepoLayout)) {
            path = gid.replace('.', '/');
        } else if ("legacy".equals(this.localRepoLayout)) {
            path = gid;
        } else {
            throw new IllegalStateException("Unsupported repository layout: " + this.localRepoLayout);
        }
        FileUtils.deleteDirectory((File)new File(this.localRepo, path));
    }

    public void deleteArtifacts(String gid, String aid, String version) throws IOException {
        if (!"default".equals(this.localRepoLayout)) {
            throw new IllegalStateException("Unsupported repository layout: " + this.localRepoLayout);
        }
        String path = gid.replace('.', '/') + '/' + aid + '/' + version;
        FileUtils.deleteDirectory((File)new File(this.localRepo, path));
    }

    public void deleteDirectory(String path) throws IOException {
        FileUtils.deleteDirectory((File)new File(this.getBasedir(), path));
    }

    public void writeFile(String path, String contents) throws IOException {
        FileUtils.fileWrite((String)new File(this.getBasedir(), path).getAbsolutePath(), (String)"UTF-8", (String)contents);
    }

    public File filterFile(String srcPath, String dstPath, String fileEncoding, Map<String, String> filterProperties) throws IOException {
        File srcFile = new File(this.getBasedir(), srcPath);
        String data = FileUtils.fileRead((File)srcFile, (String)fileEncoding);
        for (String token : filterProperties.keySet()) {
            String value = String.valueOf(filterProperties.get(token));
            data = StringUtils.replace((String)data, (String)token, (String)value);
        }
        File dstFile = new File(this.getBasedir(), dstPath);
        dstFile.getParentFile().mkdirs();
        FileUtils.fileWrite((String)dstFile.getPath(), (String)fileEncoding, (String)data);
        return dstFile;
    }

    public File filterFile(String srcPath, String dstPath, String fileEncoding, Properties filterProperties) throws IOException {
        return this.filterFile(srcPath, dstPath, fileEncoding, (Map<String, String>)filterProperties);
    }

    public Properties newDefaultFilterProperties() {
        Properties filterProperties = new Properties();
        String basedir = new File(this.getBasedir()).getAbsolutePath();
        filterProperties.put("@basedir@", basedir);
        String baseurl = basedir;
        if (!baseurl.startsWith("/")) {
            baseurl = '/' + baseurl;
        }
        baseurl = "file://" + baseurl.replace('\\', '/');
        filterProperties.put("@baseurl@", baseurl);
        return filterProperties;
    }

    public void assertFilePresent(String file) {
        try {
            this.verifyExpectedResult(file, true);
        }
        catch (VerificationException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void assertFileMatches(String file, String regex) {
        this.assertFilePresent(file);
        try {
            String content = FileUtils.fileRead((String)file);
            if (!Pattern.matches(regex, content)) {
                Assert.fail((String)("Content of " + file + " does not match " + regex));
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void assertFileNotPresent(String file) {
        try {
            this.verifyExpectedResult(file, false);
        }
        catch (VerificationException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void verifyArtifactPresence(boolean wanted, String org, String name, String version, String ext) {
        List<String> files = this.getArtifactFileNameList(org, name, version, ext);
        for (String fileName : files) {
            try {
                this.verifyExpectedResult(fileName, wanted);
            }
            catch (VerificationException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    public void assertArtifactPresent(String org, String name, String version, String ext) {
        this.verifyArtifactPresence(true, org, name, version, ext);
    }

    public void assertArtifactNotPresent(String org, String name, String version, String ext) {
        this.verifyArtifactPresence(false, org, name, version, ext);
    }

    private void verifyExpectedResult(String line) throws VerificationException {
        boolean wanted = true;
        if (line.startsWith("!")) {
            line = line.substring(1);
            wanted = false;
        }
        this.verifyExpectedResult(line, wanted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyExpectedResult(String line, boolean wanted) throws VerificationException {
        if (line.indexOf("!/") > 0) {
            String urlString = "jar:file:" + this.getBasedir() + "/" + line;
            InputStream is = null;
            try {
                URL url = new URL(urlString);
                is = url.openStream();
                if (is == null) {
                    if (!wanted) return;
                    throw new VerificationException("Expected JAR resource was not found: " + line);
                }
                if (wanted) return;
                throw new VerificationException("Unwanted JAR resource was found: " + line);
            }
            catch (MalformedURLException e) {
                throw new VerificationException("Error looking for JAR resource", e);
            }
            catch (IOException e) {
                if (!wanted) return;
                throw new VerificationException("Error looking for JAR resource: " + line);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        System.err.println("WARN: error closing stream: " + e);
                    }
                }
            }
        }
        File expectedFile = new File(line);
        if (!expectedFile.isAbsolute() && !expectedFile.getPath().startsWith(File.separator)) {
            expectedFile = new File(this.getBasedir(), line);
        }
        if (line.indexOf(42) > -1) {
            File parent = expectedFile.getParentFile();
            if (!parent.exists()) {
                if (!wanted) return;
                throw new VerificationException("Expected file pattern was not found: " + expectedFile.getPath());
            }
            String shortNamePattern = expectedFile.getName().replaceAll("\\*", ".*");
            String[] candidates = parent.list();
            boolean found = false;
            if (candidates != null) {
                for (String candidate : candidates) {
                    if (!candidate.matches(shortNamePattern)) continue;
                    found = true;
                    break;
                }
            }
            if (!found && wanted) {
                throw new VerificationException("Expected file pattern was not found: " + expectedFile.getPath());
            }
            if (!found || wanted) return;
            throw new VerificationException("Unwanted file pattern was found: " + expectedFile.getPath());
        }
        if (!expectedFile.exists()) {
            if (!wanted) return;
            throw new VerificationException("Expected file was not found: " + expectedFile.getPath());
        }
        if (wanted) return;
        throw new VerificationException("Unwanted file was found: " + expectedFile.getPath());
    }

    public void executeGoal(String goal) throws VerificationException {
        this.executeGoal(goal, this.environmentVariables);
    }

    public void executeGoal(String goal, Map<String, String> envVars) throws VerificationException {
        this.executeGoals(Arrays.asList(goal), envVars);
    }

    public void executeGoals(List<String> goals) throws VerificationException {
        this.executeGoals(goals, this.environmentVariables);
    }

    public String getExecutable() {
        String mavenHome = this.defaultMavenHome;
        if (mavenHome != null) {
            return mavenHome + "/bin/mvn";
        }
        File f = new File(System.getProperty("user.home"), "m2/bin/mvn");
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return "mvn";
    }

    public void executeGoals(List<String> goals, Map<String, String> envVars) throws VerificationException {
        int ret;
        boolean useMavenRepoLocal;
        ArrayList<String> allGoals = new ArrayList<String>();
        if (this.autoclean) {
            allGoals.add("org.apache.maven.plugins:maven-clean-plugin:clean");
        }
        allGoals.addAll(goals);
        ArrayList<String> args = new ArrayList<String>();
        File logFile = new File(this.getBasedir(), this.getLogFileName());
        for (String cliOption : this.cliOptions) {
            String key = String.valueOf(cliOption);
            String resolvedArg = this.resolveCommandLineArg(key);
            try {
                args.addAll(Arrays.asList(CommandLineUtils.translateCommandline((String)resolvedArg)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Collections.addAll(args, this.defaultCliOptions);
        if (this.mavenDebug) {
            args.add("--debug");
        }
        if (useMavenRepoLocal = Boolean.valueOf(this.verifierProperties.getProperty("use.mavenRepoLocal", "true")).booleanValue()) {
            args.add("-Dmaven.repo.local=" + this.localRepo);
        }
        args.addAll(allGoals);
        try {
            String[] cliArgs = args.toArray(new String[args.size()]);
            MavenLauncher launcher = this.getMavenLauncher(envVars);
            ret = launcher.run(cliArgs, this.systemProperties, this.getBasedir(), logFile);
        }
        catch (LauncherException e) {
            throw new VerificationException("Failed to execute Maven: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new VerificationException(e);
        }
        if (ret > 0) {
            System.err.println("Exit code: " + ret);
            throw new VerificationException("Exit code was non-zero: " + ret + "; command line and log = \n" + new File(this.defaultMavenHome, "bin/mvn") + " " + StringUtils.join(args.iterator(), (String)" ") + "\n" + Verifier.getLogContents(logFile));
        }
    }

    private MavenLauncher getMavenLauncher(Map<String, String> envVars) throws LauncherException {
        boolean fork;
        if (this.forkJvm != null) {
            fork = this.forkJvm;
        } else if (envVars.isEmpty() && "auto".equalsIgnoreCase(this.forkMode) || "embedded".equalsIgnoreCase(this.forkMode)) {
            fork = false;
            try {
                this.initEmbeddedLauncher();
            }
            catch (Exception e) {
                fork = true;
            }
        } else {
            fork = true;
        }
        if (!fork) {
            if (!envVars.isEmpty()) {
                throw new LauncherException("Environment variables are not supported in embedded runtime");
            }
            this.initEmbeddedLauncher();
            return embeddedLauncher;
        }
        return new ForkedLauncher(this.defaultMavenHome, envVars, this.debugJvm);
    }

    private void initEmbeddedLauncher() throws LauncherException {
        if (embeddedLauncher == null) {
            embeddedLauncher = StringUtils.isEmpty((String)this.defaultMavenHome) ? Embedded3xLauncher.createFromClasspath() : Embedded3xLauncher.createFromMavenHome(this.defaultMavenHome, this.defaultClassworldConf, this.getClasspath());
        }
    }

    private List<URL> getClasspath() throws LauncherException {
        if (this.defaultClasspath == null) {
            return null;
        }
        ArrayList<URL> classpath = new ArrayList<URL>();
        StringTokenizer st = new StringTokenizer(this.defaultClasspath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            try {
                classpath.add(new File(st.nextToken()).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new LauncherException("Invalid launcher classpath " + this.defaultClasspath, e);
            }
        }
        return classpath;
    }

    public String getMavenVersion() throws VerificationException {
        try {
            return this.getMavenLauncher(Collections.<String, String>emptyMap()).getMavenVersion();
        }
        catch (LauncherException e) {
            throw new VerificationException(e);
        }
        catch (IOException e) {
            throw new VerificationException(e);
        }
    }

    private static String getLogContents(File logFile) {
        try {
            return FileUtils.fileRead((File)logFile);
        }
        catch (IOException e) {
            return "(Error reading log contents: " + e.getMessage() + ")";
        }
    }

    private String resolveCommandLineArg(String key) {
        String result = key.replaceAll("\\$\\{basedir\\}", this.getBasedir());
        if (result.contains("\\\\")) {
            result = result.replaceAll("\\\\", "\\");
        }
        result = result.replaceAll("\\/\\/", "\\/");
        return result;
    }

    private static List<String> discoverIntegrationTests(String directory) throws VerificationException {
        try {
            ArrayList<String> tests = new ArrayList<String>();
            List subTests = FileUtils.getFiles((File)new File(directory), (String)"**/goals.txt", null);
            for (File testCase : subTests) {
                tests.add(testCase.getParent());
            }
            return tests;
        }
        catch (IOException e) {
            throw new VerificationException(directory + " is not a valid test case container", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void displayLogFile() {
        System.out.println("Log file contents:");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(new File(this.getBasedir(), this.getLogFileName())));
            String line = reader.readLine();
            while (line != null) {
                System.out.println(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: " + e);
            IOUtil.close((Reader)reader);
        }
        catch (IOException e2) {
            System.err.println("Error: " + e2);
            {
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            IOUtil.close((Reader)reader);
        }
        IOUtil.close((Reader)reader);
    }

    public static void main(String[] args) throws VerificationException {
        String basedir = System.getProperty("user.dir");
        List<Object> tests = null;
        ArrayList<String> argsList = new ArrayList<String>();
        String settingsFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-D")) {
                int index = args[i].indexOf("=");
                if (index >= 0) {
                    System.setProperty(args[i].substring(2, index), args[i].substring(index + 1));
                    continue;
                }
                System.setProperty(args[i].substring(2), "true");
                continue;
            }
            if ("-s".equals(args[i]) || "--settings".equals(args[i])) {
                if (i == args.length - 1) {
                    throw new IllegalStateException("missing argument to -s");
                }
                settingsFile = args[++i];
                continue;
            }
            if (args[i].startsWith("-")) {
                System.out.println("skipping unrecognised argument: " + args[i]);
                continue;
            }
            argsList.add(args[i]);
        }
        if (argsList.size() == 0) {
            if (FileUtils.fileExists((String)(basedir + File.separator + "integration-tests.txt"))) {
                try {
                    tests = FileUtils.loadFile((File)new File(basedir, "integration-tests.txt"));
                }
                catch (IOException e) {
                    System.err.println("Unable to load integration tests file");
                    System.err.println(e.getMessage());
                    System.exit(2);
                }
            } else {
                tests = Verifier.discoverIntegrationTests(".");
            }
        } else {
            tests = new ArrayList(argsList.size());
            DecimalFormat fmt = new DecimalFormat("0000");
            for (String test : argsList) {
                if (test.endsWith(",")) {
                    test = test.substring(0, test.length() - 1);
                }
                if (StringUtils.isNumeric((String)test)) {
                    test = "it" + fmt.format(Integer.valueOf(test));
                    tests.add(test.trim());
                    continue;
                }
                if ("it".startsWith(test)) {
                    if ((test = test.trim()).length() <= 0) continue;
                    tests.add(test);
                    continue;
                }
                if (FileUtils.fileExists((String)test) && new File(test).isDirectory()) {
                    tests.addAll(Verifier.discoverIntegrationTests(test));
                    continue;
                }
                System.err.println("[WARNING] rejecting " + test + " as an invalid test or test source directory");
            }
        }
        if (tests.size() == 0) {
            System.out.println("No tests to run");
        }
        int exitCode = 0;
        ArrayList<String> failed = new ArrayList<String>();
        for (String string : tests) {
            System.out.print(string + "... ");
            String dir = basedir + "/" + string;
            if (!new File(dir, "goals.txt").exists()) {
                System.err.println("Test " + string + " in " + dir + " does not exist");
                System.exit(2);
            }
            Verifier verifier = new Verifier(dir);
            verifier.findLocalRepo(settingsFile);
            System.out.println("Using default local repository: " + verifier.localRepo);
            try {
                Verifier.runIntegrationTest(verifier);
            }
            catch (Throwable e) {
                verifier.resetStreams();
                System.out.println("FAILED");
                verifier.displayStreamBuffers();
                System.out.println(">>>>>> Error Stacktrace:");
                e.printStackTrace(System.out);
                System.out.println("<<<<<< Error Stacktrace");
                verifier.displayLogFile();
                exitCode = 1;
                failed.add(string);
            }
        }
        System.out.println(tests.size() - failed.size() + "/" + tests.size() + " passed");
        if (!failed.isEmpty()) {
            System.out.println("Failed tests: " + failed);
        }
        System.exit(exitCode);
    }

    private void findLocalRepo(String settingsFile) throws VerificationException {
        File repoDir;
        if (this.localRepo == null) {
            this.localRepo = System.getProperty("maven.repo.local");
        }
        if (this.localRepo == null) {
            this.localRepo = Verifier.retrieveLocalRepo(settingsFile);
        }
        if (this.localRepo == null) {
            this.localRepo = System.getProperty("user.home") + "/.m2/repository";
        }
        if (!(repoDir = new File(this.localRepo)).exists()) {
            repoDir.mkdirs();
        }
        this.localRepo = repoDir.getAbsolutePath();
        this.localRepoLayout = System.getProperty("maven.repo.local.layout", "default");
    }

    private static void runIntegrationTest(Verifier verifier) throws VerificationException {
        verifier.executeHook("prebuild-hook.txt");
        Properties properties = verifier.loadProperties("system.properties");
        Properties controlProperties = verifier.loadProperties("verifier.properties");
        boolean chokeOnErrorOutput = Boolean.valueOf(controlProperties.getProperty("failOnErrorOutput", "true"));
        List<String> goals = verifier.loadFile(verifier.getBasedir(), "goals.txt", false);
        List<String> cliOptions = verifier.loadFile(verifier.getBasedir(), "cli-options.txt", false);
        verifier.setCliOptions(cliOptions);
        verifier.setSystemProperties(properties);
        verifier.setVerifierProperties(controlProperties);
        verifier.executeGoals(goals);
        verifier.executeHook("postbuild-hook.txt");
        System.out.println("*** Verifying: fail when [ERROR] detected? " + chokeOnErrorOutput + " ***");
        verifier.verify(chokeOnErrorOutput);
        verifier.resetStreams();
        System.out.println("OK");
    }

    public void assertArtifactContents(String org, String artifact, String version, String type, String contents) throws IOException {
        String fileName = this.getArtifactPath(org, artifact, version, type);
        Assert.assertEquals((String)contents, (String)FileUtils.fileRead((String)fileName));
    }

    public List<String> getCliOptions() {
        return this.cliOptions;
    }

    public void setCliOptions(List<String> cliOptions) {
        this.cliOptions = cliOptions;
    }

    public void addCliOption(String option) {
        this.cliOptions.add(option);
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void setSystemProperty(String key, String value) {
        if (value != null) {
            this.systemProperties.setProperty(key, value);
        } else {
            this.systemProperties.remove(key);
        }
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void setEnvironmentVariable(String key, String value) {
        if (value != null) {
            this.environmentVariables.put(key, value);
        } else {
            this.environmentVariables.remove(key);
        }
    }

    public Properties getVerifierProperties() {
        return this.verifierProperties;
    }

    public void setVerifierProperties(Properties verifierProperties) {
        this.verifierProperties = verifierProperties;
    }

    public boolean isAutoclean() {
        return this.autoclean;
    }

    public void setAutoclean(boolean autoclean) {
        this.autoclean = autoclean;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        if (StringUtils.isEmpty((String)logFileName)) {
            throw new IllegalArgumentException("log file name unspecified");
        }
        this.logFileName = logFileName;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        if (!debug) {
            System.setOut(new PrintStream(this.outStream));
            System.setErr(new PrintStream(this.errStream));
        }
    }

    public boolean isMavenDebug() {
        return this.mavenDebug;
    }

    public void setMavenDebug(boolean mavenDebug) {
        this.mavenDebug = mavenDebug;
    }

    public void setForkJvm(boolean forkJvm) {
        this.forkJvm = forkJvm;
    }

    public boolean isDebugJvm() {
        return this.debugJvm;
    }

    public void setDebugJvm(boolean debugJvm) {
        this.debugJvm = debugJvm;
    }

    public String getLocalRepoLayout() {
        return this.localRepoLayout;
    }

    public void setLocalRepoLayout(String localRepoLayout) {
        this.localRepoLayout = localRepoLayout;
    }

    public String getLocalRepository() {
        return this.localRepo;
    }

    static class UserModelReader
    extends DefaultHandler {
        private String localRepository;
        private StringBuffer currentBody = new StringBuffer();

        UserModelReader() {
        }

        public void parse(File file) throws VerificationException {
            try {
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                SAXParser parser = saxFactory.newSAXParser();
                InputSource is = new InputSource(new FileInputStream(file));
                parser.parse(is, (DefaultHandler)this);
            }
            catch (FileNotFoundException e) {
                throw new VerificationException("file not found path : " + file.getAbsolutePath(), e);
            }
            catch (IOException e) {
                throw new VerificationException(" IOException path : " + file.getAbsolutePath(), e);
            }
            catch (ParserConfigurationException e) {
                throw new VerificationException(e);
            }
            catch (SAXException e) {
                throw new VerificationException("Parsing exception for file " + file.getAbsolutePath(), e);
            }
        }

        public void warning(SAXParseException spe) {
            this.printParseError("Warning", spe);
        }

        public void error(SAXParseException spe) {
            this.printParseError("Error", spe);
        }

        public void fatalError(SAXParseException spe) {
            this.printParseError("Fatal Error", spe);
        }

        private void printParseError(String type, SAXParseException spe) {
            System.err.println(type + " [line " + spe.getLineNumber() + ", row " + spe.getColumnNumber() + "]: " + spe.getMessage());
        }

        public String getLocalRepository() {
            return this.localRepository;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currentBody.append(ch, start, length);
        }

        public void endElement(String uri, String localName, String rawName) throws SAXException {
            if ("localRepository".equals(rawName)) {
                if (this.notEmpty(this.currentBody.toString())) {
                    this.localRepository = this.currentBody.toString().trim();
                } else {
                    throw new SAXException("Invalid mavenProfile entry. Missing one or more fields: {localRepository}.");
                }
            }
            this.currentBody = new StringBuffer();
        }

        private boolean notEmpty(String test) {
            return test != null && test.trim().length() > 0;
        }

        public void reset() {
            this.currentBody = null;
            this.localRepository = null;
        }
    }
}

