/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.openid;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OpenIDRegistrationConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient boolean enableRegistration;
    private transient String userTemplateDirectory;
    private transient String subsiteRootFolder;
    private transient List<String> roles;
    private transient List<String> groups;
    private transient Map<String, String> profilerRules;

    public void merge(OpenIDRegistrationConfiguration defaults) {
        if (defaults != null) {
            if (this.userTemplateDirectory == null) {
                this.userTemplateDirectory = defaults.userTemplateDirectory;
            }
            if (this.subsiteRootFolder == null) {
                this.subsiteRootFolder = defaults.subsiteRootFolder;
            }
            if (this.roles == null) {
                this.roles = defaults.roles;
            }
            if (this.groups == null) {
                this.groups = defaults.groups;
            }
            if (this.profilerRules == null) {
                this.profilerRules = defaults.profilerRules;
            }
        }
    }

    public boolean isEnableRegistration() {
        return this.enableRegistration;
    }

    public void setEnableRegistration(boolean enableRegistration) {
        this.enableRegistration = enableRegistration;
    }

    public void setEnableRegistration(String enableRegistration) {
        this.enableRegistration = Boolean.parseBoolean(enableRegistration);
    }

    public String getUserTemplateDirectory() {
        return this.userTemplateDirectory;
    }

    public void setUserTemplateDirectory(String userTemplateDirectory) {
        this.userTemplateDirectory = userTemplateDirectory;
    }

    public String getSubsiteRootFolder() {
        return this.subsiteRootFolder;
    }

    public void setSubsiteRootFolder(String subsiteRootFolder) {
        this.subsiteRootFolder = subsiteRootFolder;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setRoles(String roles) {
        this.roles = OpenIDRegistrationConfiguration.parseParameterList(roles);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public void setGroups(String groups) {
        this.groups = OpenIDRegistrationConfiguration.parseParameterList(groups);
    }

    public Map<String, String> getProfilerRules() {
        return this.profilerRules;
    }

    public void setProfilerRules(Map<String, String> profilerRules) {
        this.profilerRules = profilerRules;
    }

    public void setProfilerRules(List<String> profilerRuleNames, List<String> profilerRuleValues) {
        if (profilerRuleNames != null && profilerRuleValues != null) {
            this.profilerRules = new HashMap<String, String>();
            Iterator<String> namesIter = profilerRuleNames.iterator();
            Iterator<String> valuesIter = profilerRuleValues.iterator();
            while (namesIter.hasNext() && valuesIter.hasNext()) {
                this.profilerRules.put(namesIter.next(), valuesIter.next());
            }
        } else {
            this.profilerRules = null;
        }
    }

    public void setProfilerRules(String profilerRuleNames, String profilerRuleValues) {
        this.setProfilerRules(OpenIDRegistrationConfiguration.parseParameterList(profilerRuleNames), OpenIDRegistrationConfiguration.parseParameterList(profilerRuleValues));
    }

    public static List<String> parseParameterList(String parameterList) {
        if (parameterList != null) {
            String[] params = parameterList.split("[,]");
            for (int i = 0; i < params.length; ++i) {
                params[i] = params[i].trim();
            }
            return Arrays.asList(params);
        }
        return null;
    }
}

