/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.MutableBlobProperties;
import org.jclouds.azureblob.functions.ParseBlobPropertiesFromHeaders;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;

@Singleton
public class ParseBlobFromHeadersAndHttpContent
implements Function<HttpResponse, AzureBlob>,
InvocationContext<ParseBlobFromHeadersAndHttpContent> {
    private final ParseBlobPropertiesFromHeaders metadataParser;
    private final AzureBlob.Factory blobFactory;

    @Inject
    public ParseBlobFromHeadersAndHttpContent(ParseBlobPropertiesFromHeaders metadataParser, AzureBlob.Factory blobFactory) {
        this.metadataParser = metadataParser;
        this.blobFactory = blobFactory;
    }

    @Override
    public AzureBlob apply(HttpResponse from) {
        MutableBlobProperties metadata = this.metadataParser.apply(from);
        AzureBlob blob = this.blobFactory.create(metadata);
        blob.getAllHeaders().putAll(from.getHeaders());
        blob.setPayload(from.getPayload());
        return blob;
    }

    @Override
    public ParseBlobFromHeadersAndHttpContent setContext(HttpRequest request) {
        this.metadataParser.setContext(request);
        return this;
    }
}

