/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.config;

import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.com.google.inject.Scopes;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Provider;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.internal.BlobImpl;

public class BlobStoreObjectModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(Blob.Factory.class).to(BlobFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    final Blob provideBlob(Blob.Factory factory) {
        return factory.create(null);
    }

    private static class BlobFactory
    implements Blob.Factory {
        @Inject
        Provider<MutableBlobMetadata> metadataProvider;

        private BlobFactory() {
        }

        @Override
        public Blob create(MutableBlobMetadata metadata) {
            return new BlobImpl(metadata != null ? metadata : this.metadataProvider.get());
        }
    }
}

