/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.influxdb.v1;

import com.google.common.base.Strings;
import java.util.Arrays;
import lombok.Generated;
import org.apache.pulsar.io.influxdb.v1.InfluxDBBuilder;
import org.apache.pulsar.io.influxdb.v1.InfluxDBSinkConfig;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBBuilderImpl
implements InfluxDBBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InfluxDBBuilderImpl.class);

    @Override
    public InfluxDB build(InfluxDBSinkConfig config) {
        InfluxDB.LogLevel logLevel;
        InfluxDB influxDB;
        boolean enableAuth;
        boolean bl = enableAuth = !Strings.isNullOrEmpty((String)config.getUsername());
        if (enableAuth) {
            log.info("Authenticating to {} as {}", (Object)config.getInfluxdbUrl(), (Object)config.getUsername());
            influxDB = InfluxDBFactory.connect((String)config.getInfluxdbUrl(), (String)config.getUsername(), (String)config.getPassword());
        } else {
            log.info("Connecting to {}", (Object)config.getInfluxdbUrl());
            influxDB = InfluxDBFactory.connect((String)config.getInfluxdbUrl());
        }
        if (config.isGzipEnable()) {
            influxDB.enableGzip();
        }
        try {
            logLevel = InfluxDB.LogLevel.valueOf((String)config.getLogLevel().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal Log Level, valid values are: " + Arrays.asList(InfluxDB.LogLevel.values()));
        }
        influxDB.setLogLevel(logLevel);
        return influxDB;
    }
}

