/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kinesis.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;

public class JsonConverter {
    private static final Map<String, LogicalTypeConverter<?>> logicalTypeConverters = new HashMap();
    private static final JsonNodeFactory jsonNodeFactory = JsonNodeFactory.withExactBigDecimals((boolean)true);

    public static JsonNode toJson(GenericRecord genericRecord) {
        if (genericRecord == null) {
            return null;
        }
        ObjectNode objectNode = jsonNodeFactory.objectNode();
        for (Schema.Field field : genericRecord.getSchema().getFields()) {
            objectNode.set(field.name(), JsonConverter.toJson(field.schema(), genericRecord.get(field.name())));
        }
        return objectNode;
    }

    public static JsonNode toJson(Schema schema, Object value) {
        if (schema.getLogicalType() != null && logicalTypeConverters.containsKey(schema.getLogicalType().getName())) {
            return logicalTypeConverters.get(schema.getLogicalType().getName()).toJson(schema, value);
        }
        if (value == null) {
            return jsonNodeFactory.nullNode();
        }
        switch (schema.getType()) {
            case NULL: {
                return jsonNodeFactory.nullNode();
            }
            case INT: {
                return jsonNodeFactory.numberNode((Integer)value);
            }
            case LONG: {
                return jsonNodeFactory.numberNode((Long)value);
            }
            case DOUBLE: {
                return jsonNodeFactory.numberNode((Double)value);
            }
            case FLOAT: {
                return jsonNodeFactory.numberNode((Float)value);
            }
            case BOOLEAN: {
                return jsonNodeFactory.booleanNode(((Boolean)value).booleanValue());
            }
            case BYTES: {
                return jsonNodeFactory.binaryNode((byte[])value);
            }
            case FIXED: {
                return jsonNodeFactory.binaryNode(((GenericFixed)value).bytes());
            }
            case ENUM: 
            case STRING: {
                return jsonNodeFactory.textNode(value.toString());
            }
            case ARRAY: {
                Schema elementSchema = schema.getElementType();
                ArrayNode arrayNode = jsonNodeFactory.arrayNode();
                Object[] iterable = value instanceof GenericData.Array ? ((GenericData.Array)value).toArray() : (Object[])value;
                for (Object elem : iterable) {
                    JsonNode fieldValue = JsonConverter.toJson(elementSchema, elem);
                    arrayNode.add(fieldValue);
                }
                return arrayNode;
            }
            case MAP: {
                Map map = (Map)value;
                ObjectNode objectNode = jsonNodeFactory.objectNode();
                for (Map.Entry entry : map.entrySet()) {
                    JsonNode jsonNode = JsonConverter.toJson(schema.getValueType(), entry.getValue());
                    String entryKey = entry.getKey() == null ? null : entry.getKey().toString();
                    objectNode.set(entryKey, jsonNode);
                }
                return objectNode;
            }
            case RECORD: {
                return JsonConverter.toJson((GenericRecord)value);
            }
            case UNION: {
                for (Schema s : schema.getTypes()) {
                    if (s.getType() == Schema.Type.NULL) continue;
                    return JsonConverter.toJson(s, value);
                }
                return jsonNodeFactory.textNode(value.toString());
            }
        }
        throw new UnsupportedOperationException("Unknown AVRO schema type=" + schema.getType());
    }

    static {
        logicalTypeConverters.put("decimal", new LogicalTypeConverter<BigDecimal>((Conversion)new Conversions.DecimalConversion()){

            @Override
            JsonNode toJson(Schema schema, Object value) {
                if (!(value instanceof BigDecimal)) {
                    throw new IllegalArgumentException("Invalid type for Decimal, expected BigDecimal but was " + value.getClass());
                }
                BigDecimal decimal = (BigDecimal)value;
                return jsonNodeFactory.numberNode(decimal);
            }
        });
        logicalTypeConverters.put("date", new LogicalTypeConverter<LocalDate>((Conversion)new TimeConversions.DateConversion()){

            @Override
            JsonNode toJson(Schema schema, Object value) {
                if (!(value instanceof Integer)) {
                    throw new IllegalArgumentException("Invalid type for date, expected Integer but was " + value.getClass());
                }
                Integer daysFromEpoch = (Integer)value;
                return jsonNodeFactory.numberNode(daysFromEpoch);
            }
        });
        logicalTypeConverters.put("time-millis", new LogicalTypeConverter<LocalTime>((Conversion)new TimeConversions.TimeMillisConversion()){

            @Override
            JsonNode toJson(Schema schema, Object value) {
                if (!(value instanceof Integer)) {
                    throw new IllegalArgumentException("Invalid type for time-millis, expected Integer but was " + value.getClass());
                }
                Integer timeMillis = (Integer)value;
                return jsonNodeFactory.numberNode(timeMillis);
            }
        });
        logicalTypeConverters.put("time-micros", new LogicalTypeConverter<LocalTime>((Conversion)new TimeConversions.TimeMicrosConversion()){

            @Override
            JsonNode toJson(Schema schema, Object value) {
                if (!(value instanceof Long)) {
                    throw new IllegalArgumentException("Invalid type for time-micros, expected Long but was " + value.getClass());
                }
                Long timeMicro = (Long)value;
                return jsonNodeFactory.numberNode(timeMicro);
            }
        });
        logicalTypeConverters.put("timestamp-millis", new LogicalTypeConverter<Instant>((Conversion)new TimeConversions.TimestampMillisConversion()){

            @Override
            JsonNode toJson(Schema schema, Object value) {
                if (!(value instanceof Long)) {
                    throw new IllegalArgumentException("Invalid type for timestamp-millis, expected Long but was " + value.getClass());
                }
                Long epochMillis = (Long)value;
                return jsonNodeFactory.numberNode(epochMillis);
            }
        });
        logicalTypeConverters.put("timestamp-micros", new LogicalTypeConverter<Instant>((Conversion)new TimeConversions.TimestampMicrosConversion()){

            @Override
            JsonNode toJson(Schema schema, Object value) {
                if (!(value instanceof Long)) {
                    throw new IllegalArgumentException("Invalid type for timestamp-micros, expected Long but was " + value.getClass());
                }
                Long epochMillis = (Long)value;
                return jsonNodeFactory.numberNode(epochMillis);
            }
        });
        logicalTypeConverters.put("uuid", new LogicalTypeConverter<UUID>((Conversion)new Conversions.UUIDConversion()){

            @Override
            JsonNode toJson(Schema schema, Object value) {
                return jsonNodeFactory.textNode(value == null ? null : value.toString());
            }
        });
    }

    static abstract class LogicalTypeConverter<T> {
        final Conversion<T> conversion;

        public LogicalTypeConverter(Conversion<T> conversion) {
            this.conversion = conversion;
        }

        abstract JsonNode toJson(Schema var1, Object var2);
    }
}

