/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.netty.tcp;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.netty.NettySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyTCPServerHandler
extends SimpleChannelInboundHandler<byte[]> {
    private static final Logger logger = LoggerFactory.getLogger(NettyTCPServerHandler.class);
    private final NettySource nettySource;

    public NettyTCPServerHandler(NettySource nettySource) {
        this.nettySource = nettySource;
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, byte[] bytes) throws Exception {
        this.nettySource.consume(new NettyTCPRecord(Optional.of(""), bytes));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Error when processing incoming data", cause);
        ctx.close();
    }

    private static class NettyTCPRecord
    implements Record<byte[]>,
    Serializable {
        private final Optional<String> key;
        private final byte[] value;

        @Generated
        public NettyTCPRecord(Optional<String> key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        @Generated
        public Optional<String> getKey() {
            return this.key;
        }

        @Generated
        public byte[] getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NettyTCPRecord)) {
                return false;
            }
            NettyTCPRecord other = (NettyTCPRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<String> this$key = this.getKey();
            Optional<String> other$key = other.getKey();
            if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NettyTCPRecord;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        @Generated
        public String toString() {
            return "NettyTCPServerHandler.NettyTCPRecord(key=" + this.getKey() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }
    }
}

