/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.discovery.multicast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.discovery.DiscoveryAgent;
import org.apache.qpid.jms.provider.discovery.DiscoveryListener;
import org.apache.qpid.jms.provider.discovery.multicast.DiscoveryEvent;
import org.apache.qpid.jms.provider.discovery.multicast.PacketParser;
import org.apache.qpid.jms.provider.exceptions.ProviderExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastDiscoveryAgent
implements DiscoveryAgent,
Runnable {
    public static final String DEFAULT_DISCOVERY_URI_STRING = "multicast://239.255.2.3:6155";
    public static final String DEFAULT_HOST_STR = "default";
    public static final String DEFAULT_HOST_IP = System.getProperty("qpidjms.partition.discovery", "239.255.2.3");
    public static final int DEFAULT_PORT = 6155;
    private static final Logger LOG = LoggerFactory.getLogger(MulticastDiscoveryAgent.class);
    private static final int BUFF_SIZE = 8192;
    private static final int DEFAULT_IDLE_TIME = 500;
    private static final int HEARTBEAT_MISS_BEFORE_DEATH = 10;
    private static final List<String> DEFAULT_EXCLUSIONS = new ArrayList<String>();
    private DiscoveryListener listener;
    private URI discoveryURI;
    private int timeToLive = 1;
    private boolean loopBackMode;
    private final Map<URI, RemoteBrokerData> brokersByService = new ConcurrentHashMap<URI, RemoteBrokerData>();
    private String group = "default";
    private InetAddress inetAddress;
    private SocketAddress sockAddress;
    private MulticastSocket mcast;
    private Thread runner;
    private long keepAliveInterval = 500L;
    private String mcInterface;
    private String mcNetworkInterface;
    private String mcJoinNetworkInterface;
    private String service;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private PacketParser parser;

    public MulticastDiscoveryAgent(URI discoveryURI) {
        this.discoveryURI = discoveryURI;
    }

    @Override
    public void setDiscoveryListener(DiscoveryListener listener) {
        this.listener = listener;
    }

    public DiscoveryListener getDiscoveryListener() {
        return this.listener;
    }

    @Override
    public void setScheduler(ScheduledExecutorService scheduler) {
    }

    @Override
    public boolean isSchedulerRequired() {
        return false;
    }

    @Override
    public void start() throws ProviderException, IllegalStateException {
        if (this.listener == null) {
            throw new IllegalStateException("No DiscoveryListener configured.");
        }
        if (this.started.compareAndSet(false, true)) {
            if (this.group == null || this.group.length() == 0) {
                throw new ProviderException("You must specify a group to discover");
            }
            if (this.discoveryURI == null) {
                try {
                    this.discoveryURI = new URI(DEFAULT_DISCOVERY_URI_STRING);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                if (this.discoveryURI == null) {
                    throw new RuntimeException("Discovery URI unexpectedly null");
                }
            }
            LOG.trace("mcast - discoveryURI = {}", (Object)this.discoveryURI);
            String myHost = this.discoveryURI.getHost();
            int myPort = this.discoveryURI.getPort();
            if (myHost == null || DEFAULT_HOST_STR.equals(myHost)) {
                myHost = DEFAULT_HOST_IP;
            }
            if (myPort < 0) {
                myPort = 6155;
            }
            LOG.trace("mcast - myHost = {}", (Object)myHost);
            LOG.trace("mcast - myPort = {}", (Object)myPort);
            LOG.trace("mcast - group = {}", (Object)this.group);
            LOG.trace("mcast - interface = {}", (Object)this.mcInterface);
            LOG.trace("mcast - network interface = {}", (Object)this.mcNetworkInterface);
            LOG.trace("mcast - join network interface = {}", (Object)this.mcJoinNetworkInterface);
            try {
                this.inetAddress = InetAddress.getByName(myHost);
                this.sockAddress = new InetSocketAddress(this.inetAddress, myPort);
                this.mcast = new MulticastSocket(myPort);
                this.mcast.setLoopbackMode(this.loopBackMode);
                this.mcast.setTimeToLive(this.getTimeToLive());
                if (this.mcJoinNetworkInterface != null) {
                    this.mcast.joinGroup(this.sockAddress, NetworkInterface.getByName(this.mcJoinNetworkInterface));
                } else {
                    if (this.mcNetworkInterface != null) {
                        this.mcast.setNetworkInterface(NetworkInterface.getByName(this.mcNetworkInterface));
                    } else {
                        MulticastDiscoveryAgent.trySetNetworkInterface(this.mcast);
                    }
                    this.mcast.joinGroup(this.inetAddress);
                }
                this.mcast.setSoTimeout((int)this.keepAliveInterval);
                if (this.mcInterface != null) {
                    this.mcast.setInterface(InetAddress.getByName(this.mcInterface));
                }
                if (this.mcNetworkInterface != null) {
                    this.mcast.setNetworkInterface(NetworkInterface.getByName(this.mcNetworkInterface));
                }
            }
            catch (IOException e) {
                throw ProviderExceptionSupport.createOrPassthroughFatal((Throwable)e);
            }
            this.runner = new Thread(this);
            this.runner.setName(this.toString() + ":" + this.runner.getName());
            this.runner.setDaemon(true);
            this.runner.start();
        }
    }

    @Override
    public void close() {
        if (this.started.compareAndSet(true, false)) {
            if (this.mcast != null) {
                this.mcast.close();
            }
            if (this.runner != null) {
                this.runner.interrupt();
            }
        }
    }

    @Override
    public void suspend() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void run() {
        byte[] buf = new byte[8192];
        DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
        while (this.started.get()) {
            this.expireOldServices();
            try {
                DiscoveryEvent event;
                this.mcast.receive(packet);
                if (packet.getLength() <= 0 || (event = this.parser.processPacket(packet.getData(), packet.getOffset(), packet.getLength())) == null) continue;
                if (event.getType() == DiscoveryEvent.EventType.ALIVE) {
                    this.processAlive(event);
                    continue;
                }
                this.processShutdown(event);
            }
            catch (SocketTimeoutException event) {
            }
            catch (IOException e) {
                if (!this.started.get()) continue;
                LOG.error("failed to process packet: {}", (Object)e.getMessage());
                LOG.trace(" packet processing failed by: {}", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "MulticastDiscoveryAgent: listener:" + this.getDiscvoeryURI();
    }

    private void processAlive(DiscoveryEvent event) {
        RemoteBrokerData data = this.brokersByService.get(event.getPeerUri());
        if (data == null) {
            URI peerUri = event.getPeerUri();
            data = new RemoteBrokerData(event.getPeerUri());
            this.brokersByService.put(peerUri, data);
            this.fireServiceAddEvent(data);
        } else {
            data.updateHeartBeat();
        }
    }

    private void processShutdown(DiscoveryEvent event) {
        RemoteBrokerData data = this.brokersByService.remove(event.getPeerUri());
        if (data != null) {
            this.fireServiceRemovedEvent(data);
        }
    }

    private void expireOldServices() {
        long expireTime = System.currentTimeMillis() - this.keepAliveInterval * 10L;
        for (RemoteBrokerData data : this.brokersByService.values()) {
            if (data.getLastHeartBeat() >= expireTime) continue;
            this.processShutdown(data.asShutdownEvent());
        }
    }

    private void fireServiceRemovedEvent(RemoteBrokerData data) {
        if (this.listener != null && this.started.get()) {
            this.listener.onServiceRemove(data.getPeerUri());
        }
    }

    private void fireServiceAddEvent(RemoteBrokerData data) {
        if (this.listener != null && this.started.get()) {
            this.listener.onServiceAdd(data.getPeerUri());
        }
    }

    public URI getDiscvoeryURI() {
        return this.discoveryURI;
    }

    public boolean isLoopBackMode() {
        return this.loopBackMode;
    }

    public void setLoopBackMode(boolean loopBackMode) {
        this.loopBackMode = loopBackMode;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public long getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(long keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public void setInterface(String mcInterface) {
        this.mcInterface = mcInterface;
    }

    public void setNetworkInterface(String mcNetworkInterface) {
        this.mcNetworkInterface = mcNetworkInterface;
    }

    public void setJoinNetworkInterface(String mcJoinNetwrokInterface) {
        this.mcJoinNetworkInterface = mcJoinNetwrokInterface;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String name) {
        this.service = name;
    }

    public PacketParser getParser() {
        return this.parser;
    }

    public void setParser(PacketParser parser) {
        this.parser = parser;
    }

    public static void trySetNetworkInterface(MulticastSocket mcastSock) throws SocketException {
        List<NetworkInterface> interfaces = MulticastDiscoveryAgent.findNetworkInterfaces();
        SocketException lastError = null;
        boolean found = false;
        for (NetworkInterface networkInterface : interfaces) {
            try {
                mcastSock.setNetworkInterface(networkInterface);
                LOG.debug("Configured mcast socket {} to network interface {}", (Object)mcastSock, (Object)networkInterface);
                found = true;
                break;
            }
            catch (SocketException error) {
                lastError = error;
            }
        }
        if (!found) {
            if (lastError != null) {
                throw lastError;
            }
            throw new SocketException("No NetworkInterface available for this socket.");
        }
    }

    private static List<NetworkInterface> findNetworkInterfaces() throws SocketException {
        Enumeration<NetworkInterface> ifcs = NetworkInterface.getNetworkInterfaces();
        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>();
        block0: while (ifcs.hasMoreElements()) {
            NetworkInterface ni = ifcs.nextElement();
            LOG.trace("findNetworkInterfaces checking interface: {}", (Object)ni);
            if (!ni.supportsMulticast() || !ni.isUp()) continue;
            for (InterfaceAddress ia : ni.getInterfaceAddresses()) {
                if (!(ia.getAddress() instanceof Inet4Address) || ia.getAddress().isLoopbackAddress() || DEFAULT_EXCLUSIONS.contains(ni.getName())) continue;
                interfaces.add(0, ni);
                continue block0;
            }
        }
        LOG.trace("findNetworkInterfaces returning: {}", interfaces);
        return interfaces;
    }

    static {
        DEFAULT_EXCLUSIONS.add("vnic");
        DEFAULT_EXCLUSIONS.add("tun0");
    }

    private static class RemoteBrokerData
    extends DiscoveryEvent {
        long lastHeartBeat = System.currentTimeMillis();

        public RemoteBrokerData(URI peerUri) {
            super(peerUri, DiscoveryEvent.EventType.ALIVE);
        }

        public DiscoveryEvent asShutdownEvent() {
            return new DiscoveryEvent(this.getPeerUri(), DiscoveryEvent.EventType.SHUTDOWN);
        }

        public synchronized void updateHeartBeat() {
            this.lastHeartBeat = System.currentTimeMillis();
        }

        public synchronized long getLastHeartBeat() {
            return this.lastHeartBeat;
        }
    }
}

