/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.social.Mandatory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractGadgetData {
    private static final Object[] EMPTY_OBJECT = new Object[0];
    private static final String EXCLUDED_GETTER = "class";
    private static final Pattern GETTER = Pattern.compile("^get([a-zA-Z]+)$");

    public JSONObject toJson() {
        Method[] methods;
        JSONObject toReturn = new JSONObject();
        for (Method method : methods = this.getClass().getMethods()) {
            String errorMessage = "Could not encode the " + method + " method.";
            try {
                this.putAttribute(toReturn, method, method.getAnnotation(Mandatory.class) != null);
            }
            catch (JSONException e) {
                throw new RuntimeException(errorMessage, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(errorMessage, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(errorMessage, e);
            }
        }
        return toReturn;
    }

    private void putAttribute(JSONObject object, Method method, boolean mandatory) throws JSONException, IllegalAccessException, InvocationTargetException {
        Matcher matcher = GETTER.matcher(method.getName());
        if (!matcher.matches()) {
            return;
        }
        String name = matcher.group();
        String fieldName = name.substring(3, 4).toLowerCase() + name.substring(4);
        if (fieldName.equalsIgnoreCase(EXCLUDED_GETTER)) {
            return;
        }
        Object val = method.invoke((Object)this, EMPTY_OBJECT);
        if (val != null) {
            object.put(fieldName, this.translateObjectToJson(val));
        } else if (mandatory) {
            throw new RuntimeException(fieldName + " is a mandory value, it should not be null");
        }
    }

    private Object translateObjectToJson(Object val) throws JSONException {
        if (val instanceof AbstractGadgetData[]) {
            JSONArray array = new JSONArray();
            for (AbstractGadgetData asd : (AbstractGadgetData[])val) {
                array.put(this.translateObjectToJson(asd));
            }
            return array;
        }
        if (val instanceof List) {
            JSONArray list = new JSONArray();
            for (Object item : (List)val) {
                list.put(this.translateObjectToJson(item));
            }
            return list;
        }
        if (val instanceof Map) {
            JSONObject map = new JSONObject();
            Map originalMap = (Map)val;
            for (Object item : originalMap.keySet()) {
                map.put(item.toString(), this.translateObjectToJson(originalMap.get(item)));
            }
            return map;
        }
        if (val instanceof AbstractGadgetData) {
            return ((AbstractGadgetData)val).toJson();
        }
        return val;
    }
}

