/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.gadgets.GadgetTokenDecoder;
import org.apache.shindig.gadgets.http.InjectedServlet;
import org.apache.shindig.social.DataResponse;
import org.apache.shindig.social.GadgetDataHandler;
import org.apache.shindig.social.RequestItem;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.ResponseItem;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetDataServlet
extends InjectedServlet {
    private static final Logger logger = Logger.getLogger("org.apache.shindig.social");
    private List<GadgetDataHandler> handlers;
    private GadgetTokenDecoder gadgetTokenDecoder;

    @Inject
    public void setGadgetDataHandlers(List<GadgetDataHandler> handlers) {
        this.handlers = handlers;
    }

    @Inject
    public void setGadgetTokenDecoder(GadgetTokenDecoder gadgetTokenDecoder) {
        this.gadgetTokenDecoder = gadgetTokenDecoder;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        DataResponse response;
        req.setCharacterEncoding("UTF-8");
        String requestParam = req.getParameter("request");
        String token = req.getParameter("st");
        try {
            response = new DataResponse(this.createResponse(requestParam, token));
        }
        catch (JSONException e) {
            response = new DataResponse(ResponseError.BAD_REQUEST);
        }
        catch (GadgetException e) {
            logger.info("Request was made with invalid security token: " + token);
            response = new DataResponse(ResponseError.BAD_REQUEST);
        }
        resp.setContentType("application/json; charset=utf-8");
        PrintWriter writer = resp.getWriter();
        writer.write(response.toJson().toString());
    }

    private List<ResponseItem> createResponse(String requestParam, String token) throws JSONException, GadgetException {
        if (token == null || token.trim().length() == 0) {
            throw new GadgetException(GadgetException.Code.INVALID_GADGET_TOKEN);
        }
        GadgetToken securityToken = this.gadgetTokenDecoder.createToken(token);
        ArrayList<ResponseItem> responseItems = new ArrayList<ResponseItem>();
        JSONArray requestItems = new JSONArray(requestParam);
        int length = requestItems.length();
        for (int i = 0; i < length; ++i) {
            JSONObject jsonRequest = requestItems.getJSONObject(i);
            RequestItem requestItem = new RequestItem(jsonRequest.getString("type"), jsonRequest, securityToken);
            ResponseItem response = new ResponseItem(ResponseError.NOT_IMPLEMENTED, requestItem.getType() + " has not been implemented yet.", new JSONObject());
            for (GadgetDataHandler handler : this.handlers) {
                if (!handler.shouldHandle(requestItem.getType())) continue;
                response = handler.handleRequest(requestItem);
            }
            responseItems.add(response);
        }
        return responseItems;
    }
}

