/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.social.GadgetDataHandler;
import org.apache.shindig.social.opensocial.ActivitiesService;
import org.apache.shindig.social.opensocial.DataService;
import org.apache.shindig.social.opensocial.OpenSocialDataHandler;
import org.apache.shindig.social.opensocial.PeopleService;
import org.apache.shindig.social.samplecontainer.BasicActivitiesService;
import org.apache.shindig.social.samplecontainer.BasicDataService;
import org.apache.shindig.social.samplecontainer.BasicPeopleService;
import org.apache.shindig.social.samplecontainer.StateFileDataHandler;

public class SocialApiGuiceModule
extends AbstractModule {
    protected void configure() {
        this.bind(PeopleService.class).to(BasicPeopleService.class);
        this.bind(DataService.class).to(BasicDataService.class);
        this.bind(ActivitiesService.class).to(BasicActivitiesService.class);
        this.bind((TypeLiteral)new TypeLiteral<List<GadgetDataHandler>>(){}).toProvider(GadgetDataHandlersProvider.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GadgetDataHandlersProvider
    implements Provider<List<GadgetDataHandler>> {
        List<GadgetDataHandler> handlers = new ArrayList<GadgetDataHandler>();

        @Inject
        public GadgetDataHandlersProvider(OpenSocialDataHandler openSocialDataHandler, StateFileDataHandler stateFileHandler) {
            this.handlers.add(openSocialDataHandler);
            this.handlers.add(stateFileHandler);
        }

        public List<GadgetDataHandler> get() {
            return this.handlers;
        }
    }
}

