/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.social.GadgetDataHandler;
import org.apache.shindig.social.RequestItem;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.ResponseItem;
import org.apache.shindig.social.opensocial.ActivitiesService;
import org.apache.shindig.social.opensocial.DataService;
import org.apache.shindig.social.opensocial.PeopleService;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.IdSpec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenSocialDataHandler
implements GadgetDataHandler {
    private static final Logger logger = Logger.getLogger("org.apache.shindig.social");
    private PeopleService peopleHandler;
    private DataService dataHandler;
    private ActivitiesService activitiesHandler;

    @Inject
    public OpenSocialDataHandler(PeopleService peopleHandler, DataService dataHandler, ActivitiesService activitiesHandler) {
        this.peopleHandler = peopleHandler;
        this.dataHandler = dataHandler;
        this.activitiesHandler = activitiesHandler;
    }

    public boolean shouldHandle(String requestType) {
        try {
            OpenSocialDataType.valueOf(requestType);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public ResponseItem handleRequest(RequestItem request) {
        OpenSocialDataType type = OpenSocialDataType.valueOf(request.getType());
        ResponseItem<Object> response = new ResponseItem<JSONObject>(ResponseError.NOT_IMPLEMENTED, request.getType() + " has not been implemented yet.", new JSONObject());
        try {
            JSONObject params = request.getParams();
            String jsonSpec = params.getString("idSpec");
            List<String> peopleIds = this.peopleHandler.getIds(IdSpec.fromJson(jsonSpec), request.getToken());
            switch (type) {
                case FETCH_PEOPLE: {
                    JSONArray profileDetail = params.getJSONArray("profileDetail");
                    HashSet<String> profileDetailFields = new HashSet<String>(profileDetail.length() + 1, 1.0f);
                    for (int i = 0; i < profileDetail.length(); ++i) {
                        profileDetailFields.add(profileDetail.getString(i));
                    }
                    PeopleService.SortOrder sortOrder = PeopleService.SortOrder.valueOf(params.getString("sortOrder"));
                    PeopleService.FilterType filter = PeopleService.FilterType.valueOf(params.getString("filter"));
                    int first = params.getInt("first");
                    int max = params.getInt("max");
                    response = this.peopleHandler.getPeople(peopleIds, sortOrder, filter, first, max, profileDetailFields, request.getToken());
                    break;
                }
                case FETCH_PERSON_APP_DATA: {
                    JSONArray jsonKeys = params.getJSONArray("keys");
                    ArrayList<String> keys = new ArrayList<String>(jsonKeys.length());
                    for (int i = 0; i < jsonKeys.length(); ++i) {
                        keys.add(jsonKeys.getString(i));
                    }
                    response = this.dataHandler.getPersonData(peopleIds, keys, request.getToken());
                    break;
                }
                case UPDATE_PERSON_APP_DATA: {
                    String id = peopleIds.get(0);
                    String key = params.getString("key");
                    String value = params.getString("value");
                    response = this.dataHandler.updatePersonData(id, key, value, request.getToken());
                    break;
                }
                case FETCH_ACTIVITIES: {
                    response = this.activitiesHandler.getActivities(peopleIds, request.getToken());
                    break;
                }
                case CREATE_ACTIVITY: {
                    String personId = peopleIds.get(0);
                    Activity activity = new Activity("5", personId);
                    activity.setTitle("Temporary title - we don't read json right now");
                    response = this.activitiesHandler.createActivity(personId, activity, request.getToken());
                }
            }
        }
        catch (JSONException e) {
            logger.log(Level.INFO, e.getMessage());
            response = new ResponseItem<JSONObject>(ResponseError.BAD_REQUEST, "The json request had a bad format", new JSONObject());
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.INFO, e.getMessage());
            response = new ResponseItem<JSONObject>(ResponseError.BAD_REQUEST, "The json request had a bad idSpec", new JSONObject());
        }
        return response;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpenSocialDataType {
        FETCH_PEOPLE,
        FETCH_PERSON_APP_DATA,
        UPDATE_PERSON_APP_DATA,
        FETCH_ACTIVITIES,
        CREATE_ACTIVITY;

    }
}

