/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.model;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdSpec {
    String jsonSpec;
    Type type;

    public IdSpec(String jsonSpec, Type type) {
        this.jsonSpec = jsonSpec;
        this.type = type;
    }

    public static IdSpec fromJson(String jsonIdSpec) throws IllegalArgumentException {
        Type idSpecEnum = Type.valueOf(jsonIdSpec);
        if (idSpecEnum == null) {
            idSpecEnum = Type.USER_IDS;
        }
        return new IdSpec(jsonIdSpec, idSpecEnum);
    }

    public List<String> fetchUserIds() throws JSONException {
        JSONArray userIdArray = new JSONArray(this.jsonSpec);
        ArrayList<String> userIds = new ArrayList<String>(userIdArray.length());
        for (int i = 0; i < userIdArray.length(); ++i) {
            userIds.add(userIdArray.getString(i));
        }
        return userIds;
    }

    public Type getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        VIEWER,
        OWNER,
        VIEWER_FRIENDS,
        OWNER_FRIENDS,
        USER_IDS;

    }
}

