/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.samplecontainer;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.social.ResponseItem;
import org.apache.shindig.social.opensocial.ActivitiesService;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.samplecontainer.XmlStateFileFetcher;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicActivitiesService
implements ActivitiesService {
    private XmlStateFileFetcher fetcher;

    @Inject
    public BasicActivitiesService(XmlStateFileFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public ResponseItem<List<Activity>> getActivities(List<String> ids, GadgetToken token) {
        Map<String, List<Activity>> allActivities = this.fetcher.getActivities();
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (String id : ids) {
            List<Activity> personActivities = allActivities.get(id);
            if (personActivities == null) continue;
            activities.addAll(personActivities);
        }
        return new ResponseItem<List<Activity>>(activities);
    }

    @Override
    public ResponseItem createActivity(String personId, Activity activity, GadgetToken token) {
        activity.setUserId(personId);
        activity.setPostedTime(new Date().getTime());
        this.fetcher.createActivity(personId, activity);
        return new ResponseItem<JSONObject>(new JSONObject());
    }
}

