/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.samplecontainer;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.ResponseItem;
import org.apache.shindig.social.opensocial.DataService;
import org.apache.shindig.social.samplecontainer.XmlStateFileFetcher;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDataService
implements DataService {
    private XmlStateFileFetcher fetcher;

    @Inject
    public BasicDataService(XmlStateFileFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public ResponseItem<Map<String, Map<String, String>>> getPersonData(List<String> ids, List<String> keys, GadgetToken token) {
        Map<String, Map<String, String>> allData = this.fetcher.getAppData();
        HashMap data = new HashMap(ids.size(), 1.0f);
        for (String id : ids) {
            Map<String, String> allPersonData = allData.get(id);
            if (allPersonData == null) continue;
            HashMap<String, String> personData = new HashMap<String, String>();
            for (String key : allPersonData.keySet()) {
                if (!keys.contains(key)) continue;
                personData.put(key, allPersonData.get(key));
            }
            data.put(id, personData);
        }
        return new ResponseItem<Map<String, Map<String, String>>>(data);
    }

    @Override
    public ResponseItem updatePersonData(String id, String key, String value, GadgetToken token) {
        if (!BasicDataService.isValidKey(key)) {
            return new ResponseItem<JSONObject>(ResponseError.BAD_REQUEST, "The person data key had invalid characters", new JSONObject());
        }
        this.fetcher.setAppData(id, key, value);
        return new ResponseItem<JSONObject>(new JSONObject());
    }

    public static boolean isValidKey(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.') continue;
            return false;
        }
        return true;
    }
}

