/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.samplecontainer;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.social.ResponseItem;
import org.apache.shindig.social.opensocial.PeopleService;
import org.apache.shindig.social.opensocial.model.ApiCollection;
import org.apache.shindig.social.opensocial.model.IdSpec;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.samplecontainer.XmlStateFileFetcher;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPeopleService
implements PeopleService {
    private static final Comparator<Person> NAME_COMPARATOR = new Comparator<Person>(){

        @Override
        public int compare(Person person, Person person1) {
            String name = person.getName().getUnstructured();
            String name1 = person1.getName().getUnstructured();
            return name.compareTo(name1);
        }
    };
    private XmlStateFileFetcher fetcher;

    @Inject
    public BasicPeopleService(XmlStateFileFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public ResponseItem<ApiCollection<Person>> getPeople(List<String> ids, PeopleService.SortOrder sortOrder, PeopleService.FilterType filter, int first, int max, Set<String> profileDetails, GadgetToken token) {
        Map<String, Person> allPeople = this.fetcher.getAllPeople();
        List<Person> people = new ArrayList();
        for (String id : ids) {
            Person person = allPeople.get(id);
            if (person == null) continue;
            if (id.equals(token.getViewerId())) {
                person.setIsViewer(true);
            }
            if (id.equals(token.getOwnerId())) {
                person.setIsOwner(true);
            }
            people.add(person);
        }
        if (sortOrder.equals((Object)PeopleService.SortOrder.name)) {
            Collections.sort(people, NAME_COMPARATOR);
        }
        int totalSize = people.size();
        int last = first + max;
        people = people.subList(first, Math.min(last, totalSize));
        ApiCollection collection = new ApiCollection(people, first, totalSize);
        return new ResponseItem<ApiCollection<Person>>(collection);
    }

    @Override
    public List<String> getIds(IdSpec idSpec, GadgetToken token) throws JSONException {
        Map<String, List<String>> friendIds = this.fetcher.getFriendIds();
        ArrayList<String> ids = new ArrayList<String>();
        switch (idSpec.getType()) {
            case OWNER: {
                ids.add(token.getOwnerId());
                break;
            }
            case VIEWER: {
                ids.add(token.getViewerId());
                break;
            }
            case OWNER_FRIENDS: {
                ids.addAll((Collection<String>)friendIds.get(token.getOwnerId()));
                break;
            }
            case VIEWER_FRIENDS: {
                ids.addAll((Collection<String>)friendIds.get(token.getViewerId()));
                break;
            }
            case USER_IDS: {
                ids.addAll(idSpec.fetchUserIds());
            }
        }
        return ids;
    }
}

