/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.samplecontainer;

import com.google.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.social.GadgetDataHandler;
import org.apache.shindig.social.RequestItem;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.ResponseItem;
import org.apache.shindig.social.samplecontainer.XmlStateFileFetcher;
import org.json.JSONException;
import org.json.JSONObject;

public class StateFileDataHandler
implements GadgetDataHandler {
    private XmlStateFileFetcher fetcher;

    @Inject
    public StateFileDataHandler(XmlStateFileFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public boolean shouldHandle(String requestType) {
        try {
            RequestType.valueOf(requestType);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public ResponseItem handleRequest(RequestItem request) {
        RequestType type = RequestType.valueOf(request.getType());
        ResponseItem<Object> response = null;
        switch (type) {
            case DUMP_STATE: {
                HashMap<String, Map<String, Object>> state = new HashMap<String, Map<String, Object>>();
                state.put("people", this.fetcher.getAllPeople());
                state.put("friendIds", this.fetcher.getFriendIds());
                state.put("data", this.fetcher.getAppData());
                state.put("activities", this.fetcher.getActivities());
                response = new ResponseItem(state);
                break;
            }
            case SET_STATE: {
                try {
                    String stateFile = request.getParams().getString("fileUrl");
                    this.fetcher.resetStateFile(new URI(stateFile));
                    response = new ResponseItem<JSONObject>(new JSONObject());
                }
                catch (URISyntaxException e) {
                    response = new ResponseItem<JSONObject>(ResponseError.BAD_REQUEST, "The state file was not a valid url", new JSONObject());
                }
                catch (JSONException e) {
                    response = new ResponseItem<JSONObject>(ResponseError.BAD_REQUEST, "The request did not have a valid fileUrl parameter", new JSONObject());
                }
                break;
            }
            case SET_EVILNESS: {
                try {
                    boolean doEvil = request.getParams().getBoolean("doEvil");
                    this.fetcher.setEvilness(doEvil);
                    response = new ResponseItem<JSONObject>(new JSONObject());
                    break;
                }
                catch (JSONException e) {
                    response = new ResponseItem<JSONObject>(ResponseError.BAD_REQUEST, "The request did not have a valid doEvil parameter", new JSONObject());
                }
            }
        }
        return response;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestType {
        DUMP_STATE,
        SET_STATE,
        SET_EVILNESS;

    }
}

