/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.samplecontainer;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.RemoteContent;
import org.apache.shindig.gadgets.RemoteContentRequest;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Enum;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.model.Phone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XmlStateFileFetcher {
    private static final String DEFAULT_STATE_URL = "http://localhost:8080/gadgets/files/samplecontainer/state-basicfriendlist.xml";
    private static final String REDEFINE_NEW_DATA_REQUEST = "opensocial.newDataRequest = function() { alert('Ha! I attacked you!')}; ";
    private static final String MAKE_PAGE_RED = "document.body.style.backgroundColor = 'red'; ";
    private static final String SCRIPT_PREFIX = "<div onMouseOver=\"opensocial.newDataRequest = function() { alert('Ha! I attacked you!')}; document.body.style.backgroundColor = 'red'; \">";
    private static final String SCRIPT_SUFFIX = "</div>";
    private ContentFetcher fetcher;
    private URI stateFile;
    private Document document;
    private boolean doEvil = false;
    private Map<String, Map<String, String>> allData;
    private Map<String, List<String>> friendIdMap;
    private Map<String, Person> allPeople;
    private Map<String, List<Activity>> allActivities;

    @Inject
    public XmlStateFileFetcher(ContentFetcher fetcher) {
        this.fetcher = fetcher;
        try {
            this.stateFile = new URI(DEFAULT_STATE_URL);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("The default state file could not be fetched. ", e);
        }
    }

    public void resetStateFile(URI stateFile) {
        this.stateFile = stateFile;
        this.document = null;
        this.allData = null;
        this.friendIdMap = null;
        this.allPeople = null;
        this.allActivities = null;
    }

    public void setEvilness(boolean doEvil) {
        this.doEvil = doEvil;
    }

    private Document fetchStateDocument() {
        if (this.document != null) {
            return this.document;
        }
        RemoteContent xml = null;
        try {
            xml = this.fetcher.fetch(new RemoteContentRequest(this.stateFile));
        }
        catch (GadgetException e) {
            throw new RuntimeException(e);
        }
        InputSource is = new InputSource(new StringReader(xml.getResponseAsString()));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        String errorMessage = "The state file " + this.stateFile + " could not be fetched and parsed.";
        try {
            this.document = factory.newDocumentBuilder().parse(is);
            return this.document;
        }
        catch (SAXException e) {
            throw new RuntimeException(errorMessage, e);
        }
        catch (IOException e) {
            throw new RuntimeException(errorMessage, e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(errorMessage, e);
        }
    }

    private String turnEvil(String originalString) {
        if (this.doEvil) {
            return SCRIPT_PREFIX + originalString + SCRIPT_SUFFIX;
        }
        return originalString;
    }

    public Map<String, Map<String, String>> getAppData() {
        if (this.allData == null) {
            this.setupAppData();
        }
        return this.allData;
    }

    private void setupAppData() {
        this.allData = new HashMap<String, Map<String, String>>();
        Element root = this.fetchStateDocument().getDocumentElement();
        NodeList elements = root.getElementsByTagName("personAppData");
        NodeList personDataNodes = elements.item(0).getChildNodes();
        for (int i = 0; i < personDataNodes.getLength(); ++i) {
            Node personDataNode = personDataNodes.item(i);
            NamedNodeMap attributes = personDataNode.getAttributes();
            if (attributes == null) continue;
            String id = attributes.getNamedItem("person").getNodeValue();
            String field = attributes.getNamedItem("field").getNodeValue();
            String value = personDataNode.getTextContent();
            Map<String, String> currentData = this.allData.get(id);
            if (currentData == null) {
                currentData = new HashMap<String, String>();
                this.allData.put(id, currentData);
            }
            currentData.put(field, this.turnEvil(value));
        }
    }

    public void setAppData(String id, String key, String value) {
        Map<String, String> personData;
        if (this.allData == null) {
            this.setupAppData();
        }
        if ((personData = this.allData.get(id)) == null) {
            personData = new HashMap<String, String>();
            this.allData.put(id, personData);
        }
        personData.put(key, value);
    }

    public Map<String, List<String>> getFriendIds() {
        if (this.friendIdMap == null) {
            this.setupPeopleData();
        }
        return this.friendIdMap;
    }

    public Map<String, Person> getAllPeople() {
        if (this.allPeople == null) {
            this.setupPeopleData();
        }
        return this.allPeople;
    }

    private void setupPeopleData() {
        Element root = this.fetchStateDocument().getDocumentElement();
        this.allPeople = new HashMap<String, Person>();
        this.friendIdMap = new HashMap<String, List<String>>();
        this.setupPeopleInXmlTag(root, "people");
    }

    private void setupPeopleInXmlTag(Element root, String tagName) {
        NodeList elements = root.getElementsByTagName(tagName);
        if (elements == null || elements.item(0) == null) {
            return;
        }
        NodeList personNodes = elements.item(0).getChildNodes();
        for (int i = 0; i < personNodes.getLength(); ++i) {
            Node genderItem;
            Node personNode = personNodes.item(i);
            NamedNodeMap attributes = personNode.getAttributes();
            if (attributes == null) continue;
            String name = attributes.getNamedItem("name").getNodeValue();
            String id = attributes.getNamedItem("id").getNodeValue();
            Person person = new Person(id, new Name(this.turnEvil(name)));
            Node phoneItem = attributes.getNamedItem("phone");
            if (phoneItem != null) {
                String phone = phoneItem.getNodeValue();
                ArrayList<Phone> phones = new ArrayList<Phone>();
                phones.add(new Phone(this.turnEvil(phone), null));
                person.setPhoneNumbers(phones);
            }
            if ((genderItem = attributes.getNamedItem("gender")) != null) {
                String gender = genderItem.getNodeValue();
                if ("F".equals(gender)) {
                    person.setGender(new Enum<Enum.Gender>(Enum.Gender.FEMALE));
                } else if ("M".equals(gender)) {
                    person.setGender(new Enum<Enum.Gender>(Enum.Gender.MALE));
                }
            }
            this.allPeople.put(id, person);
            this.friendIdMap.put(id, this.getFriends(personNode));
        }
    }

    private List<String> getFriends(Node personNode) {
        ArrayList<String> friends = new ArrayList<String>();
        NodeList friendNodes = personNode.getChildNodes();
        for (int j = 0; j < friendNodes.getLength(); ++j) {
            String friendId = friendNodes.item(j).getTextContent();
            if (friendId == null || friendId.trim().length() == 0) continue;
            friends.add(friendId.trim());
        }
        return friends;
    }

    public Map<String, List<Activity>> getActivities() {
        if (this.allActivities == null) {
            this.setupActivities();
        }
        return this.allActivities;
    }

    private void setupActivities() {
        this.allActivities = new HashMap<String, List<Activity>>();
        Element root = this.fetchStateDocument().getDocumentElement();
        NodeList activitiesElements = root.getElementsByTagName("activities");
        if (activitiesElements != null && activitiesElements.item(0) != null) {
            NodeList streamItems = activitiesElements.item(0).getChildNodes();
            for (int i = 0; i < streamItems.getLength(); ++i) {
                Node streamItem = streamItems.item(i);
                NamedNodeMap streamParams = streamItem.getAttributes();
                String streamTitle = "";
                String userId = "";
                if (streamParams != null) {
                    streamTitle = streamParams.getNamedItem("title").getNodeValue();
                    userId = streamParams.getNamedItem("userId").getNodeValue();
                }
                this.createActivities(streamItem, userId, streamTitle);
            }
        }
    }

    private void createActivities(Node streamItem, String userId, String streamTitle) {
        NodeList activityItems = streamItem.getChildNodes();
        if (activityItems != null) {
            for (int i = 0; i < activityItems.getLength(); ++i) {
                Node activityItem = activityItems.item(i);
                NamedNodeMap activityParams = activityItem.getAttributes();
                if (activityParams == null) continue;
                String title = activityParams.getNamedItem("title").getNodeValue();
                String body = activityParams.getNamedItem("body").getNodeValue();
                String id = activityParams.getNamedItem("id").getNodeValue();
                Activity activity = new Activity(id, userId);
                activity.setStreamTitle(this.turnEvil(streamTitle));
                activity.setTitle(this.turnEvil(title));
                activity.setBody(this.turnEvil(body));
                activity.setMediaItems(this.getMediaItems(activityItem));
                this.createActivity(userId, activity);
            }
        }
    }

    private List<MediaItem> getMediaItems(Node activityItem) {
        ArrayList<MediaItem> media = new ArrayList<MediaItem>();
        NodeList mediaItems = activityItem.getChildNodes();
        if (mediaItems != null) {
            for (int i = 0; i < mediaItems.getLength(); ++i) {
                NamedNodeMap mediaParams = mediaItems.item(i).getAttributes();
                if (mediaParams == null) continue;
                String typeString = mediaParams.getNamedItem("type").getNodeValue();
                String mimeType = mediaParams.getNamedItem("mimeType").getNodeValue();
                String url = mediaParams.getNamedItem("url").getNodeValue();
                media.add(new MediaItem(mimeType, MediaItem.Type.valueOf(typeString), url));
            }
        }
        return media;
    }

    public void createActivity(String userId, Activity activity) {
        if (this.allActivities == null) {
            this.setupActivities();
        }
        if (this.allActivities.get(userId) == null) {
            this.allActivities.put(userId, new ArrayList());
        }
        this.allActivities.get(userId).add(activity);
    }
}

